/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.messageinflow;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Set;

public class CheckActivationSpecClass
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getInBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.messageinflow.notApp", "Resource Adapter does not provide inbound communication"));
            return result;
        }
        InboundResourceAdapter ra = descriptor.getInboundResourceAdapter();
        Set msgListeners = ra.getMessageListeners();
        boolean oneFailed = false;
        for (MessageListener msgListener : msgListeners) {
            String impl = msgListener.getActivationSpecClass();
            Class<?> implClass = null;
            try {
                implClass = Class.forName(impl, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.messageinflow.nonexist", "Error: The class [ {0} ] as defined under activationspec-class in the deployment descriptor does not exist", new Object[]{impl}));
                return result;
            }
            if (CheckActivationSpecClass.isImplementorOf(implClass, "javax.resource.spi.ActivationSpec")) continue;
            oneFailed = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: activationspec-class [ {0} ] does not implement javax.resource.spi.ActivationSpec.", new Object[]{impl}));
            return result;
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all activationspec-class implement javax.resource.spi.ActivationSpec"));
        }
        return result;
    }
}

