/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

class ConnectorModuleLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private ConnectorDescriptor connectorDescriptor = null;

    ConnectorModuleLoader(String modID, ClassLoader parentClassLoader, ConnectorModulesManager connModulesManager) {
        super(modID, parentClassLoader, connModulesManager);
        this.setConnectorDescriptor(modID);
    }

    boolean load() {
        try {
            ConnectorRuntime cr = ConnectorRuntime.getRuntime();
            cr.initialize(1);
            cr.createActiveResourceAdapter(this.configManager.getLocation(this.id), this.id);
            return true;
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, "loader.configexception", e);
            return false;
        }
        catch (ConnectorRuntimeException ex) {
            _logger.log(Level.WARNING, "Failed to load the rar", ex);
            return false;
        }
    }

    boolean doLoad(boolean jsr77) {
        this.notifyAppEvent(0);
        if (this.load()) {
            try {
                this.createLeafMBeans();
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "loader.exception", mbe);
            }
            return true;
        }
        return false;
    }

    boolean unload() {
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        try {
            connectorRuntime.destroyActiveResourceAdapter(this.id, this.cascade);
            this.configManager.unregisterDescriptor(this.id);
        }
        catch (ConnectorRuntimeException cre) {
            return false;
        }
        return true;
    }

    boolean unload(boolean jsr77) {
        if (this.unload()) {
            try {
                this.deleteLeafMBeans();
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "loader.exception", mbe);
            }
            return true;
        }
        return false;
    }

    private void setConnectorDescriptor(String modID) {
        try {
            this.application = this.configManager.getDescriptor(modID, null, false);
            this.connectorDescriptor = (ConnectorDescriptor)this.application.getStandaloneBundleDescriptor();
        }
        catch (ConfigException ex) {
            _logger.log(Level.WARNING, "Failed to get the module directory ");
        }
    }

    public ConnectorDescriptor getConnectorDescriptor() {
        return this.connectorDescriptor;
    }

    void createRootMBean() throws MBeanException {
        try {
            Switch.getSwitch().getManagementObjectManager().createRARModuleMBean(this.connectorDescriptor, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    void deleteRootMBean() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().deleteRARModuleMBean(this.connectorDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void createLeafMBeans() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().createRARMBeans(this.connectorDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void createLeafMBean(Descriptor descriptor) throws MBeanException {
        ConnectorDescriptor cd = null;
        try {
            cd = (ConnectorDescriptor)descriptor;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        Switch.getSwitch().getManagementObjectManager().createRARMBean(cd, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafMBeans() throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().deleteRARMBeans(this.connectorDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafMBean(Descriptor descriptor) throws MBeanException {
        ConnectorDescriptor cd = null;
        try {
            cd = (ConnectorDescriptor)descriptor;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        Switch.getSwitch().getManagementObjectManager().deleteRARMBean(cd, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafAndRootMBeans() throws MBeanException {
        this.deleteLeafMBeans();
        this.deleteRootMBean();
    }

    void setState(int state) throws MBeanException {
        Switch.getSwitch().getManagementObjectManager().setRARModuleState(state, this.connectorDescriptor, this.configManager.getInstanceEnvironment().getName());
    }
}

