/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.WSMonitorLifeCycleFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.security.Audit;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactory;
import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactoryImpl;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.ConnectorResourcesLoader;
import com.sun.enterprise.server.PersistenceUnitLoader;
import com.sun.enterprise.server.PersistenceUnitLoaderImpl;
import com.sun.enterprise.server.event.ApplicationEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventNotifier;
import com.sun.enterprise.server.event.EjbContainerEvent;
import com.sun.enterprise.server.ondemand.entry.EntryPoint;
import com.sun.enterprise.server.ondemand.entry.ServerEntryHelper;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanException;
import javax.naming.NameAlreadyBoundException;
import javax.persistence.EntityManagerFactory;

abstract class AbstractLoader
implements EntryPoint {
    protected String id = null;
    ClassLoader parentClassLoader = null;
    ClassLoader ejbClassLoader = null;
    Application application = null;
    protected boolean robFlag = false;
    protected ApplicationRegistry registry = null;
    protected BaseManager configManager = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private FactoryForSecurityManagerFactory ffsmf = null;
    protected boolean cascade = false;
    protected int loadUnloadAction;
    private ApplicationLoaderEventNotifier loaderEventNotifier;
    private ConfigContext dynamicConfigContext;

    AbstractLoader(String id, ClassLoader parentClassLoader, BaseManager configMgr) {
        this.id = id;
        this.parentClassLoader = parentClassLoader;
        this.registry = ApplicationRegistry.getInstance();
        this.configManager = configMgr;
        this.loaderEventNotifier = ApplicationLoaderEventNotifier.getInstance();
    }

    protected void initializeLoader(String[] classPaths, String moduleRoot, ModuleType moduleType) {
        this.ejbClassLoader = EJBClassPathUtils.createEJBClassLoader(classPaths, moduleRoot, this.id, this.parentClassLoader, moduleType);
    }

    protected void initializeLoader(ClassLoader clazzloader) {
        this.ejbClassLoader = clazzloader;
    }

    void setConfigContext(ConfigContext dynamicConfigContext) {
        this.dynamicConfigContext = dynamicConfigContext;
    }

    ConfigContext getConfigContext() {
        return this.dynamicConfigContext;
    }

    private boolean verifyModuleDirectory() {
        String moduleDirectory;
        try {
            moduleDirectory = this.configManager.getLocation(this.id);
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "loader.configexception", ce);
            return false;
        }
        boolean result = FileUtils.safeIsDirectory(moduleDirectory);
        if (!result) {
            _logger.log(Level.WARNING, "loader.module_dir_error", new Object[]{this.id, moduleDirectory});
        }
        return result;
    }

    boolean load(boolean jsr77) {
        return this.verifyModuleDirectory() && this.doLoad(jsr77);
    }

    abstract boolean doLoad(boolean var1);

    abstract boolean unload(boolean var1);

    abstract void createRootMBean() throws MBeanException;

    abstract void deleteRootMBean() throws MBeanException;

    abstract void createLeafMBeans() throws MBeanException;

    abstract void deleteLeafMBeans() throws MBeanException;

    abstract void createLeafMBean(Descriptor var1) throws MBeanException;

    abstract void deleteLeafMBean(Descriptor var1) throws MBeanException;

    abstract void deleteLeafAndRootMBeans() throws MBeanException;

    abstract void setState(int var1) throws MBeanException;

    ClassLoader getClassLoader() {
        return this.ejbClassLoader;
    }

    Application getApplication() {
        return this.application;
    }

    protected void done() {
        if (this.ejbClassLoader instanceof EJBClassLoader) {
            ((EJBClassLoader)this.ejbClassLoader).done();
        }
        Set rars = this.application.getRarDescriptors();
        for (ConnectorDescriptor cd : rars) {
            cd.setClassLoader(null);
        }
        this.id = null;
        this.parentClassLoader = null;
        this.application = null;
        this.ejbClassLoader = null;
        this.registry = null;
        this.configManager = null;
    }

    protected boolean unloadEjbs(boolean jsr77) {
        boolean result = true;
        if (this.application == null) {
            result = false;
        } else {
            Vector beanDescriptors = this.application.getEjbDescriptors();
            Enumeration e = beanDescriptors.elements();
            while (e.hasMoreElements()) {
                EjbDescriptor nextDescriptor = (EjbDescriptor)e.nextElement();
                this.notifyEjbEvent(22, nextDescriptor);
                this.registry.removeUniqueId(nextDescriptor.getUniqueId());
                try {
                    Container container = this.registry.removeDescriptor2Container(nextDescriptor);
                    if (container != null) {
                        container.undeploy();
                    }
                }
                catch (Exception beanEx) {
                    result = false;
                    _logger.log(Level.WARNING, "loader.unexpected_error_while_unloading_ejb_container", beanEx);
                }
                this.notifyEjbEvent(23, nextDescriptor);
                if (!jsr77) continue;
                try {
                    this.deleteLeafMBean(nextDescriptor);
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "loader.delete_ejb_mbean_exception", mbe);
                }
            }
            if (!this.application.isVirtual()) {
                this.registry.removeAppId2ClassLoader(this.id);
            } else {
                this.registry.removeModuleId2ClassLoader(this.id);
            }
            this.registry.removeClassLoader2Application(this.ejbClassLoader);
        }
        _logger.log(Level.FINE, "[AbstractLoader] Unload EJB(s) Status: " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadEjbs(boolean jsr77) {
        ClassLoader loader = this.ejbClassLoader;
        if (this.application == null) {
            return false;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "[AbstractLoader] Id: " + this.id + " Setting thread context class loader to: " + loader);
        }
        ClassLoader savedContextClassLoader = Utility.setContextClassLoader(loader);
        try {
            if (!this.application.isVirtual()) {
                this.registry.addAppId2ClassLoader(this.id, this.ejbClassLoader);
            } else {
                this.registry.addModuleId2ClassLoader(this.id, this.ejbClassLoader);
            }
            this.registry.addClassLoader2Application(this.ejbClassLoader, this.application);
            HashSet<Container> myContainers = new HashSet<Container>();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[AbstractLoader] Id: " + this.id + " Unique Id: " + this.application.getUniqueId());
            }
            Vector beanDescriptors = this.application.getEjbDescriptors();
            Enumeration e = beanDescriptors.elements();
            ContainerFactory cf = Switch.getSwitch().getContainerFactory();
            while (e.hasMoreElements()) {
                EjbDescriptor nextDescriptor = (EjbDescriptor)e.nextElement();
                if (!this.registry.isUnique(nextDescriptor.getUniqueId())) {
                    _logger.log(Level.SEVERE, "loader.duplicate_unique_id", new Object[]{String.valueOf(nextDescriptor.getUniqueId()), nextDescriptor.getName()});
                    this.unloadEjbs(jsr77);
                    boolean bl = false;
                    return bl;
                }
                if (this.ffsmf == null) {
                    this.ffsmf = FactoryForSecurityManagerFactoryImpl.getInstance();
                }
                SecurityManagerFactory smf = this.ffsmf.getSecurityManagerFactory("ejb");
                SecurityManager sm = smf.createSecurityManager(nextDescriptor);
                Container container = null;
                try {
                    this.notifyEjbEvent(20, nextDescriptor);
                    container = cf.createContainer(nextDescriptor, loader, sm, this.dynamicConfigContext);
                    this.notifyEjbEvent(21, nextDescriptor);
                }
                catch (NameAlreadyBoundException jndiEx) {
                    _logger.log(Level.SEVERE, "loader.jndi_name_conflict", new Object[]{this.id, nextDescriptor.getJndiName(), nextDescriptor.getName()});
                    _logger.log(Level.SEVERE, "loader.naming_exception_in_createcontainer", jndiEx);
                    this.unloadEjbs(jsr77);
                    boolean bl = false;
                    Utility.setContextClassLoader(savedContextClassLoader);
                    return bl;
                }
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Created container with uinque id: " + nextDescriptor.getUniqueId());
                    }
                    this.registry.addDescriptor2Container(nextDescriptor, container);
                    myContainers.add(container);
                }
                catch (Exception beanEx) {
                    _logger.log(Level.SEVERE, "loader.unexpected_error_while_creating_ejb_container", beanEx);
                    this.unloadEjbs(jsr77);
                    boolean bl = false;
                    return bl;
                }
                if (!jsr77) continue;
                try {
                    this.createLeafMBean(nextDescriptor);
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "loader.create_ejb_mbean_exception", mbe);
                }
            }
            try {
                Enumeration en = beanDescriptors.elements();
                while (en.hasMoreElements()) {
                    EjbDescriptor nextDescriptor = (EjbDescriptor)en.nextElement();
                    SecurityUtil.generatePolicyFile(EJBSecurityManager.getContextID(nextDescriptor));
                }
            }
            catch (Exception ge) {
                _logger.log(Level.SEVERE, "code.could_not_generate/load_the_policy_files_for_system_app", ge);
                this.unloadEjbs(jsr77);
                boolean nextDescriptor = false;
                Utility.setContextClassLoader(savedContextClassLoader);
                return nextDescriptor;
            }
            for (Container c : myContainers) {
                c.doAfterApplicationDeploy();
            }
            Audit.showACL(this.application);
            if (this.application.getEjbComponentCount() > 0) {
                _logger.log(Level.INFO, "loader.ejbs_loaded", this.id);
            }
            _logger.log(Level.FINE, "[AbstractLoader] loadEjbs completed");
            boolean bl = true;
            return bl;
        }
        finally {
            Utility.setContextClassLoader(savedContextClassLoader);
        }
    }

    protected boolean unloadRars(boolean jsr77) {
        boolean result = true;
        try {
            Set rarsDescriptors = this.application.getRarDescriptors();
            ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
            for (ConnectorDescriptor cd : rarsDescriptors) {
                String rarName = cd.getDeployName();
                String jndiName = this.id + "#" + FileUtils.makeFriendlyFilenameNoExtension(rarName);
                connectorRuntime.destroyActiveResourceAdapter(jndiName, this.cascade);
                if (!jsr77) continue;
                this.deleteLeafMBean(cd);
            }
        }
        catch (Exception rarEx) {
            result = false;
            _logger.log(Level.WARNING, "loader.application_loader_exception", rarEx);
        }
        _logger.log(Level.FINE, "[AbstractLoader] Unload RAR(s) Status: " + result);
        return result;
    }

    protected boolean loadRars(boolean jsr77) {
        try {
            String appLocation = this.configManager.getLocation(this.id);
            Set rars = this.application.getRarDescriptors();
            ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
            for (ConnectorDescriptor cd : rars) {
                String rarName = cd.getDeployName();
                String location = DeploymentUtils.getEmbeddedModulePath(appLocation, rarName);
                String jndiName = this.id + "#" + FileUtils.makeFriendlyFilenameNoExtension(rarName);
                connectorRuntime.createActiveResourceAdapter(cd, jndiName, location);
                if (!jsr77) continue;
                this.createLeafMBean(cd);
            }
            try {
                ConnectorResourcesLoader crl = new ConnectorResourcesLoader();
                crl.loadEmbeddedRarResources(this.id, this.getApplication());
            }
            catch (ConfigException cex) {
                _logger.log(Level.SEVERE, "loader.connector_resource_initialization_error", cex);
            }
        }
        catch (Exception rarEx) {
            _logger.log(Level.WARNING, "loader.application_loader_exception", rarEx);
        }
        _logger.log(Level.FINE, "[AbstractLoader] loadRars completed");
        return true;
    }

    protected void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    protected boolean getCascade() {
        return this.cascade;
    }

    protected int getLoadUnloadAction() {
        return this.loadUnloadAction;
    }

    protected void setLoadUnloadAction(int loadUnloadAction) {
        this.loadUnloadAction = loadUnloadAction;
    }

    protected boolean loadWebserviceEndpoints(boolean jsr77) {
        boolean result = true;
        if (this.application == null) {
            result = false;
        } else {
            HashSet bundleSet = new HashSet();
            bundleSet.addAll(this.application.getEjbBundleDescriptors());
            bundleSet.addAll(this.application.getWebBundleDescriptors());
            for (BundleDescriptor nextDescriptor : bundleSet) {
                try {
                    WSMonitorLifeCycleFactory.getInstance().getWSMonitorLifeCycleProvider().registerWebServiceEndpoints(this.application.getRegistrationName(), nextDescriptor);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "loader.register_ws_endpoint_error", this.application.getRegistrationName());
                    _logger.log(Level.WARNING, "loader.register_ws_endpoint_exception", e);
                    result = false;
                }
                _logger.log(Level.FINE, "[AbstractLoader] Unload Web Service Endpoint(s) Status: " + result);
            }
        }
        return result;
    }

    protected boolean unloadWebserviceEndpoints(boolean jsr77) {
        boolean result = true;
        if (this.application == null) {
            result = false;
        } else {
            HashSet bundleSet = new HashSet();
            bundleSet.addAll(this.application.getEjbBundleDescriptors());
            bundleSet.addAll(this.application.getWebBundleDescriptors());
            for (BundleDescriptor nextDescriptor : bundleSet) {
                try {
                    WSMonitorLifeCycleFactory.getInstance().getWSMonitorLifeCycleProvider().unregisterWebServiceEndpoints(this.application.getRegistrationName(), nextDescriptor);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "loader.unregister_ws_endpoint_error", this.application.getRegistrationName());
                    _logger.log(Level.WARNING, "loader.register_ws_endpoint_exception", e);
                    result = false;
                }
                _logger.log(Level.FINE, "[AbstractLoader] Unload Web Service Endpoint(s) Status: " + result);
            }
        }
        return result;
    }

    public void generateEntryContext(Object context) {
        ServerEntryHelper.generateAppLoaderEntryContext((Descriptor)context);
    }

    protected void notifyAppEvent(int eventType) {
        ApplicationEvent event = new ApplicationEvent(eventType, this.getApplication(), this.getClassLoader(), this.dynamicConfigContext);
        this.generateEntryContext(this.getApplication());
        this.loaderEventNotifier.notifyListeners(event);
    }

    protected void notifyEjbEvent(int eventType, EjbDescriptor desc) {
        EjbContainerEvent event = new EjbContainerEvent(eventType, desc, this.getClassLoader());
        this.generateEntryContext(desc);
        this.loaderEventNotifier.notifyListeners(event);
    }

    protected boolean loadPersistenceUnits() {
        try {
            new PersistenceUnitLoaderImpl().load(new ApplicationInfoImpl());
            return true;
        }
        catch (Exception ge) {
            _logger.log(Level.WARNING, ge.getMessage(), ge);
            return false;
        }
    }

    protected boolean unloadPersistenceUnits() {
        try {
            new PersistenceUnitLoaderImpl().unload(new ApplicationInfoImpl());
            return true;
        }
        catch (Exception ge) {
            _logger.log(Level.WARNING, ge.getMessage(), ge);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationInfoImpl
    implements PersistenceUnitLoader.ApplicationInfo {
        private ApplicationInfoImpl() {
        }

        @Override
        public Application getApplication() {
            return AbstractLoader.this.application;
        }

        @Override
        public InstrumentableClassLoader getClassLoader() {
            return (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(AbstractLoader.this.ejbClassLoader);
        }

        @Override
        public String getApplicationLocation() {
            try {
                return AbstractLoader.this.configManager.getLocation(AbstractLoader.this.id);
            }
            catch (ConfigException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Collection<? extends PersistenceUnitDescriptor> getReferencedPUs() {
            HashSet<? extends PersistenceUnitDescriptor> pus = new HashSet<PersistenceUnitDescriptor>();
            boolean fineMsgLoggable = _logger.isLoggable(Level.FINE);
            for (BundleDescriptor bundle : this.getEjbAndWebBundles()) {
                if (fineMsgLoggable) {
                    _logger.fine("Finding PUs referenced by module called " + bundle.getModuleDescriptor().getArchiveUri());
                }
                pus.addAll(bundle.findReferencedPUs());
            }
            if (fineMsgLoggable) {
                _logger.fine("Total number of PUs referenced by this app is : " + pus.size());
            }
            return pus;
        }

        @Override
        public Collection<? extends EntityManagerFactory> getEntityManagerFactories() {
            HashSet<EntityManagerFactory> emfs = new HashSet<EntityManagerFactory>();
            emfs.addAll(AbstractLoader.this.application.getEntityManagerFactories());
            for (BundleDescriptor bundle : this.getEjbAndWebBundles()) {
                emfs.addAll(bundle.getEntityManagerFactories());
            }
            return emfs;
        }

        private Collection<BundleDescriptor> getEjbAndWebBundles() {
            HashSet<BundleDescriptor> bundles = new HashSet<BundleDescriptor>();
            bundles.addAll(AbstractLoader.this.application.getEjbBundleDescriptors());
            bundles.addAll(AbstractLoader.this.application.getWebBundleDescriptors());
            return bundles;
        }
    }
}

