/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourceConflictException;
import com.sun.enterprise.resource.SunResourcesXML;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtilities {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(ResourceUtilities.class);

    private ResourceUtilities() {
    }

    public static Set<Resource> getResourceConfigConflicts(Set<Resource> resSet, ConfigContext cc) throws ConfigException {
        HashSet<Resource> conflicts = new HashSet<Resource>();
        if (resSet != null) {
            for (Resource res : resSet) {
                String id = ResourceUtilities.getIdToCompare(res);
                ConfigBean sb = ResourceHelper.findResource(cc, id);
                if (sb == null) continue;
                conflicts.add(res);
            }
        }
        return conflicts;
    }

    private static String getIdToCompare(Resource res) {
        AttributeList attrs = res.getAttributes();
        String type = res.getType();
        String id = "jdbc-connection-pool".equals(type) || "connector-connection-pool".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("security-map".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("resource-adapter-config".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "resource-adapter-name") : ResourceUtilities.getNamedAttributeValue(attrs, "jndi-name")));
        return id;
    }

    private static String getNamedAttributeValue(AttributeList attrs, String aName) {
        String value = null;
        for (Object obj : attrs) {
            Attribute a;
            if (!(obj instanceof Attribute) || !aName.equals((a = (Attribute)obj).getName())) continue;
            value = a.getValue().toString();
        }
        return value;
    }

    public static Set<Resource> resolveResourceDuplicatesConflictsWithinArchive(List<SunResourcesXML> sunResList) throws ResourceConflictException {
        boolean conflictExist = false;
        StringBuffer conflictingResources = new StringBuffer();
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        for (SunResourcesXML sunResXML : sunResList) {
            List<Resource> resources = sunResXML.getResourcesList();
            for (Resource res : resources) {
                Iterator resSetIter = resourceSet.iterator();
                boolean addResource = true;
                while (resSetIter.hasNext()) {
                    Resource existingRes = (Resource)resSetIter.next();
                    if (existingRes.equals(res)) {
                        addResource = false;
                        _logger.warning(localStrings.getString("duplicate.resource.sun.resource.xml", ResourceUtilities.getIdToCompare(res), sunResXML.getXMLPath()));
                        break;
                    }
                    if (!existingRes.isAConflict(res)) continue;
                    addResource = false;
                    conflictingResources.append("\n");
                    String message = localStrings.getString("conflict.resource.sun.resource.xml", ResourceUtilities.getIdToCompare(res), sunResXML.getXMLPath());
                    conflictingResources.append(message);
                    _logger.warning(message);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    ResourceUtilities.logAttributes(res);
                }
                if (!addResource) continue;
                resourceSet.add(res);
            }
        }
        if (conflictingResources.toString().length() > 0) {
            throw new ResourceConflictException(conflictingResources.toString());
        }
        return resourceSet;
    }

    public static void getResourceConflictsWithDomainXML(List<Resource> resList, ConfigContext configContext) throws ResourceConflictException, ConfigException {
        if (resList != null) {
            Iterator<Resource> iterRes = resList.iterator();
            StringBuffer conflictingResources = new StringBuffer();
            while (iterRes.hasNext()) {
                Resource res = iterRes.next();
                String id = ResourceUtilities.getIdToCompare(res);
                ConfigBean sb = ResourceHelper.findResource(configContext, id);
                if (sb == null) continue;
                conflictingResources.append("\n");
                String message = localStrings.getString("conflict.resource.with.domain.xml", ResourceUtilities.getIdToCompare(res));
                conflictingResources.append(message);
                _logger.warning(message);
                if (!_logger.isLoggable(Level.FINE)) continue;
                ResourceUtilities.logAttributes(res);
            }
            if (conflictingResources.toString().length() > 0) {
                throw new ResourceConflictException(conflictingResources.toString());
            }
        }
    }

    private static void logAttributes(Resource res) {
        StringBuffer message = new StringBuffer();
        for (Attribute attribute : res.getAttributes()) {
            message.append(attribute.getName());
            message.append("=");
            message.append(attribute.getValue());
            message.append(" ");
        }
        _logger.fine(localStrings.getString("resource.attributes", message.toString()));
    }
}

