/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.selfmanagement;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationListener;

public final class LogMgmtEventsNotificationListener
implements NotificationListener {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static final StringManager localStrings = StringManager.getManager(LogMgmtEventsNotificationListener.class);
    public static final String RECORD_EVENT_KEY = "record-event";
    public static final String RECORD_LOG_LEVEL_KEY = "level";
    public static final String EVENT_TYPE_KEY = "type";
    public static final String EVENT_DESCRIPTION_KEY = "description";

    private LogMgmtEventsNotificationListener() {
    }

    public static LogMgmtEventsNotificationListener getInstance() {
        return new LogMgmtEventsNotificationListener();
    }

    public void handleNotification(Notification notification, Object handback) {
        Map property = (Map)handback;
        if (property == null) {
            return;
        }
        String recordevent = null;
        recordevent = (String)property.get(RECORD_EVENT_KEY);
        if (recordevent == null) {
            return;
        }
        boolean recordEvent = false;
        if (recordevent != null && (recordEvent = Boolean.valueOf(recordevent).booleanValue())) {
            try {
                String logLevel;
                StringBuffer message = new StringBuffer(localStrings.getString("logMgmtEventsNotificationListener.prefix"));
                String eventType = (String)property.get(EVENT_TYPE_KEY);
                if (eventType != null) {
                    message.append(eventType);
                    message.append(":");
                }
                if ((logLevel = (String)property.get(RECORD_LOG_LEVEL_KEY)) == null) {
                    logLevel = Level.FINE.toString();
                }
                message.append(logLevel);
                message.append(":");
                Level level = Level.parse(logLevel);
                String description = (String)property.get(EVENT_DESCRIPTION_KEY);
                if (description != null) {
                    message.append(description);
                    message.append(":");
                }
                _logger.log(level, message.toString());
            }
            catch (IllegalArgumentException iae) {
                _logger.log(Level.FINE, "Incorrect Log Level set for event. Cannot log event ", iae);
                iae.printStackTrace();
            }
            catch (NullPointerException npe) {
                _logger.log(Level.FINE, "Incorrect Log Level set for event. Cannot log event ", npe);
                npe.printStackTrace();
            }
        }
    }
}

