/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.enterprise.management.model.J2EEManagedObjectMdl;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import javax.management.ObjectName;

public class JDBCDataSourceMdl
extends J2EEManagedObjectMdl {
    private static String MANAGED_OBJECT_TYPE = "JDBCDataSource";
    private String jdbcDataSourceName = null;
    private String driverName = null;
    private boolean debug = false;
    private String username = null;
    private String password = null;
    private String url = null;
    private String[] propNames = null;
    private String[] propValues = null;

    public JDBCDataSourceMdl(String dataSourceJndiName, String dataSourceName, String url, String username, String password, String[] propNames, String[] propValues) {
        super(dataSourceJndiName, false, false, false);
        this.jdbcDataSourceName = dataSourceName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.propNames = propNames;
        this.propValues = propValues;
    }

    public JDBCDataSourceMdl(String dataSourceJndiName, String serverName, String dataSourceName, String url, String username, String password, String[] propNames, String[] propValues) {
        super(dataSourceJndiName, serverName, false, false, false);
        this.jdbcDataSourceName = dataSourceName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.propNames = propNames;
        this.propValues = propValues;
    }

    public String getjdbcDriver() {
        if (this.driverName == null) {
            Set s;
            try {
                Driver drv = DriverManager.getDriver(this.jdbcDataSourceName);
                s = this.findNames("j2eeType=JDBCDriver,name=" + drv.getClass().getName());
            }
            catch (SQLException e) {
                s = this.findNames("j2eeType=JDBCDriver,name=" + this.jdbcDataSourceName);
            }
            Object[] objs = s.toArray();
            if (objs.length > 0) {
                String name;
                this.driverName = name = ((ObjectName)objs[0]).toString();
            }
        }
        return this.driverName;
    }

    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public String getobjectName() {
        Set s = this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + this.getname() + ",JDBCResource=" + this.getJDBC() + ",J2EEServer=" + this.getJ2EEServer());
        Object[] objs = s.toArray();
        if (objs.length > 0) {
            String name = ((ObjectName)objs[0]).toString();
            return name;
        }
        return null;
    }

    public String getJDBC() {
        return this.getname();
    }

    public String geturl() {
        return this.url;
    }

    public String getusername() {
        return this.username;
    }

    public String getpassword() {
        return this.password;
    }

    public String[] getpropNames() {
        return this.propNames;
    }

    public String[] getpropValues() {
        return this.propValues;
    }

    public String getjdbcDataSourceName() {
        return this.jdbcDataSourceName;
    }
}

