/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.enterprise.Switch;
import com.sun.enterprise.iiop.ClientConnectionInterceptor;
import com.sun.enterprise.iiop.PEORBConfigurator;
import com.sun.enterprise.iiop.SFSBClientRequestInterceptor;
import com.sun.enterprise.iiop.SFSBServerRequestInterceptor;
import com.sun.enterprise.iiop.SFSBVersionIORInterceptor;
import com.sun.enterprise.iiop.ServerConnectionInterceptor;
import com.sun.enterprise.iiop.TxSecIORInterceptor;
import com.sun.enterprise.iiop.security.Csiv2Manager;
import com.sun.enterprise.iiop.security.SecClientRequestInterceptor;
import com.sun.enterprise.iiop.security.SecServerRequestInterceptor;
import com.sun.enterprise.iiop.security.SecurityServiceImpl;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class J2EEInitializer
extends LocalObject
implements ORBInitializer {
    private static Logger _logger = null;
    private static final String SEC_INTEROP_CLIENTINT_PROP = "interop.secinterceptor.client";
    private static final String SEC_INTEROP_SERVERINT_PROP = "interop.secinterceptor.server";

    public J2EEInitializer() {
        try {
            System.setProperty("com.sun.jts.pi.CLIENT_POLICY_CHECKING", String.valueOf(false));
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "iiop.readproperty_exception", ex);
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        Codec codec = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "J2EE Initializer post_init");
            _logger.log(Level.FINE, "Creating Codec for CDR encoding");
        }
        CodecFactory cf = info.codec_factory();
        byte major_version = 1;
        byte minor_version = 2;
        Encoding encoding = new Encoding(0, major_version, minor_version);
        try {
            SecServerRequestInterceptor sreq;
            Constructor<?> constructor;
            Object[] params;
            Class[] paramTypes;
            SecClientRequestInterceptor creq;
            codec = cf.create_codec(encoding);
            ClientConnectionInterceptor cci = new ClientConnectionInterceptor("ClientConnInterceptor", 1);
            info.add_client_request_interceptor((ClientRequestInterceptor)cci);
            String clientSecInterceptor = System.getProperty(SEC_INTEROP_CLIENTINT_PROP);
            String serverSecInterceptor = System.getProperty(SEC_INTEROP_SERVERINT_PROP);
            if (clientSecInterceptor == null) {
                creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
            } else {
                try {
                    Class<?> cInterceptorClass = Class.forName(clientSecInterceptor);
                    paramTypes = new Class[]{String.class, Codec.class};
                    params = new Object[]{"SecClientRequestInterceptor", codec};
                    constructor = cInterceptorClass.getConstructor(paramTypes);
                    creq = (ClientRequestInterceptor)constructor.newInstance(params);
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Exception registering security client request receptor", e);
                        _logger.log(Level.FINE, "Going to register default security client request interceptor");
                    }
                    creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
                }
            }
            if (serverSecInterceptor == null) {
                sreq = new SecServerRequestInterceptor("SecServerRequestInterceptor", codec);
            } else {
                try {
                    Class<?> sInterceptorClass = Class.forName(serverSecInterceptor);
                    paramTypes = new Class[]{String.class, Codec.class};
                    params = new Object[]{"SecServerRequestInterceptor", codec};
                    constructor = sInterceptorClass.getConstructor(paramTypes);
                    sreq = (ServerRequestInterceptor)constructor.newInstance(params);
                }
                catch (Exception e) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Exception registering security server request receptor", e);
                        _logger.log(Level.FINE, "Going to register default security server request interceptor");
                    }
                    sreq = new SecServerRequestInterceptor("SecServerRequestInterceptor", codec);
                }
            }
            info.add_client_request_interceptor((ClientRequestInterceptor)creq);
            ServerConnectionInterceptor sci = new ServerConnectionInterceptor(2);
            info.add_server_request_interceptor((ServerRequestInterceptor)sci);
            info.add_server_request_interceptor((ServerRequestInterceptor)sreq);
            SecurityServiceImpl ss = new SecurityServiceImpl();
            Csiv2Manager.setSecurityService(ss);
            Current pic = (Current)info.resolve_initial_references("PICurrent");
            int[] slotIds = new int[]{info.allocate_slot_id(), info.allocate_slot_id()};
            InterceptorImpl interceptor = new InterceptorImpl(pic, codec, slotIds, null);
            info.add_client_request_interceptor((ClientRequestInterceptor)interceptor);
            info.add_server_request_interceptor((ServerRequestInterceptor)interceptor);
            boolean addSFSBInterceptors = false;
            if (Switch.getSwitch().getContainerType() != 1) {
                addSFSBInterceptors = EJBServerConfigLookup.needToAddSFSBVersionInterceptors();
            }
            _logger.log(Level.FINE, "J2EEInitializer: Checking if interceptors need to  be added");
            if (addSFSBInterceptors) {
                SFSBClientRequestInterceptor sfsbClientInterceptor = new SFSBClientRequestInterceptor(codec);
                SFSBServerRequestInterceptor sfsbServerInterceptor = new SFSBServerRequestInterceptor(codec);
                info.add_client_request_interceptor((ClientRequestInterceptor)sfsbClientInterceptor);
                info.add_server_request_interceptor((ServerRequestInterceptor)sfsbServerInterceptor);
                _logger.log(Level.FINE, "J2EEInitializer: Added SFSBInterceptors");
            }
            ORB thisORB = ((ORBInitInfoExt)info).getORB();
            PEORBConfigurator.setJTSInterceptor(interceptor, thisORB);
            TxSecIORInterceptor iorInterceptor = new TxSecIORInterceptor(codec);
            info.add_ior_interceptor((IORInterceptor)iorInterceptor);
            if (addSFSBInterceptors) {
                info.add_ior_interceptor((IORInterceptor)new SFSBVersionIORInterceptor(codec));
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

