/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.admin.server.core.jmx.AppServerMBeanServerFactory;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.InterruptableCollector;
import com.sun.enterprise.diagnostics.collect.MonitoringInfoHelper;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringInfoCollector
extends InterruptableCollector {
    Set<String> restrictedProperties = null;
    public static final String DOTTED_NAME_REGISTRY_OPERATION_NAME = "dottedNameToObjectName";
    public static final String KEY_NOT_FOUND = "key not found";
    public static final String LIST_COMMAND = "list";
    public static final String GET_COMMAND = "get";
    public static final String MONITOR_OPTION = "monitor";
    private String instanceName;
    private String nodeAgentName;
    private PrintStream out = System.out;
    private String fileName;
    private String destFolder;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public MonitoringInfoCollector(String nodeAgentName, String instanceName, String destFolder) {
        if (instanceName != null) {
            this.instanceName = instanceName;
        }
        if (nodeAgentName != null) {
            this.nodeAgentName = nodeAgentName;
        }
        this.destFolder = destFolder;
        this.initializeRestrictedPropertiesLookUp();
    }

    private void initializeRestrictedPropertiesLookUp() {
        this.restrictedProperties = new HashSet<String>();
        this.restrictedProperties.add("-description");
        this.restrictedProperties.add("-name");
        this.restrictedProperties.add("-lowerbound");
        this.restrictedProperties.add("-starttime");
        this.restrictedProperties.add("-upperbound");
    }

    private boolean isRestircted(String dottedName) {
        int index;
        boolean restricted = false;
        if (dottedName != null && (index = dottedName.lastIndexOf("-")) >= 0) {
            String property = dottedName.substring(index);
            if (this.restrictedProperties != null) {
                restricted = this.restrictedProperties.contains(property);
            }
        }
        return restricted;
    }

    @Override
    public Data capture() throws DiagnosticException {
        FileData data = null;
        if (this.destFolder != null) {
            File destFolderObj = new File(this.destFolder);
            this.fileName = this.destFolder + File.separator + "MonitoringInformation";
            if (!destFolderObj.exists()) {
                destFolderObj.mkdirs();
            }
            try {
                this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.fileName)), true);
                File reportFile = new File(this.fileName);
                data = this.instanceName.equalsIgnoreCase("server") ? new FileData(reportFile.getName(), "monitoring info") : new FileData(this.nodeAgentName + File.separator + this.instanceName + File.separator + reportFile.getName(), "monitoring info");
                ArrayList<String> cmdOutput = new ArrayList<String>();
                MonitoringInfoHelper cmd = new MonitoringInfoHelper();
                cmd.setName(LIST_COMMAND);
                ArrayList<String> dottedNames = new ArrayList<String>();
                if (this.instanceName != null) {
                    dottedNames.add(this.instanceName.trim() + ".*");
                    cmd.setOperands(dottedNames);
                    cmd.setOption("secure", "true");
                    cmd.setOption(MONITOR_OPTION, "true");
                    cmd.runCommand(cmdOutput);
                    if (this.checkInterrupted()) {
                        logger.log(Level.WARNING, "diagnostic-service.monitoring_info_collector_timeout", new Object[]{Thread.currentThread().getName(), this.getClass().getName()});
                        if (this.out != null) {
                            this.out.print("Monitoring Info Collector Timeout");
                            this.out.close();
                        }
                        return data;
                    }
                    ArrayList<String> list = this.getIndividualProperties(cmdOutput);
                    MBeanServer mbs = AppServerMBeanServerFactory.getMBeanServerInstance();
                    String[] types = new String[]{String.class.getName()};
                    for (String value : list) {
                        if (this.checkInterrupted()) {
                            logger.log(Level.WARNING, "diagnostic-service.monitoring_info_collector_timeout", new Object[]{Thread.currentThread().getName(), this.getClass().getName()});
                            if (this.out != null) {
                                this.out.print("Monitoring Info Collector Timeout");
                                this.out.close();
                            }
                            return data;
                        }
                        Object[] params = new Object[]{value};
                        ObjectName dottedNameRegistry = (ObjectName)mbs.invoke(new ObjectName("com.sun.appserv:name=dotted-name-monitoring-registry,type=dotted-name-support"), DOTTED_NAME_REGISTRY_OPERATION_NAME, params, types);
                        Set<String> set = MonitoringInfoCollector.getAllAttributeNames(mbs, dottedNameRegistry);
                        Iterator<String> attributesIterator = set.iterator();
                        ArrayList<String> properties = new ArrayList<String>();
                        while (attributesIterator.hasNext()) {
                            String attr = attributesIterator.next();
                            if (this.isRestircted(attr)) continue;
                            properties.add(value + "." + attr);
                        }
                        if (properties.size() > 0) {
                            cmd.setName(GET_COMMAND);
                            cmd.setOperands(properties);
                            ArrayList<String> result = new ArrayList<String>();
                            cmd.runCommand(result);
                            for (String attributeValue : result) {
                                if (attributeValue.toLowerCase().indexOf(KEY_NOT_FOUND) >= 0) continue;
                                this.out.println(attributeValue);
                            }
                        }
                        if (!this.checkInterrupted()) continue;
                        logger.log(Level.WARNING, "diagnostic-service.monitoring_info_collector_timeout", new Object[]{Thread.currentThread().getName(), this.getClass().getName()});
                        if (this.out != null) {
                            this.out.print("Monitoring Info Collector Timeout");
                            this.out.close();
                        }
                        return data;
                    }
                    this.out.close();
                }
                return data;
            }
            catch (FileNotFoundException fnfe) {
                logger.log(Level.WARNING, "File Not Found exception occurred while collecting Monitoring information", fnfe);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "IO Exception occurred while collecting Monitoring information", ioe);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception occurred while collecting Monitoring information", e);
            }
        }
        return data;
    }

    public static Set<String> getAllAttributeNames(MBeanServer server, ObjectName objectName) throws ReflectionException, InstanceNotFoundException, IntrospectionException {
        HashSet<String> allNames = new HashSet<String>();
        MBeanInfo info = server.getMBeanInfo(objectName);
        MBeanAttributeInfo[] attrsInfo = info.getAttributes();
        if (attrsInfo != null) {
            for (MBeanAttributeInfo aAttrsInfo : attrsInfo) {
                allNames.add(aAttrsInfo.getName());
            }
        }
        return allNames;
    }

    public ArrayList<String> getIndividualProperties(ArrayList<String> list) throws IOException {
        ArrayList<String> modifiedList = new ArrayList<String>();
        String current = null;
        Collections.reverse(list);
        for (String next : list) {
            if (current != null) {
                if (current.indexOf(next) == 0) continue;
                modifiedList.add(next);
                current = next;
                continue;
            }
            modifiedList.add(next);
            current = next;
        }
        return modifiedList;
    }

    @Override
    public void cleanUp() {
        this.out.close();
    }
}

