/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.BackendObjectFactory;
import com.sun.enterprise.diagnostics.DiagnosticAgent;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.PEBackendObjectFactory;
import com.sun.enterprise.diagnostics.ReportGenerator;
import com.sun.enterprise.diagnostics.collect.DomainXMLHelper;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEDiagnosticAgent
implements DiagnosticAgent {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    @Override
    public String generateReport(Map options) throws DiagnosticException {
        if (options != null) {
            BackendObjectFactory objectFactory = this.getBackendObjectFactory(options);
            ReportGenerator generator = objectFactory.createReportGenerator();
            return generator.generate().getName();
        }
        throw new DiagnosticException(" Null Input for report generation");
    }

    @Override
    public String generateReport(Map clioptions, List<String> instances, String targetType) throws DiagnosticException {
        throw new DiagnosticException("Unsupported operation");
    }

    @Override
    public List<String> getConfidentialProperties(String repositoryDir) throws DiagnosticException {
        return new DomainXMLHelper(repositoryDir).getAttrs();
    }

    @Override
    public void deleteReport(String fileName) throws DiagnosticException {
        File file;
        if (fileName != null && (file = new File(fileName)).exists()) {
            file.delete();
        }
    }

    protected BackendObjectFactory getBackendObjectFactory(Map input) {
        return new PEBackendObjectFactory(input);
    }

    private Logger getLogger() {
        return logger;
    }
}

