/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceClient;

public class ModuleContentLinker
extends DefaultDOLVisitor {
    protected FileArchive rootLocation_;
    private boolean forceWSDLURLs;

    public ModuleContentLinker(FileArchive rootLocation, boolean forceWSDLURLs) {
        this.rootLocation_ = rootLocation;
        this.forceWSDLURLs = forceWSDLURLs;
    }

    public ModuleContentLinker(FileArchive rootLocation) {
        this(rootLocation, false);
    }

    protected ModuleContentLinker() {
    }

    private File getModuleLocation(ModuleDescriptor module) throws IOException {
        File moduleLocation = new File(this.rootLocation_.getArchiveUri());
        if (!module.isStandalone()) {
            String archiveUri = module.getArchiveUri();
            moduleLocation = new File(this.rootLocation_.getEmbeddedArchive(archiveUri).getArchiveUri());
        }
        return moduleLocation;
    }

    private URL internalGetUrl(ModuleDescriptor module, String uri) throws Exception {
        File moduleLocation = this.getModuleLocation(module);
        URL url = FileUtil.getEntryAsUrl(moduleLocation, uri);
        return url;
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        try {
            ModuleDescriptor moduleDesc = serviceRef.getBundleDescriptor().getModuleDescriptor();
            if (serviceRef.hasWsdlFile()) {
                String wsdlFileUri = serviceRef.getWsdlFileUri();
                File tmpFile = new File(wsdlFileUri);
                if (tmpFile.isAbsolute()) {
                    serviceRef.setWsdlFileUrl(tmpFile.toURI().toURL());
                } else if (wsdlFileUri.startsWith("http")) {
                    serviceRef.setWsdlFileUrl(new URL(wsdlFileUri));
                } else {
                    File wsdlFile = new File(this.getModuleLocation(moduleDesc), wsdlFileUri);
                    URL wsdlFileUrl = this.internalGetUrl(moduleDesc, wsdlFileUri);
                    serviceRef.setWsdlFileUrl(wsdlFile.toURI().toURL());
                }
            } else {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                Class<?> serviceInterfaceClass = classloader.loadClass(serviceRef.getServiceInterface());
                WebServiceClient wsc = serviceInterfaceClass.getAnnotation(WebServiceClient.class);
                if (wsc != null) {
                    serviceRef.setWsdlFileUri(wsc.wsdlLocation());
                    serviceRef.setServiceName(new QName(wsc.targetNamespace(), wsc.name()));
                }
            }
            if (serviceRef.hasMappingFile()) {
                String mappingFileUri = serviceRef.getMappingFileUri();
                File mappingFile = new File(this.getModuleLocation(moduleDesc), mappingFileUri);
                serviceRef.setMappingFile(mappingFile);
            }
        }
        catch (MalformedURLException mex) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidWsdlURL", new Object[]{serviceRef.getWsdlFileUri()});
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{serviceRef.getName(), this.rootLocation_});
        }
    }

    public void accept(WebService webService) {
        try {
            ModuleDescriptor moduleDesc = webService.getBundleDescriptor().getModuleDescriptor();
            if (webService.hasWsdlFile() && (webService.getWsdlFileUrl() == null || this.forceWSDLURLs)) {
                String wsdlFileUri = webService.getWsdlFileUri();
                URL wsdlFileURL = null;
                try {
                    URL url = new URL(wsdlFileUri);
                    if (url.getProtocol() != null && !url.getProtocol().equalsIgnoreCase("file")) {
                        wsdlFileURL = url;
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (wsdlFileURL == null) {
                    File wsdlFile = new File(this.getModuleLocation(moduleDesc), wsdlFileUri);
                    wsdlFileURL = wsdlFile.toURI().toURL();
                }
                webService.setWsdlFileUrl(wsdlFileURL);
            }
            if (webService.hasMappingFile()) {
                String mappingFileUri = webService.getMappingFileUri();
                File mappingFile = new File(this.getModuleLocation(moduleDesc), mappingFileUri);
                webService.setMappingFile(mappingFile);
            }
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{webService.getName(), this.rootLocation_});
        }
    }
}

