/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

class WorkStats {
    long submittedWorkCount;
    long completedWorkCount;
    long rejectedWorkCount;
    long maxWaitQueueLength;
    long minWaitQueueLength;
    long currentActiveWorkCount;
    long minActiveWorkCount;
    long maxActiveWorkCount;
    long maxWorkRequestWaitTime;
    long minWorkRequestWaitTime;
    long currWaitQueueLength;

    WorkStats() {
    }

    public void reset() {
        this.submittedWorkCount = 0L;
        this.rejectedWorkCount = 0L;
        this.completedWorkCount = 0L;
        this.currWaitQueueLength = 0L;
        this.maxWaitQueueLength = 0L;
        this.minWaitQueueLength = Long.MAX_VALUE;
        this.currentActiveWorkCount = 0L;
        this.minActiveWorkCount = Long.MAX_VALUE;
        this.maxActiveWorkCount = 0L;
        this.maxWorkRequestWaitTime = 0L;
        this.minWorkRequestWaitTime = 0L;
    }

    public synchronized void setWorkWaitTime(long waitTime) {
        if (waitTime > this.maxWorkRequestWaitTime) {
            this.maxWorkRequestWaitTime = waitTime;
        }
        if (waitTime < this.minWorkRequestWaitTime) {
            this.minWorkRequestWaitTime = waitTime;
        }
    }

    public synchronized void incrementWaitQueueLength() {
        this.setWaitQueueLength(++this.currWaitQueueLength);
    }

    public synchronized void decrementWaitQueueLength() {
        this.setWaitQueueLength(--this.currWaitQueueLength);
    }

    private void setWaitQueueLength(long waitQueueLength) {
        if (waitQueueLength > this.maxWaitQueueLength) {
            this.maxWaitQueueLength = waitQueueLength;
        }
        if (waitQueueLength < this.minWaitQueueLength) {
            this.minWaitQueueLength = waitQueueLength;
        }
    }

    public synchronized void setActiveWorkCount(long currentActiveWorkCount) {
        this.currentActiveWorkCount = currentActiveWorkCount;
        if (currentActiveWorkCount > this.maxActiveWorkCount) {
            this.maxActiveWorkCount = currentActiveWorkCount;
        }
        if (currentActiveWorkCount < this.minActiveWorkCount) {
            this.minActiveWorkCount = currentActiveWorkCount;
        }
    }
}

