/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import java.util.ArrayList;

public class ClusterHelper
extends ConfigAPIHelper {
    public static String getClustersAsString(Cluster[] clusters) {
        String result = "";
        for (int i = 0; i < clusters.length; ++i) {
            result = result + clusters[i].getName();
            if (i >= clusters.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static Cluster[] getClustersInDomain(ConfigContext configContext) throws ConfigException {
        Domain domain = ClusterHelper.getDomainConfigBean(configContext);
        Clusters clusters = domain.getClusters();
        if (clusters != null && clusters.getCluster() != null) {
            return clusters.getCluster();
        }
        return new Cluster[0];
    }

    public static boolean isACluster(ConfigContext configContext, String clusterName) throws ConfigException {
        Domain domain = ClusterHelper.getDomainConfigBean(configContext);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        Cluster cluster = clusters.getClusterByName(clusterName);
        return cluster != null;
    }

    public static Cluster getClusterByName(ConfigContext configContext, String clusterName) throws ConfigException {
        Domain domain = ClusterHelper.getDomainConfigBean(configContext);
        Cluster cluster = domain.getClusters().getClusterByName(clusterName);
        if (cluster == null) {
            throw new ConfigException(_strMgr.getString("noSuchCluster", clusterName));
        }
        return cluster;
    }

    public static Cluster getClusterForInstance(ConfigContext configContext, String instanceName) throws ConfigException {
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        for (int i = 0; i < clusters.length; ++i) {
            ServerRef[] servers = clusters[i].getServerRef();
            for (int j = 0; j < servers.length; ++j) {
                if (!servers[j].getRef().equals(instanceName)) continue;
                Server server = ServerHelper.getServerByName(configContext, instanceName);
                return clusters[i];
            }
        }
        throw new ConfigException(_strMgr.getString("noSuchClusteredInstance", instanceName));
    }

    public static Cluster[] getClustersReferencingConfig(ConfigContext configContext, String configName) throws ConfigException {
        Config config = ClusterHelper.getConfigByName(configContext, configName);
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        for (int i = 0; i < clusters.length; ++i) {
            if (!clusters[i].getConfigRef().equals(configName)) continue;
            result.add(clusters[i]);
        }
        return result.toArray(new Cluster[result.size()]);
    }

    public static Cluster[] getClustersForNodeAgent(ConfigContext configContext, String agentName) throws ConfigException {
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        Server[] servers = ServerHelper.getServersOfANodeAgent(configContext, agentName);
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        for (int i = 0; i < clusters.length; ++i) {
            ServerRef[] serverRefs = clusters[i].getServerRef();
            for (int j = 0; j < serverRefs.length; ++j) {
                for (int k = 0; k < servers.length; ++k) {
                    if (!serverRefs[j].getRef().equals(servers[k].getName()) || result.contains(clusters[i])) continue;
                    result.add(clusters[i]);
                }
            }
        }
        return result.toArray(new Cluster[result.size()]);
    }

    public static Config getConfigForCluster(ConfigContext configContext, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        Domain domain = ClusterHelper.getDomainConfigBean(configContext);
        Config config = domain.getConfigs().getConfigByName(cluster.getConfigRef());
        if (config == null) {
            throw new ConfigException(_strMgr.getString("noSuchClusterConfig", cluster.getConfigRef(), clusterName));
        }
        return config;
    }

    public static boolean isClusterStandAlone(ConfigContext configContext, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        String configName = cluster.getConfigRef();
        return ClusterHelper.isConfigurationNameStandAlone(configName, clusterName) && ClusterHelper.isConfigurationReferencedByClusterOnly(configContext, configName, clusterName);
    }

    public static boolean clusterReferencesApplication(ConfigContext configContext, String clusterName, String appName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        return ClusterHelper.clusterReferencesApplication(cluster, appName);
    }

    public static boolean clusterReferencesApplication(Cluster cluster, String appName) throws ConfigException {
        ApplicationRef ref = cluster.getApplicationRefByRef(appName);
        return ref != null;
    }

    public static boolean clusterReferencesJdbcConPool(ConfigContext ctx, String clusterName, String poolName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(ctx, clusterName);
        return ClusterHelper.clusterReferencesJdbcConPool(cluster, poolName);
    }

    public static boolean clusterReferencesJdbcConPool(Cluster cluster, String poolName) throws ConfigException {
        ResourceRef ref = cluster.getResourceRefByRef(poolName);
        return ref != null;
    }

    public static Cluster[] getClustersReferencingApplication(ConfigContext configContext, String appName) throws ConfigException {
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        for (int i = 0; i < clusters.length; ++i) {
            if (!ClusterHelper.clusterReferencesApplication(clusters[i], appName)) continue;
            result.add(clusters[i]);
        }
        return result.toArray(new Cluster[result.size()]);
    }

    public static boolean clusterReferencesResource(ConfigContext configContext, String clusterName, String resourceName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        return ClusterHelper.clusterReferencesResource(cluster, resourceName);
    }

    public static boolean clusterReferencesResource(Cluster cluster, String resourceName) throws ConfigException {
        ResourceRef ref = cluster.getResourceRefByRef(resourceName);
        return ref != null;
    }

    public static Cluster[] getClustersReferencingResource(ConfigContext configContext, String resName) throws ConfigException {
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        for (int i = 0; i < clusters.length; ++i) {
            if (!ClusterHelper.clusterReferencesResource(clusters[i], resName)) continue;
            result.add(clusters[i]);
        }
        return result.toArray(new Cluster[result.size()]);
    }

    public static ApplicationRef[] getApplicationReferences(ConfigContext configContext, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        if (cluster.getApplicationRef() == null) {
            return new ApplicationRef[0];
        }
        return cluster.getApplicationRef();
    }

    public static ResourceRef[] getResourceReferences(ConfigContext configContext, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        if (cluster.getResourceRef() == null) {
            return new ResourceRef[0];
        }
        return cluster.getResourceRef();
    }
}

