/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ElementChangeHelper;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.EventStack;
import com.sun.enterprise.admin.event.pluggable.NotificationFactory;
import com.sun.enterprise.admin.event.pluggable.RestartEventHelper;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminNotificationHelper {
    private AdminContext _adminContext;
    private Logger _logger;

    public AdminNotificationHelper(AdminContext ctx) {
        this._adminContext = ctx;
        this._logger = this._adminContext != null ? this._adminContext.getAdminLogger() : Logger.getLogger("global");
    }

    public void sendNotification() {
        ConfigContext context = this._adminContext.getAdminConfigContext();
        String instanceName = this._adminContext.getServerName();
        AdminEventCache cache = AdminEventCache.getInstance(instanceName);
        cache.setAdminConfigContext(context);
        ArrayList changeList = context.getConfigChangeList();
        context.resetConfigChangeList();
        ArrayList eventList = null;
        if (changeList.size() <= 0) {
            eventList = new ArrayList();
        } else {
            cache.processConfigChangeList(changeList, false, false);
            eventList = cache.getAndResetCachedEvents();
            try {
                ElementChangeHelper elementHelper = new ElementChangeHelper();
                AdminEvent[] elementChangeEvents = elementHelper.generateElementChangeEventsFromChangeList(instanceName, changeList, context);
                if (elementChangeEvents != null) {
                    for (int i = 0; i < elementChangeEvents.length; ++i) {
                        eventList.add(elementChangeEvents[i]);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        EventStack stack = EventContext.getEventStackFromThreadLocal();
        List newEventList = stack.getEvents();
        newEventList.addAll(eventList);
        boolean requiresRestart = false;
        for (AdminEvent event : newEventList) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.log(Level.FINEST, "mbean.event_sent", event.getEventInfo());
            } else {
                this._logger.log(Level.INFO, "mbean.send_event", event.toString());
            }
            AdminEventResult result = AdminEventMulticaster.multicastEvent(event);
            this._logger.log(Level.FINE, "mbean.event_res", result.getResultCode());
            this._logger.log(Level.FINEST, "mbean.event_reply", result.getAllMessagesAsString());
            if ("success".equals(result.getResultCode())) continue;
            requiresRestart = true;
            cache.setRestartNeeded(true);
        }
        ServerContext svcCtx = ApplicationServer.getServerContext();
        PluggableFeatureFactory featureFactory = null;
        if (svcCtx != null) {
            featureFactory = svcCtx.getPluggableFeatureFactory();
            NotificationFactory nFactory = featureFactory.getNotificationFactory();
            RestartEventHelper helper = nFactory.createRestartEventHelper();
            helper.setRestartRequiredForTarget(context, changeList);
        }
        stack.resetEvents();
    }
}

