/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.objectweb.asm;

import com.sun.corba.ee.org.objectweb.asm.ByteVector;
import com.sun.corba.ee.org.objectweb.asm.ClassReader;
import com.sun.corba.ee.org.objectweb.asm.ClassWriter;
import com.sun.corba.ee.org.objectweb.asm.Label;

public class Attribute {
    public final String type;
    Attribute next;

    protected Attribute(String type) {
        this.type = type;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return null;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        return new Attribute(this.type);
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        return new ByteVector();
    }

    final int getCount() {
        int count = 0;
        Attribute attr = this;
        while (attr != null) {
            if (!attr.isUnknown()) {
                ++count;
            }
            attr = attr.next;
        }
        return count;
    }

    final int getSize(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        int size = 0;
        Attribute attr = this;
        while (attr != null) {
            cw.newUTF8(attr.type);
            size += attr.write((ClassWriter)cw, (byte[])code, (int)len, (int)maxStack, (int)maxLocals).length + 6;
            attr = attr.next;
        }
        return size;
    }

    final void put(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals, ByteVector out) {
        Attribute attr = this;
        while (attr != null) {
            if (attr.isUnknown()) {
                if (cw.checkAttributes) {
                    throw new IllegalArgumentException("Unknown attribute type: " + attr.type);
                }
            } else {
                ByteVector b = attr.write(cw, code, len, maxStack, maxLocals);
                out.putShort(cw.newUTF8(attr.type)).putInt(b.length);
                out.putByteArray(b.data, 0, b.length);
            }
            attr = attr.next;
        }
    }
}

