/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.pept.transport.Connection;
import com.sun.corba.ee.pept.transport.ReaderThread;
import com.sun.corba.ee.pept.transport.Selector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;

public class ReaderThreadImpl
implements ReaderThread,
Work {
    private ORB orb;
    private Connection connection;
    private Selector selector;
    private boolean keepRunning;
    private long enqueueTime;

    public ReaderThreadImpl(ORB orb, Connection connection, Selector selector) {
        this.orb = orb;
        this.connection = connection;
        this.selector = selector;
        this.keepRunning = true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.connection);
        }
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Start ReaderThread: " + this.connection);
            }
            while (this.keepRunning) {
                block12: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: Start ReaderThread cycle: " + this.connection);
                    }
                    if (!this.connection.read()) break block12;
                    return;
                }
                try {
                    if (!this.orb.transportDebugFlag) continue;
                    this.dprint(".doWork: End ReaderThread cycle: " + this.connection);
                }
                catch (Throwable t) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".doWork: exception in read: " + this.connection, t);
                    }
                    this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
                    this.getConnection().close();
                }
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
            }
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ReaderThread";
    }

    private void dprint(String msg) {
        ORBUtility.dprint("ReaderThreadImpl", msg);
    }

    protected void dprint(String msg, Throwable t) {
        this.dprint(msg);
        t.printStackTrace(System.out);
    }
}

