/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaRequestId;
import com.sun.corba.ee.spi.protocol.MessageParser;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class MessageParserImpl
implements MessageParser {
    private final ORB orb;
    private boolean expectingMoreData;
    private boolean moreBytesToParse;
    private int nextMsgStartPos;
    private int sizeNeeded;
    private List<CorbaRequestId> fragmentList;

    public MessageParserImpl(ORB orb) {
        this.orb = orb;
        this.expectingMoreData = false;
        this.moreBytesToParse = false;
        this.nextMsgStartPos = 0;
        this.fragmentList = new LinkedList<CorbaRequestId>();
        this.sizeNeeded = orb.getORBData().getReadByteBufferSize();
    }

    public boolean isExpectingMoreData() {
        return this.expectingMoreData;
    }

    public Message parseBytes(ByteBuffer byteBuffer, CorbaConnection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".parseBytes->: " + this.stateString(byteBuffer));
        }
        MessageBase message = null;
        int bytesInBuffer = byteBuffer.limit() - this.nextMsgStartPos;
        if (bytesInBuffer >= 12) {
            message = MessageBase.parseGiopHeader(this.orb, connection, byteBuffer, this.nextMsgStartPos);
            if (bytesInBuffer >= message.getSize()) {
                int savedLimit = byteBuffer.limit();
                byteBuffer.position(this.nextMsgStartPos).limit(this.nextMsgStartPos + message.getSize());
                ByteBuffer msgByteBuffer = byteBuffer.slice();
                this.nextMsgStartPos = byteBuffer.limit();
                byteBuffer.position(this.nextMsgStartPos).limit(savedLimit);
                message.setByteBuffer(msgByteBuffer);
                if (this.orb.giopDebugFlag) {
                    ByteBuffer viewBuf = msgByteBuffer.asReadOnlyBuffer();
                    viewBuf.position(viewBuf.limit());
                    CorbaRequestId requestId = MessageBase.getRequestIdFromMessageBytes(message);
                    this.dprint(".parseBytes: " + MessageBase.typeToString(message.getType()) + " with request id/" + requestId.toString() + ": successfully parsed with sliced " + "ByteBuffer: " + msgByteBuffer.toString() + " :");
                    ORBUtility.printBuffer("GIOP Message Body", viewBuf, System.out);
                }
                if (MessageBase.messageSupportsFragments(message)) {
                    CorbaRequestId requestId;
                    if (message.moreFragmentsToFollow()) {
                        requestId = MessageBase.getRequestIdFromMessageBytes(message);
                        if (!this.fragmentList.contains(requestId)) {
                            this.fragmentList.add(requestId);
                            if (this.orb.transportDebugFlag) {
                                this.dprint(".parseBytes: added to fragmentList request id/" + requestId);
                            }
                        } else if (this.orb.transportDebugFlag) {
                            this.dprint(".parseBytes: fragmentList already has an entry for request id/" + requestId);
                        }
                    } else if (message.getType() == 7 || message.getType() == 2) {
                        requestId = MessageBase.getRequestIdFromMessageBytes(message);
                        if (this.fragmentList.size() > 0 && this.fragmentList.remove(requestId) && this.orb.transportDebugFlag) {
                            this.dprint(".parseBytes: removed from fragmentList request id/" + requestId);
                        }
                    }
                    this.expectingMoreData = this.fragmentList.size() > 0;
                }
                if (byteBuffer.hasRemaining()) {
                    this.moreBytesToParse = true;
                } else {
                    this.moreBytesToParse = false;
                    byteBuffer.limit(byteBuffer.capacity());
                }
                this.sizeNeeded = this.orb.getORBData().getReadByteBufferSize();
            } else {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".parseBytes: not enough bytes available in ByteBuffer to parse a complete GIOP message: " + bytesInBuffer + " : bytes needed: " + message.getSize() + " ByteBuffer state: " + byteBuffer.toString());
                }
                this.moreBytesToParse = false;
                this.expectingMoreData = true;
                byteBuffer.position(byteBuffer.limit()).limit(byteBuffer.capacity());
                this.sizeNeeded = message.getSize();
                message = null;
            }
        } else {
            if (this.orb.transportDebugFlag) {
                this.dprint(".parseBytes: not enough bytes available in ByteBuffer to parse GIOP 12 byte message header: " + bytesInBuffer + " : ByteBuffer state: " + byteBuffer.toString());
            }
            this.moreBytesToParse = false;
            this.expectingMoreData = true;
            byteBuffer.position(byteBuffer.limit()).limit(byteBuffer.capacity());
            this.sizeNeeded = this.orb.getORBData().getReadByteBufferSize();
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".parseBytes<-: " + this.stateString(byteBuffer));
        }
        return message;
    }

    public boolean hasMoreBytesToParse() {
        return this.moreBytesToParse;
    }

    public void setNextMessageStartPosition(int position) {
        this.nextMsgStartPos = position;
    }

    public int getNextMessageStartPosition() {
        return this.nextMsgStartPos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringPrefix()).append("]");
        return sb.toString();
    }

    private String stateString(ByteBuffer byteBuffer) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringPrefix()).append(" ").append(byteBuffer.toString());
        return sb.toString();
    }

    private String toStringPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageParserImpl[nextMsgStartPos=" + this.nextMsgStartPos + ", expectingMoreData=" + this.expectingMoreData + ", moreBytesToParse=" + this.moreBytesToParse + ", fragmentList size=" + this.fragmentList.size() + ", size needed=" + this.sizeNeeded + "]");
        return sb.toString();
    }

    public int getSizeNeeded() {
        return this.sizeNeeded;
    }

    private void dprint(String msg) {
        ORBUtility.dprint("MessageParserImpl", msg);
    }
}

