/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.transport;

import com.sun.corba.ee.impl.orbutil.transport.ConnectionCacheNonBlockingBase;
import com.sun.corba.ee.spi.orbutil.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.orbutil.concurrent.ConcurrentQueueFactory;
import com.sun.corba.ee.spi.orbutil.transport.Connection;
import com.sun.corba.ee.spi.orbutil.transport.ConnectionFinder;
import com.sun.corba.ee.spi.orbutil.transport.ContactInfo;
import com.sun.corba.ee.spi.orbutil.transport.OutboundConnectionCache;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutboundConnectionCacheImpl<C extends Connection>
extends ConnectionCacheNonBlockingBase<C>
implements OutboundConnectionCache<C> {
    private final int maxParallelConnections;
    private ConcurrentMap<ContactInfo<C>, CacheEntry<C>> entryMap;
    private ConcurrentMap<C, ConnectionState<C>> connectionMap;

    @Override
    public int maxParallelConnections() {
        return this.maxParallelConnections;
    }

    @Override
    protected String thisClassName() {
        return "OutboundConnectionCacheImpl";
    }

    public OutboundConnectionCacheImpl(String cacheType, int highWaterMark, int numberToReclaim, int maxParallelConnections, Logger logger) {
        super(cacheType, highWaterMark, numberToReclaim, logger);
        this.maxParallelConnections = maxParallelConnections;
        this.entryMap = new ConcurrentHashMap<ContactInfo<C>, CacheEntry<C>>();
        this.connectionMap = new ConcurrentHashMap<C, ConnectionState<C>>();
        if (this.debug()) {
            this.dprint(".constructor completed: " + cacheType);
        }
    }

    @Override
    public C get(ContactInfo<C> cinfo, ConnectionFinder<C> finder) throws IOException {
        return this.get(cinfo);
    }

    @Override
    public C get(ContactInfo<C> cinfo) throws IOException {
        CacheEntry<C> entry = this.getEntry(cinfo);
        Connection result = null;
        int totalConnections = this.totalBusy.get() + this.totalIdle.get();
        if (totalConnections >= this.highWaterMark()) {
            this.reclaim();
        }
        do {
            ConnectionState<Connection> cs;
            entry.idleConnections.poll();
            if (result == null) {
                if (this.canCreateNewConnection(entry)) {
                    result = (Connection)cinfo.createConnection();
                    cs = new ConnectionState<Connection>(cinfo, entry, result);
                    this.connectionMap.put(result, cs);
                    if (this.debug()) {
                        this.dprint(".get: created connection " + result);
                    }
                    cs.busyCount.incrementAndGet();
                    entry.busyConnections.offer(result);
                    this.totalBusy.incrementAndGet();
                    continue;
                }
                if (this.debug()) {
                    this.dprint(".get: re-using busy connection " + result);
                }
                if ((result = (Connection)entry.busyConnections.poll()) == null) continue;
                entry.busyConnections.offer(result);
                continue;
            }
            cs = (ConnectionState<Connection>)this.connectionMap.get(result);
            ConcurrentQueue.Handle handle = cs.reclaimableHandle;
            if (handle == null) continue;
            if (handle.remove()) {
                this.totalIdle.decrementAndGet();
                this.totalBusy.incrementAndGet();
                entry.busyConnections.offer(result);
                continue;
            }
            result = null;
            if (!this.debug()) continue;
            this.dprint(".get: using idle connection " + result);
        } while (result != null);
        return (C)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(C conn, int numResponsesExpected) {
        if (this.debug()) {
            this.dprint("->release: connection " + conn + " expecting " + numResponsesExpected + " responses");
        }
        try {
            ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
            if (cs == null) {
                if (this.debug()) {
                    this.dprint(".release: connection " + conn + " was closed");
                }
                return;
            }
            int numResp = cs.expectedResponseCount.addAndGet(numResponsesExpected);
            int numBusy = cs.busyCount.decrementAndGet();
            if (this.debug()) {
                this.dprint(".release: " + numResp + " responses expected");
                this.dprint(".release: " + numBusy + " responses expected");
            }
            if (numBusy == 0) {
                ConcurrentQueue.Handle busyHandle = cs.busyHandle;
                CacheEntry entry = cs.entry;
                boolean wasOnBusy = false;
                if (busyHandle != null) {
                    wasOnBusy = busyHandle.remove();
                }
                if (wasOnBusy) {
                    if (cs.busyCount.get() > 0) {
                        if (this.debug()) {
                            this.dprint(".release: re-queuing busy connection " + conn);
                        }
                        cs.busyHandle = entry.busyConnections.offer(conn);
                    } else {
                        if (cs.expectedResponseCount.get() == 0) {
                            if (this.debug()) {
                                this.dprint(".release: queuing reclaimable connection " + conn);
                            }
                            cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                            this.totalBusy.decrementAndGet();
                        }
                        if (this.debug()) {
                            this.dprint(".release: queuing idle connection " + conn);
                        }
                        cs.idleHandle = entry.idleConnections.offer(conn);
                    }
                }
            }
        }
        finally {
            if (this.debug()) {
                this.dprint("<-release");
            }
        }
    }

    @Override
    public void responseReceived(C conn) {
        ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
        ConcurrentQueue.Handle idleHandle = cs.idleHandle;
        CacheEntry entry = cs.entry;
        int waitCount = cs.expectedResponseCount.decrementAndGet();
        if (waitCount == 0) {
            boolean wasOnIdle = false;
            if (cs != null) {
                wasOnIdle = cs.idleHandle.remove();
            }
            if (wasOnIdle) {
                cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
            }
        }
    }

    @Override
    public void close(C conn) {
        block5: {
            ConcurrentQueue.Handle ih;
            ConcurrentQueue.Handle bh;
            ConnectionState cs = (ConnectionState)this.connectionMap.remove(conn);
            CacheEntry entry = (CacheEntry)this.entryMap.remove(cs.cinfo);
            ConcurrentQueue.Handle rh = cs.reclaimableHandle;
            if (rh != null) {
                rh.remove();
            }
            if ((bh = cs.busyHandle) != null) {
                bh.remove();
            }
            if ((ih = cs.idleHandle) != null) {
                ih.remove();
            }
            try {
                conn.close();
            }
            catch (IOException exc) {
                if (!this.debug()) break block5;
                this.dprint(".close: " + conn + " close threw " + exc);
            }
        }
    }

    private CacheEntry<C> getEntry(ContactInfo<C> cinfo) {
        CacheEntry entry = new CacheEntry();
        CacheEntry result = this.entryMap.putIfAbsent(cinfo, entry);
        if (result != null) {
            return result;
        }
        return entry;
    }

    @Override
    private boolean canCreateNewConnection(CacheEntry<C> entry) {
        int totalConnections = this.totalBusy.get() + this.totalIdle.get();
        int totalConnectionsInEntry = entry.totalConnections();
        return totalConnectionsInEntry == 0 || totalConnections < this.highWaterMark() && totalConnectionsInEntry < this.maxParallelConnections;
    }

    @Override
    public boolean canCreateNewConnection(ContactInfo<C> cinfo) {
        CacheEntry entry = (CacheEntry)this.entryMap.get(cinfo);
        if (entry == null) {
            return true;
        }
        return this.canCreateNewConnection(entry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheEntry<C extends Connection> {
        final ConcurrentQueue<C> idleConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue();
        final ConcurrentQueue<C> busyConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue();

        private CacheEntry() {
        }

        public int totalConnections() {
            return this.idleConnections.size() + this.busyConnections.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectionState<C extends Connection> {
        final ContactInfo<C> cinfo;
        final C connection;
        final CacheEntry<C> entry;
        final AtomicInteger busyCount;
        final AtomicInteger expectedResponseCount;
        ConcurrentQueue.Handle reclaimableHandle;
        ConcurrentQueue.Handle idleHandle;
        ConcurrentQueue.Handle busyHandle;

        ConnectionState(ContactInfo<C> cinfo, CacheEntry<C> entry, C conn) {
            this.cinfo = cinfo;
            this.connection = conn;
            this.entry = entry;
            this.busyCount = new AtomicInteger();
            this.expectedResponseCount = new AtomicInteger();
            this.reclaimableHandle = null;
            this.idleHandle = null;
            this.busyHandle = null;
        }
    }
}

