/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.ServerTableEntry;
import com.sun.corba.ee.impl.logging.ActivationSystemException;
import com.sun.corba.ee.spi.activation.BadServerDefinition;
import com.sun.corba.ee.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.ee.spi.activation.ServerAlreadyInstalled;
import com.sun.corba.ee.spi.activation.ServerAlreadyRegistered;
import com.sun.corba.ee.spi.activation.ServerAlreadyUninstalled;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import com.sun.corba.ee.spi.activation._RepositoryImplBase;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.SocketOrChannelAcceptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RepositoryImpl
extends _RepositoryImplBase
implements Serializable {
    private static final long serialVersionUID = 8458417785209341858L;
    private transient boolean debug = false;
    static final int illegalServerId = -1;
    private transient RepositoryDB db = null;
    transient ORB orb = null;
    transient ActivationSystemException wrapper;

    RepositoryImpl(ORB orb, File dbDir, boolean debug) {
        this.debug = debug;
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_ORBD_REPOSITORY_Activation();
        File dbFile = new File(dbDir, "servers.db");
        if (!dbFile.exists()) {
            this.db = new RepositoryDB(dbFile);
            this.db.flush();
        } else {
            try {
                FileInputStream fis = new FileInputStream(dbFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.db = (RepositoryDB)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                throw this.wrapper.cannotReadRepositoryDb(e);
            }
        }
        orb.connect(this);
    }

    private String printServerDef(ServerDef sd) {
        return "ServerDef[applicationName=" + sd.applicationName + " serverName=" + sd.serverName + " serverClassPath=" + sd.serverClassPath + " serverArgs=" + sd.serverArgs + " serverVmArgs=" + sd.serverVmArgs + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerServer(ServerDef serverDef, int theServerId) throws ServerAlreadyRegistered {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            for (DBServerDef server : this.db.serverTable.values()) {
                if (!serverDef.applicationName.equals(server.applicationName)) continue;
                if (this.debug) {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with " + (theServerId == -1 ? "a new server Id" : "server Id " + theServerId) + " FAILED because it is already registered.");
                }
                throw new ServerAlreadyRegistered(server.id);
            }
            int serverId = theServerId == -1 ? this.db.incrementServerIdCounter() : theServerId;
            DBServerDef server = new DBServerDef(serverDef, serverId);
            this.db.serverTable.put(serverId, server);
            this.db.flush();
            if (this.debug) {
                if (theServerId == -1) {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with new serverId " + serverId);
                } else {
                    System.out.println("RepositoryImpl: registerServer called to register ServerDef " + this.printServerDef(serverDef) + " with assigned serverId " + serverId);
                }
            }
            return serverId;
        }
    }

    public int registerServer(ServerDef serverDef) throws ServerAlreadyRegistered, BadServerDefinition {
        LegacyServerSocketEndPointInfo endpoint = this.orb.getLegacyServerSocketManager().legacyGetEndpoint("BOOT_NAMING");
        int initSvcPort = ((SocketOrChannelAcceptor)((Object)endpoint)).getServerSocket().getLocalPort();
        ServerTableEntry entry = new ServerTableEntry(this.wrapper, -1, serverDef, initSvcPort, "", true, this.debug);
        switch (entry.verify()) {
            case 0: {
                break;
            }
            case 1: {
                throw new BadServerDefinition("main class not found.");
            }
            case 2: {
                throw new BadServerDefinition("no main method found.");
            }
            case 3: {
                throw new BadServerDefinition("server application error.");
            }
            default: {
                throw new BadServerDefinition("unknown Exception.");
            }
        }
        return this.registerServer(serverDef, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServer(int serverId) throws ServerNotRegistered {
        DBServerDef server = null;
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            server = (DBServerDef)this.db.serverTable.get(serverId);
            if (server == null) {
                if (this.debug) {
                    System.out.println("RepositoryImpl: unregisterServer for serverId " + serverId + " called: server not registered");
                }
                throw new ServerNotRegistered();
            }
            this.db.serverTable.remove(serverId);
            this.db.flush();
        }
        if (this.debug) {
            System.out.println("RepositoryImpl: unregisterServer for serverId " + serverId + " called");
        }
    }

    private DBServerDef getDBServerDef(int serverId) throws ServerNotRegistered {
        DBServerDef server = (DBServerDef)this.db.serverTable.get(serverId);
        if (server == null) {
            throw new ServerNotRegistered(serverId);
        }
        return server;
    }

    public ServerDef getServer(int serverId) throws ServerNotRegistered {
        DBServerDef server = this.getDBServerDef(serverId);
        ServerDef serverDef = new ServerDef(server.applicationName, server.name, server.classPath, server.args, server.vmArgs);
        if (this.debug) {
            System.out.println("RepositoryImpl: getServer for serverId " + serverId + " returns " + this.printServerDef(serverDef));
        }
        return serverDef;
    }

    public boolean isInstalled(int serverId) throws ServerNotRegistered {
        DBServerDef server = this.getDBServerDef(serverId);
        return server.isInstalled;
    }

    public void install(int serverId) throws ServerNotRegistered, ServerAlreadyInstalled {
        DBServerDef server = this.getDBServerDef(serverId);
        if (server.isInstalled) {
            throw new ServerAlreadyInstalled(serverId);
        }
        server.isInstalled = true;
        this.db.flush();
    }

    public void uninstall(int serverId) throws ServerNotRegistered, ServerAlreadyUninstalled {
        DBServerDef server = this.getDBServerDef(serverId);
        if (!server.isInstalled) {
            throw new ServerAlreadyUninstalled(serverId);
        }
        server.isInstalled = false;
        this.db.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] listRegisteredServers() {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            int i = 0;
            int[] servers = new int[this.db.serverTable.size()];
            for (DBServerDef server : this.db.serverTable.values()) {
                servers[i++] = server.id;
            }
            if (this.debug) {
                StringBuffer sb = new StringBuffer();
                for (int ctr = 0; ctr < servers.length; ++ctr) {
                    sb.append(' ');
                    sb.append(servers[ctr]);
                }
                System.out.println("RepositoryImpl: listRegisteredServers returns" + sb.toString());
            }
            return servers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerID(String applicationName) throws ServerNotRegistered {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            int result = -1;
            for (Map.Entry entry : this.db.serverTable.entrySet()) {
                if (!((DBServerDef)entry.getValue()).applicationName.equals(applicationName)) continue;
                result = (Integer)entry.getKey();
                break;
            }
            if (this.debug) {
                System.out.println("RepositoryImpl: getServerID for " + applicationName + " is " + result);
            }
            if (result == -1) {
                throw new ServerNotRegistered();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getApplicationNames() {
        RepositoryDB repositoryDB = this.db;
        synchronized (repositoryDB) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry entry : this.db.serverTable.entrySet()) {
                if (((DBServerDef)entry.getValue()).applicationName.equals("")) continue;
                result.add(((DBServerDef)entry.getValue()).applicationName);
            }
            String[] apps = result.toArray(new String[result.size()]);
            if (this.debug) {
                StringBuffer sb = new StringBuffer();
                for (int ctr = 0; ctr < apps.length; ++ctr) {
                    sb.append(' ');
                    sb.append(apps[ctr]);
                }
                System.out.println("RepositoryImpl: getApplicationNames returns " + sb.toString());
            }
            return apps;
        }
    }

    public static void main(String[] args) {
        boolean debug = false;
        for (int ctr = 0; ctr < args.length; ++ctr) {
            if (!args[ctr].equals("-debug")) continue;
            debug = true;
        }
        try {
            Properties props = new Properties();
            props.put("org.omg.CORBA.ORBClass", "com.sun.corba.ee.impl.orb.ORBImpl");
            ORB orb = (ORB)((Object)ORB.init((String[])args, (Properties)props));
            String db = System.getProperty("com.sun.corba.ee.activation.db", "db");
            new RepositoryImpl(orb, new File(db), debug);
            orb.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class DBServerDef
    implements Serializable {
        String applicationName;
        String name;
        String classPath;
        String args;
        String vmArgs;
        boolean isInstalled;
        int id;

        public String toString() {
            return "DBServerDef(applicationName=" + this.applicationName + ", name=" + this.name + ", classPath=" + this.classPath + ", args=" + this.args + ", vmArgs=" + this.vmArgs + ", id=" + this.id + ", isInstalled=" + this.isInstalled + ")";
        }

        DBServerDef(ServerDef server, int server_id) {
            this.applicationName = server.applicationName;
            this.name = server.serverName;
            this.classPath = server.serverClassPath;
            this.args = server.serverArgs;
            this.vmArgs = server.serverVmArgs;
            this.id = server_id;
            this.isInstalled = false;
        }
    }

    class RepositoryDB
    implements Serializable {
        private File db;
        private Map<Integer, DBServerDef> serverTable;
        private Integer serverIdCounter;

        RepositoryDB(File dbFile) {
            this.db = dbFile;
            this.serverTable = new HashMap<Integer, DBServerDef>(255);
            this.serverIdCounter = new Integer(256);
        }

        int incrementServerIdCounter() {
            int value = this.serverIdCounter;
            this.serverIdCounter = new Integer(++value);
            return value;
        }

        void flush() {
            try {
                this.db.delete();
                FileOutputStream fos = new FileOutputStream(this.db);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this);
                oos.flush();
                oos.close();
            }
            catch (Exception ex) {
                throw RepositoryImpl.this.wrapper.cannotWriteRepositoryDb(ex);
            }
        }
    }
}

