/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.AuthenticationException;
import com.sun.scn.client.comm.RegSender;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.client.util.SCRKClientHelper;
import com.sun.scn.dao.Domain;
import com.sun.scn.servicetags.Agent;
import com.sun.scn.servicetags.AuthenticationCredential;
import com.sun.scn.servicetags.EnvironmentInformation;
import com.sun.scn.servicetags.SunOnlineAccount;
import com.sun.scn.servicetags.SvcTag;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationWrapper {
    private String registratorId;
    private String proxyHost;
    private int proxyPort;
    private ResourceBundle resources = null;

    public RegistrationWrapper(String registratorId) {
        this.init(registratorId, null, -1);
    }

    public RegistrationWrapper(String registratorId, String proxyHost, int proxyPort) {
        this.init(registratorId, proxyHost, proxyPort);
    }

    public ResourceBundle getResourceBundle() {
        return this.resources;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resources = bundle;
    }

    public String getPrivacyPolicyText() {
        return this.resources.getString("privacy.text");
    }

    public String getTermsOfUseLink() {
        return this.resources.getString("tou.link");
    }

    public List<Domain> getDomains(AuthenticationCredential cred) throws SvcTagException {
        String clientId = cred.getRegistrationClientId();
        KeyPair keyPair = cred.getKeyPair();
        String user = cred.getUsername();
        if (clientId == null || keyPair == null || user == null) {
            return null;
        }
        List<Domain> domains = null;
        domains = this.proxyHost == null || this.proxyHost.equals("") || this.proxyPort == -1 ? RegSender.getUserDomains(user, keyPair, clientId) : RegSender.getUserDomains(user, this.proxyHost, this.proxyPort, keyPair, clientId);
        return domains;
    }

    public void createSunOnlineAccount(SunOnlineAccount soa) throws SvcTagException {
        if (soa.getUserid() == null || soa.getUserid().trim().equals("")) {
            throw new SvcTagException(this.resources.getString("create.soa.missing.userid"));
        }
        if (soa.getLastname() == null || soa.getLastname().trim().equals("")) {
            throw new SvcTagException(this.resources.getString("create.soa.missing.lastname"));
        }
        if (soa.getFirstname() == null || soa.getFirstname().trim().equals("")) {
            throw new SvcTagException(this.resources.getString("create.soa.missing.firstname"));
        }
        if (soa.getEmail() == null || soa.getEmail().trim().equals("")) {
            throw new SvcTagException(this.resources.getString("create.soa.missing.email"));
        }
        if (soa.getPassword() == null || soa.getPassword().length() < 6) {
            throw new SvcTagException(this.resources.getString("create.soa.invalid.password"));
        }
        RegSender.createSunOnlineAccount(soa, this.proxyHost, this.proxyPort);
    }

    public void registerServiceTag(EnvironmentInformation environment, SvcTag serviceTag, String registryURN, String user, String pass) throws SvcTagException, AuthenticationException, ConnectException, UnknownHostException {
        ArrayList<SvcTag> set = new ArrayList<SvcTag>();
        set.add(serviceTag);
        this.registerServiceTags(environment, set, registryURN, user, pass);
    }

    public AuthenticationCredential authenticate(String user, String pass) throws SvcTagException, AuthenticationException, ConnectException, UnknownHostException {
        KeyPair keyPair = null;
        String clientId = null;
        try {
            SCRKClientHelper clientHelper = new SCRKClientHelper();
            keyPair = clientHelper.getKeyPair();
            clientId = clientHelper.getClientRegId(keyPair, user, pass, this.proxyHost, this.proxyPort);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (RuntimeException rte) {
            throw new SvcTagException(rte.getMessage());
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
        if (keyPair == null) {
            throw new SvcTagException(this.resources.getString("error.scrk.keypair"));
        }
        if (clientId == null) {
            throw new AuthenticationException(this.resources.getString("error.scrk.regid"));
        }
        AuthenticationCredential cred = new AuthenticationCredential(keyPair, clientId, user);
        return cred;
    }

    public void registerServiceTags(EnvironmentInformation environment, List<SvcTag> serviceTags, String registryURN, String user, String pass) throws SvcTagException, AuthenticationException, ConnectException, UnknownHostException {
        this.registerServiceTags(environment, serviceTags, registryURN, this.authenticate(user, pass));
    }

    public void registerServiceTags(EnvironmentInformation environment, List<SvcTag> serviceTags, String registryURN, AuthenticationCredential cred) throws SvcTagException, ConnectException, UnknownHostException {
        String agentUrn;
        if (cred == null) {
            throw new SvcTagException(this.resources.getString("error.auth.nullcredentials"));
        }
        String clientId = cred.getRegistrationClientId();
        KeyPair keyPair = cred.getKeyPair();
        String user = cred.getUsername();
        List<Domain> domains = this.getDomains(cred);
        Domain domain = this.getDefaultDomain(domains, user);
        if (domain == null) {
            throw new SvcTagException(this.resources.getString("error.default.domain"));
        }
        try {
            agentUrn = registryURN;
            if (agentUrn == null) {
                agentUrn = "urn:st:" + this.registratorId + UUID.randomUUID().toString();
            }
            Agent agent = new Agent(agentUrn);
            agent.host = environment.getHostname();
            agent.hostid = environment.getHostId();
            agent.serialNumber = environment.getSerialNumber();
            agent.system = environment.getOsName();
            agent.release = environment.getOsVersion();
            agent.architecture = environment.getOsArchitecture();
            agent.platform = environment.getSystemModel();
            agent.manufacturer = environment.getSystemManufacturer();
            agent.cpuManufacturer = environment.getCpuManufacturer();
            if (this.proxyHost == null || this.proxyHost.equals("") || this.proxyPort == -1) {
                RegSender.sendPut(agent.toXMLElement(false), "agent/" + agent.getAgentURN(), keyPair, clientId);
            } else {
                RegSender.sendPut(agent.toXMLElement(false), "agent/" + agent.getAgentURN(), this.proxyHost, this.proxyPort, keyPair, clientId);
            }
        }
        catch (SvcTagException ste) {
            throw ste;
        }
        catch (Exception e) {
            throw new SvcTagException(this.resources.getString("error.registration.agent"));
        }
        for (SvcTag serviceTag : serviceTags) {
            try {
                serviceTag.setRegistrationClientURN("urn:st:" + this.registratorId + UUID.randomUUID().toString());
                serviceTag.setUserID(user);
                serviceTag.setAgentURN(agentUrn);
                serviceTag.setStatus("REGISTERED");
                serviceTag.setDomainId(domain.getDomainId());
                serviceTag.setDomainName(domain.getDomainName());
                if (this.proxyHost == null || this.proxyHost.equals("") || this.proxyPort == -1) {
                    RegSender.sendPut(serviceTag.toXMLElement(), "svctag/" + serviceTag.getInstanceURN(), keyPair, clientId);
                    continue;
                }
                RegSender.sendPut(serviceTag.toXMLElement(), "svctag/" + serviceTag.getInstanceURN(), this.proxyHost, this.proxyPort, keyPair, clientId);
            }
            catch (SvcTagException ste) {
                throw ste;
            }
            catch (Exception e) {
                throw new SvcTagException(this.resources.getString("error.registration.svctag"));
            }
        }
    }

    public List<String> getAvailableSecurityQuestions() {
        ArrayList<String> secQuestions = new ArrayList<String>();
        secQuestions.add(this.resources.getString("security.question.color"));
        secQuestions.add(this.resources.getString("security.question.pet"));
        secQuestions.add(this.resources.getString("security.question.vacation"));
        return secQuestions;
    }

    public List<String> getAvailableCountries() {
        ArrayList<String> countries = new ArrayList<String>();
        countries.add(this.resources.getString("country.Albania"));
        countries.add(this.resources.getString("country.Algeria"));
        countries.add(this.resources.getString("country.AmericanSamoa"));
        countries.add(this.resources.getString("country.Andorra"));
        countries.add(this.resources.getString("country.Angola"));
        countries.add(this.resources.getString("country.Anguilla"));
        countries.add(this.resources.getString("country.Antarctica"));
        countries.add(this.resources.getString("country.Antigua&Barbuda"));
        countries.add(this.resources.getString("country.Argentina"));
        countries.add(this.resources.getString("country.Armenia"));
        countries.add(this.resources.getString("country.Aruba"));
        countries.add(this.resources.getString("country.AscensionIsland"));
        countries.add(this.resources.getString("country.Australia"));
        countries.add(this.resources.getString("country.Austria"));
        countries.add(this.resources.getString("country.Azerbaijan"));
        countries.add(this.resources.getString("country.Bahamas"));
        countries.add(this.resources.getString("country.Bahrain"));
        countries.add(this.resources.getString("country.Bangladesh"));
        countries.add(this.resources.getString("country.Barbados"));
        countries.add(this.resources.getString("country.Belarus"));
        countries.add(this.resources.getString("country.Belgium"));
        countries.add(this.resources.getString("country.Belize"));
        countries.add(this.resources.getString("country.Benin"));
        countries.add(this.resources.getString("country.Bermuda"));
        countries.add(this.resources.getString("country.Bhutan"));
        countries.add(this.resources.getString("country.Bolivia"));
        countries.add(this.resources.getString("country.BosniaandHerzegovina"));
        countries.add(this.resources.getString("country.Botswana"));
        countries.add(this.resources.getString("country.BouvetIsland"));
        countries.add(this.resources.getString("country.Brazil"));
        countries.add(this.resources.getString("country.BritishIndianOceanTerritory"));
        countries.add(this.resources.getString("country.BruneiDarussalam"));
        countries.add(this.resources.getString("country.Bulgaria"));
        countries.add(this.resources.getString("country.BurkinaFaso"));
        countries.add(this.resources.getString("country.Burundi"));
        countries.add(this.resources.getString("country.Cambodia"));
        countries.add(this.resources.getString("country.Cameroon"));
        countries.add(this.resources.getString("country.Canada"));
        countries.add(this.resources.getString("country.CapeVerde"));
        countries.add(this.resources.getString("country.CaymanIslands"));
        countries.add(this.resources.getString("country.CentralAfricanRepublic"));
        countries.add(this.resources.getString("country.Chad"));
        countries.add(this.resources.getString("country.Chile"));
        countries.add(this.resources.getString("country.China"));
        countries.add(this.resources.getString("country.ChristmasIsland"));
        countries.add(this.resources.getString("country.Cocos(Keeling)Islands"));
        countries.add(this.resources.getString("country.Colombia"));
        countries.add(this.resources.getString("country.Comoros"));
        countries.add(this.resources.getString("country.Congo,DemocraticRepublicofthe"));
        countries.add(this.resources.getString("country.Congo,Republicof"));
        countries.add(this.resources.getString("country.CookIslands"));
        countries.add(this.resources.getString("country.CostaRica"));
        countries.add(this.resources.getString("country.Coted'Ivoire"));
        countries.add(this.resources.getString("country.Croatia/Hrvatska"));
        countries.add(this.resources.getString("country.Cyprus"));
        countries.add(this.resources.getString("country.CzechRepublic"));
        countries.add(this.resources.getString("country.Denmark"));
        countries.add(this.resources.getString("country.Djibouti"));
        countries.add(this.resources.getString("country.Dominica"));
        countries.add(this.resources.getString("country.DominicanRepublic"));
        countries.add(this.resources.getString("country.EastTimor"));
        countries.add(this.resources.getString("country.Ecuador"));
        countries.add(this.resources.getString("country.Egypt"));
        countries.add(this.resources.getString("country.ElSalvador"));
        countries.add(this.resources.getString("country.EquatorialGuinea"));
        countries.add(this.resources.getString("country.Eritrea"));
        countries.add(this.resources.getString("country.Estonia"));
        countries.add(this.resources.getString("country.Ethiopia"));
        countries.add(this.resources.getString("country.FalklandIslands(Malvina)"));
        countries.add(this.resources.getString("country.FaroeIslands"));
        countries.add(this.resources.getString("country.Fiji"));
        countries.add(this.resources.getString("country.Finland"));
        countries.add(this.resources.getString("country.France"));
        countries.add(this.resources.getString("country.France(Metropolitan)"));
        countries.add(this.resources.getString("country.FrenchGuiana"));
        countries.add(this.resources.getString("country.FrenchPolynesia"));
        countries.add(this.resources.getString("country.FrenchSouthernTerritories"));
        countries.add(this.resources.getString("country.Gabon"));
        countries.add(this.resources.getString("country.Gambia"));
        countries.add(this.resources.getString("country.Georgia"));
        countries.add(this.resources.getString("country.Germany"));
        countries.add(this.resources.getString("country.Ghana"));
        countries.add(this.resources.getString("country.Gibraltar"));
        countries.add(this.resources.getString("country.Greece"));
        countries.add(this.resources.getString("country.Greenland"));
        countries.add(this.resources.getString("country.Grenada"));
        countries.add(this.resources.getString("country.Guadeloupe"));
        countries.add(this.resources.getString("country.Guam"));
        countries.add(this.resources.getString("country.Guatemala"));
        countries.add(this.resources.getString("country.Guernsey"));
        countries.add(this.resources.getString("country.Guinea"));
        countries.add(this.resources.getString("country.Guinea-Bissau"));
        countries.add(this.resources.getString("country.Guyana"));
        countries.add(this.resources.getString("country.Haiti"));
        countries.add(this.resources.getString("country.HeardandMcDonaldIslands"));
        countries.add(this.resources.getString("country.HolySee(CityVaticanState)"));
        countries.add(this.resources.getString("country.Honduras"));
        countries.add(this.resources.getString("country.HongKong"));
        countries.add(this.resources.getString("country.Hungary"));
        countries.add(this.resources.getString("country.Iceland"));
        countries.add(this.resources.getString("country.India"));
        countries.add(this.resources.getString("country.Indonesia"));
        countries.add(this.resources.getString("country.Ireland"));
        countries.add(this.resources.getString("country.IsleofMan"));
        countries.add(this.resources.getString("country.Israel"));
        countries.add(this.resources.getString("country.Italy"));
        countries.add(this.resources.getString("country.Jamaica"));
        countries.add(this.resources.getString("country.Japan"));
        countries.add(this.resources.getString("country.Jersey"));
        countries.add(this.resources.getString("country.Jordan"));
        countries.add(this.resources.getString("country.Kazakhstan"));
        countries.add(this.resources.getString("country.Kenya"));
        countries.add(this.resources.getString("country.Kiribati"));
        countries.add(this.resources.getString("country.Korea,Republicof"));
        countries.add(this.resources.getString("country.Kuwait"));
        countries.add(this.resources.getString("country.Kyrgyzstan"));
        countries.add(this.resources.getString("country.LaoPeople'sDemocraticRepublic"));
        countries.add(this.resources.getString("country.Latvia"));
        countries.add(this.resources.getString("country.Lebanon"));
        countries.add(this.resources.getString("country.Lesotho"));
        countries.add(this.resources.getString("country.Liberia"));
        countries.add(this.resources.getString("country.LibyanArabJamahiriya"));
        countries.add(this.resources.getString("country.Liechtenstein"));
        countries.add(this.resources.getString("country.Lithuania"));
        countries.add(this.resources.getString("country.Luxembourg"));
        countries.add(this.resources.getString("country.Macau"));
        countries.add(this.resources.getString("country.Macedonia,FormerYugoslavRepublic"));
        countries.add(this.resources.getString("country.Madagascar"));
        countries.add(this.resources.getString("country.Malawi"));
        countries.add(this.resources.getString("country.Malaysia"));
        countries.add(this.resources.getString("country.Maldives"));
        countries.add(this.resources.getString("country.Mali"));
        countries.add(this.resources.getString("country.Malta"));
        countries.add(this.resources.getString("country.MarshallIslands"));
        countries.add(this.resources.getString("country.Martinique"));
        countries.add(this.resources.getString("country.Mauritania"));
        countries.add(this.resources.getString("country.Mauritius"));
        countries.add(this.resources.getString("country.Mayotte"));
        countries.add(this.resources.getString("country.Mexico"));
        countries.add(this.resources.getString("country.Micronesia,FederalStateof"));
        countries.add(this.resources.getString("country.Moldova,Republicof"));
        countries.add(this.resources.getString("country.Monaco"));
        countries.add(this.resources.getString("country.Mongolia"));
        countries.add(this.resources.getString("country.Montserrat"));
        countries.add(this.resources.getString("country.Morocco"));
        countries.add(this.resources.getString("country.Mozambique"));
        countries.add(this.resources.getString("country.Namibia"));
        countries.add(this.resources.getString("country.Nauru"));
        countries.add(this.resources.getString("country.Nepal"));
        countries.add(this.resources.getString("country.Netherlands"));
        countries.add(this.resources.getString("country.NetherlandsAntilles"));
        countries.add(this.resources.getString("country.NewCaledonia"));
        countries.add(this.resources.getString("country.NewZealand"));
        countries.add(this.resources.getString("country.Nicaragua"));
        countries.add(this.resources.getString("country.Niger"));
        countries.add(this.resources.getString("country.Nigeria"));
        countries.add(this.resources.getString("country.Niue"));
        countries.add(this.resources.getString("country.NorfolkIslands"));
        countries.add(this.resources.getString("country.NorthernMarianaIslands"));
        countries.add(this.resources.getString("country.Norway"));
        countries.add(this.resources.getString("country.NotDetermined"));
        countries.add(this.resources.getString("country.Oman"));
        countries.add(this.resources.getString("country.Pakistan"));
        countries.add(this.resources.getString("country.Palau"));
        countries.add(this.resources.getString("country.Panama"));
        countries.add(this.resources.getString("country.PapuaNewGuinea"));
        countries.add(this.resources.getString("country.Paraguay"));
        countries.add(this.resources.getString("country.Peru"));
        countries.add(this.resources.getString("country.Philippines"));
        countries.add(this.resources.getString("country.PitcairnIsland"));
        countries.add(this.resources.getString("country.Poland"));
        countries.add(this.resources.getString("country.Portugal"));
        countries.add(this.resources.getString("country.PuertoRico"));
        countries.add(this.resources.getString("country.Qatar"));
        countries.add(this.resources.getString("country.ReunionIsland"));
        countries.add(this.resources.getString("country.Romania"));
        countries.add(this.resources.getString("country.RussianFederation"));
        countries.add(this.resources.getString("country.Rwanda"));
        countries.add(this.resources.getString("country.SaintKittsandNevis"));
        countries.add(this.resources.getString("country.SaintLucia"));
        countries.add(this.resources.getString("country.SaintVincentandtheGrenadines"));
        countries.add(this.resources.getString("country.SanMarino"));
        countries.add(this.resources.getString("country.SaoTomeandPrincipe"));
        countries.add(this.resources.getString("country.SaudiArabia"));
        countries.add(this.resources.getString("country.Senegal"));
        countries.add(this.resources.getString("country.Seychelles"));
        countries.add(this.resources.getString("country.SierraLeone"));
        countries.add(this.resources.getString("country.Singapore"));
        countries.add(this.resources.getString("country.SlovakRepublic"));
        countries.add(this.resources.getString("country.Slovenia"));
        countries.add(this.resources.getString("country.SolomonIslands"));
        countries.add(this.resources.getString("country.Somalia"));
        countries.add(this.resources.getString("country.SouthAfrica"));
        countries.add(this.resources.getString("country.SouthGeorgiaandtheSouthSandwichIslands"));
        countries.add(this.resources.getString("country.Spain"));
        countries.add(this.resources.getString("country.SriLanka"));
        countries.add(this.resources.getString("country.StPierreandMiquelon"));
        countries.add(this.resources.getString("country.St.Helena"));
        countries.add(this.resources.getString("country.Suriname"));
        countries.add(this.resources.getString("country.SvalbardandJanMayenIslands"));
        countries.add(this.resources.getString("country.Swaziland"));
        countries.add(this.resources.getString("country.Sweden"));
        countries.add(this.resources.getString("country.Switzerland"));
        countries.add(this.resources.getString("country.Taiwan"));
        countries.add(this.resources.getString("country.Tajikistan"));
        countries.add(this.resources.getString("country.Tanzania"));
        countries.add(this.resources.getString("country.Thailand"));
        countries.add(this.resources.getString("country.Togo"));
        countries.add(this.resources.getString("country.Tokelau"));
        countries.add(this.resources.getString("country.Tonga"));
        countries.add(this.resources.getString("country.TrinidadandTobago"));
        countries.add(this.resources.getString("country.Tunisia"));
        countries.add(this.resources.getString("country.Turkey"));
        countries.add(this.resources.getString("country.Turkmenistan"));
        countries.add(this.resources.getString("country.TurksandCaicosIslands"));
        countries.add(this.resources.getString("country.Tuvalu"));
        countries.add(this.resources.getString("country.USMinorOutlyingIslands"));
        countries.add(this.resources.getString("country.Uganda"));
        countries.add(this.resources.getString("country.Ukraine"));
        countries.add(this.resources.getString("country.UnitedArabEmirates"));
        countries.add(this.resources.getString("country.UnitedKingdom"));
        countries.add(this.resources.getString("country.UnitedStates"));
        countries.add(this.resources.getString("country.Uruguay"));
        countries.add(this.resources.getString("country.Uzbekistan"));
        countries.add(this.resources.getString("country.Vanuatu"));
        countries.add(this.resources.getString("country.Venezuela"));
        countries.add(this.resources.getString("country.Vietnam"));
        countries.add(this.resources.getString("country.VirginIsland(British)"));
        countries.add(this.resources.getString("country.VirginIslands(USA)"));
        countries.add(this.resources.getString("country.WallisandFutunaIslands"));
        countries.add(this.resources.getString("country.WesternSahara"));
        countries.add(this.resources.getString("country.WesternSamoa"));
        countries.add(this.resources.getString("country.Yemen"));
        countries.add(this.resources.getString("country.Yugoslavia"));
        countries.add(this.resources.getString("country.Zambia"));
        countries.add(this.resources.getString("country.Zimbabwe"));
        return countries;
    }

    private Domain getDefaultDomain(List<Domain> domains, String user) {
        Domain defaultDomain = null;
        if (domains != null && user != null) {
            for (Domain d : domains) {
                if (!d.getDomainName().toLowerCase().contains(user.toLowerCase())) continue;
                defaultDomain = d;
                return defaultDomain;
            }
            defaultDomain = domains.get(0);
        }
        return defaultDomain;
    }

    private void init(String registratorId, String proxyHost, int proxyPort) {
        if (registratorId == null) {
            registratorId = "";
        } else {
            this.registratorId = registratorId + ":";
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        Locale locale = Locale.getDefault();
        this.resources = ResourceBundle.getBundle("com.sun.scn.client.resources.bundle.RegistrationWrapper", locale);
    }
}

