/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.message.MessageBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jbi.JBIException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ArchiveHelper {
    private static final String JBI_XML = "jbi.xml";
    private static final String JBI_XML_PATH = "META-INF/jbi.xml";
    public static final String JBI_DESCRIPTOR_SCHEMA = "jbi.xsd";
    public static final String JBI_DESCRIPTOR_SCHEMA_DIR = "schemas";
    private Jbi mJbiXml;
    private Unmarshaller mReader;
    private StringTranslator mTranslator;
    private MessageBuilder mMsgBuilder;
    private File mDescSchema;

    public ArchiveHelper(EnvironmentContext envCtx) throws JBIException {
        try {
            this.mTranslator = envCtx.getStringTranslator("com.sun.jbi.management");
            this.mMsgBuilder = new MessageBuilder(this.mTranslator);
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.jbi.management.descriptor", (ClassLoader)Class.forName("com.sun.jbi.management.descriptor.Jbi").getClassLoader());
            this.mReader = jc.createUnmarshaller();
            File schemaDir = new File(envCtx.getJbiInstallRoot(), JBI_DESCRIPTOR_SCHEMA_DIR);
            this.mDescSchema = new File(schemaDir, JBI_DESCRIPTOR_SCHEMA);
        }
        catch (Exception ex) {
            String exMsg = ex.getMessage();
            if (this.mMsgBuilder != null) {
                exMsg = this.mMsgBuilder.buildExceptionMessage("ArchiveHelper<init>", ex);
            }
            throw new JBIException(exMsg);
        }
    }

    public Jbi loadJbiXml(File archiveFile, boolean validate) throws JBIException {
        this.archiveExistenceCheck(archiveFile);
        ZipFile zip = null;
        try {
            zip = new ZipFile(archiveFile);
            ZipEntry jbiXmlEntry = zip.getEntry(JBI_XML_PATH);
            if (jbiXmlEntry == null) {
                Object[] params = new String[]{archiveFile.getAbsolutePath(), JBI_XML_PATH};
                String errMsg = this.mTranslator.getString("JBI_ADMIN_NO_DESCRIPTOR_IN_ARCHIVE", params);
                String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("loadJbiXml", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
                throw new JBIException(jbiMsg);
            }
            if (validate) {
                this.mReader.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.mDescSchema));
            }
            this.mJbiXml = this.loadJbiXml(archiveFile.getName(), zip.getInputStream(jbiXmlEntry));
        }
        catch (IOException ex) {
            String exMsg = this.mMsgBuilder.buildExceptionMessage("loadJbiXml", ex);
            throw new JBIException(exMsg);
        }
        catch (SAXException ex) {
            String exMsg = this.mMsgBuilder.buildExceptionMessage("loadJbiXml", ex);
            throw new JBIException(exMsg);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioex) {
                    String exMsg = this.mMsgBuilder.buildExceptionMessage("loadJbiXml", ioex);
                    throw new JBIException(exMsg);
                }
            }
        }
        return this.mJbiXml;
    }

    private Jbi loadJbiXml(String entryName, InputStream jbiXmlStream) throws JBIException {
        Jbi jbiXml;
        try {
            jbiXml = (Jbi)this.mReader.unmarshal(jbiXmlStream);
        }
        catch (JAXBException jEx) {
            String message;
            String string = message = jEx.getLinkedException() != null ? jEx.getLinkedException().getMessage() : jEx.getMessage();
            if (message == null) {
                message = jEx.toString();
            }
            Object[] params = new String[]{entryName, message};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_ARCHIVE_DESCRIPTOR_NOT_SCHEMA_VALID", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("loadJbiXml", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        return jbiXml;
    }

    private void archiveExistenceCheck(File archiveFile) throws JBIException {
        if (!archiveFile.exists()) {
            Object[] params = new String[]{archiveFile.getAbsolutePath()};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_ARCHIVE_NONEXISTENT", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("loadJbiXml", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
        if (archiveFile.length() == 0L) {
            Object[] params = new String[]{archiveFile.getAbsolutePath()};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_ARCHIVE_EMPTY", params);
            String jbiMsg = this.mMsgBuilder.buildFrameworkMessage("loadJbiXml", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new JBIException(jbiMsg);
        }
    }
}

