/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipEntry;

public class InputJarArchive
extends AbstractArchive {
    protected JarFile jarFile = null;
    protected JarInputStream jarIS = null;
    private String archiveUri;
    private InputJarArchive parentArchive = null;
    private StringManager localStrings = StringManager.getManager(this.getClass());

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.getArchiveUri() == null) {
            return -1L;
        }
        File tmpFile = new File(this.getArchiveUri());
        return tmpFile.length();
    }

    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
            this.jarIS = null;
        }
    }

    public void create(String path) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public Enumeration entries() {
        Vector<String> entries = new Vector<String>();
        if (this.parentArchive != null) {
            try {
                JarEntry ze;
                this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.archiveUri)));
                do {
                    if ((ze = this.jarIS.getNextJarEntry()) == null || ze.isDirectory()) continue;
                    entries.add(ze.getName());
                } while (ze != null);
                this.jarIS.close();
                this.jarIS = null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        try {
            if (this.jarFile == null) {
                this.getJarFile(this.archiveUri);
            }
        }
        catch (IOException ioe) {
            return entries.elements();
        }
        if (this.jarFile == null) {
            return entries.elements();
        }
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (ze.isDirectory() || ze.getName().equals("META-INF/MANIFEST.MF")) continue;
            entries.add(ze.getName());
        }
        return entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public InputStream getEntry(String entryName) throws IOException {
        if (this.jarFile != null) {
            ZipEntry ze = this.jarFile.getEntry(entryName);
            if (ze != null) {
                return new BufferedInputStream(this.jarFile.getInputStream(ze));
            }
            return null;
        }
        if (this.parentArchive != null && this.parentArchive.jarFile != null) {
            JarEntry je;
            JarEntry archiveJarEntry;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            JarEntry jarEntry = archiveJarEntry = this.archiveUri != null ? this.parentArchive.jarFile.getJarEntry(this.archiveUri) : null;
            if (archiveJarEntry == null) {
                return null;
            }
            this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
            while ((je = this.jarIS.getNextJarEntry()) != null && !je.getName().equals(entryName)) {
            }
            if (je != null) {
                return new BufferedInputStream(this.jarIS);
            }
            return null;
        }
        return null;
    }

    public void open(String path) throws IOException {
        this.archiveUri = path;
        this.jarFile = this.getJarFile(path);
    }

    protected JarFile getJarFile(String path) throws IOException {
        this.jarFile = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                this.jarFile = new JarFile(file);
            }
        }
        catch (IOException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.fileOpenFailure", new Object[]{path});
            String additionalInfo = this.localStrings.getString("enterprise.deployment.invalid_zip_file", path);
            IOException ioe = new IOException(e.getLocalizedMessage() + " --  " + additionalInfo);
            ioe.initCause(e);
            throw ioe;
        }
        return this.jarFile;
    }

    public Manifest getManifest() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile.getManifest();
        }
        if (this.parentArchive != null) {
            InputStream is;
            Manifest m;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            if (this.jarIS == null) {
                this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.archiveUri)));
            }
            if ((m = this.jarIS.getManifest()) == null && (is = this.getEntry("META-INF/MANIFEST.MF")) != null) {
                m = new Manifest();
                m.read(is);
                is.close();
            }
            return m;
        }
        return null;
    }

    public boolean exists() {
        return this.jarFile != null;
    }

    public boolean delete() {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.deleteFile(new File(this.archiveUri));
    }

    public boolean renameTo(String name) {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.renameFile(new File(this.archiveUri), new File(name));
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        if (this.jarFile != null) {
            InputJarArchive ija = new InputJarArchive();
            JarEntry je = this.jarFile.getJarEntry(name);
            if (je != null) {
                JarInputStream jis = new JarInputStream(new BufferedInputStream(this.jarFile.getInputStream(je)));
                ija.archiveUri = name;
                ija.jarIS = jis;
                ija.parentArchive = this;
                return ija;
            }
        }
        return null;
    }

    public void closeEntry(AbstractArchive os) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void closeEntry() {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public URI getURI() {
        try {
            return ArchiveFactory.prepareArchiveURI(this.getArchiveUri());
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public OutputStream putNextEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }
}

