/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.management.monitor.CallFlowMonitorImpl;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.LoaderBase;
import com.sun.enterprise.management.support.NonDASLoaderMBean;
import java.util.logging.Level;
import javax.management.ObjectName;

public final class NonDASLoader
extends LoaderBase
implements NonDASLoaderMBean {
    public NonDASLoader() {
        this.debug((Object)"NonDASLoader");
    }

    protected void startHook() {
        this.debug((Object)"startHook");
    }

    protected Object createDomainRoot() {
        this.debug((Object)"createDomainRoot");
        return null;
    }

    public boolean isDAS() {
        return false;
    }

    private void loadCallFlowMonitor() {
        try {
            CallFlowMonitorImpl callFlow = new CallFlowMonitorImpl();
            String serverName = BootUtil.getInstance().getServerName();
            String props = Util.makeRequiredProps("X-CallFlowMonitor", serverName);
            props = Util.concatenateProps(props, Util.makeProp("X-ServerRootMonitor", serverName));
            ObjectName proposedName = Util.newObjectName(BootUtil.getInstance().getAMXJMXDomainName(), props);
            ObjectName objectName = this.getMBeanServer().registerMBean(callFlow, proposedName).getObjectName();
            this.debug((Object)("Loaded CallFlowMonitor as " + JMXUtil.toString(objectName)));
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            String msg = "Exception creating/loading CallFlowMonitor: " + rootCause + ", msg=" + rootCause.getMessage();
            this.debug((Object)msg);
            this.getMBeanLogger().log(Level.WARNING, msg, rootCause);
        }
    }

    private void loadSpecialtyMBeans() {
        this.debug((Object)"loadSpecialtyMBeans");
        this.loadCallFlowMonitor();
    }

    public void adminServiceReady() {
        this.debug((Object)"adminServiceReady");
        this.loadSpecialtyMBeans();
    }

    public void waitAll() {
    }
}

