/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AMXLoggerBase;
import com.sun.appserv.management.base.Util;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.TypeInfos;
import java.util.HashMap;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.ObjectName;

public final class AMXMBeanLogger
extends AMXLoggerBase {
    private final ObjectName mObjectName;
    private static final String TYPE_NAME_DELIM = ":";
    public static final String OBJECT_NAME_KEY = "ObjectName";

    private static String mangle(String s) {
        return s.replaceAll("\\.", "_");
    }

    private static String formTypeName(String j2eeType, String name) {
        String result = null;
        if (j2eeType == null) {
            result = name;
        } else {
            String pair = AMXMBeanLogger.mangle(j2eeType);
            if (!name.equals(ObjectNames.getSingletonName(j2eeType))) {
                pair = pair + TYPE_NAME_DELIM + AMXMBeanLogger.mangle(name);
            }
            result = pair;
        }
        return result;
    }

    private static String createLoggerName(ObjectName objectName) {
        String j2eeType = Util.getJ2EEType(objectName);
        String name = Util.getName(objectName);
        TypeInfos infos = TypeInfos.getInstance();
        StringBuffer buf = new StringBuffer();
        buf.append("javax.enterprise.system.tools.admin.server.mbeans");
        buf.append("." + AMXMBeanLogger.formTypeName(j2eeType, name));
        String[] typeChain = infos.getJ2EETypeChain(objectName);
        for (int i = 0; i < typeChain.length - 1; ++i) {
            String type = typeChain[i];
            String value = objectName.getKeyProperty(type);
            if (value == null) {
                value = "na";
            }
            buf.append("." + AMXMBeanLogger.formTypeName(type, value));
        }
        return buf.toString();
    }

    private AMXMBeanLogger(ObjectName objectName) {
        this(objectName, null);
        throw new IllegalArgumentException();
    }

    private AMXMBeanLogger(ObjectName objectName, String resourceBundleName) {
        super(AMXMBeanLogger.createLoggerName(objectName), resourceBundleName);
        this.mObjectName = objectName;
        throw new IllegalArgumentException();
    }

    public static Logger createNew(ObjectName objectName) {
        String loggerName = AMXMBeanLogger.createLoggerName(objectName);
        return Logger.getLogger(loggerName);
    }

    public void log(LogRecord record) {
        Object[] existing = record.getParameters();
        int numExisting = existing == null ? 0 : existing.length;
        Object[] params = new Object[1 + numExisting];
        if (existing != null) {
            System.arraycopy(existing, 0, params, 0, existing.length);
        }
        HashMap<String, ObjectName> m = new HashMap<String, ObjectName>();
        m.put(OBJECT_NAME_KEY, this.mObjectName);
        params[params.length - 1] = m;
        record.setParameters(params);
        super.log(record);
    }
}

