/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.NameListMgr;
import com.sun.enterprise.config.serverbeans.validation.ReportHelper;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.XPathHelper;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Logger;

public class AttrType {
    String name;
    String type;
    boolean optional = false;
    Hashtable _specRules;
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.verifier");

    public AttrType(String name, String type, boolean optional) {
        this.name = name;
        this.type = type;
        this.optional = optional;
        this._specRules = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean getOptional() {
        return this.optional;
    }

    void addRuleValue(String ruleName, Object ruleValue) {
        if (ruleValue != null) {
            this._specRules.put(ruleName, ruleValue);
        }
    }

    Object getRuleValue(String ruleName) {
        return this._specRules.get(ruleName);
    }

    public void validate(Object value, ValidationContext valCtx) {
        if (!this.optional && null == value) {
            this.reportAttributeError(valCtx, "nullValueForMandatoryAttribute", "Attribute ''{0}'' is mandatory. A null value is not allowed", new Object[]{this.name});
        }
        this.validateKeyChanges(value, valCtx);
        this.validateUniqueness(value, valCtx);
        this.validateReferences(value, valCtx);
    }

    private void validateKeyChanges(Object value, ValidationContext valCtx) {
        String key = valCtx.getPrimaryKeyName();
        if (key == null || !key.equals(this.name)) {
            return;
        }
        if (valCtx.isUPDATE()) {
            if (this.name.equals(valCtx.name)) {
                this.reportAttributeError(valCtx, "primarykeychangeattempt", "Cannot change a primary key", new Object[]{valCtx.name});
            }
        } else if (valCtx.isSET() || valCtx.isADD() || valCtx.isVALIDATE()) {
            if (valCtx.classObject instanceof ConfigBean && valCtx.value instanceof ConfigBean && !this.isAttrValueUniqueAmongSiblings((ConfigBean)valCtx.classObject, (ConfigBean)valCtx.value, key, null)) {
                this.reportAttributeError(valCtx, "keyDuplication", "Element with the same attribute value ({0} = {1}) already exists.", new Object[]{key, value});
            }
        } else if (valCtx.isDELETE()) {
            return;
        }
    }

    private void validateUniqueness(Object value, ValidationContext valCtx) {
        String[] belongsTo = (String[])this.getRuleValue("belongs-to");
        if (belongsTo == null || belongsTo.length == 0) {
            return;
        }
        NameListMgr nameListMgr = valCtx.getNameListMgr();
        if (nameListMgr == null) {
            return;
        }
        String xpathForValue = this.getFutureXPathForValidatingAttribute(valCtx);
        String[] valuesToTest = ((String)value).split(",");
        for (int i = 0; i < belongsTo.length; ++i) {
            if (belongsTo[i] == null) continue;
            for (int j = 0; j < valuesToTest.length; ++j) {
                if (valCtx.isDELETE()) {
                    if (!nameListMgr.isValueInNameDomainReferenced(belongsTo[i], valuesToTest[j], xpathForValue)) continue;
                    String elementPrintName = GenericValidator.getConfigElementPrintName(valCtx, xpathForValue, true, true);
                    String refXPath = nameListMgr.getDomainValueReferenceeXPath(belongsTo[i], valuesToTest[j], xpathForValue);
                    String refPrintName = GenericValidator.getConfigElementPrintName(valCtx, refXPath, true, true);
                    this.reportAttributeError(valCtx, "isReferenced", "Element {0} can not be deleted because it is referenced from {1}", new Object[]{elementPrintName, refPrintName});
                    continue;
                }
                if (nameListMgr.isUniqueValueInNameDomain(belongsTo[i], valuesToTest[j], xpathForValue)) continue;
                this.reportAttributeError(valCtx, "notUniqueInList", "Attribute value ({0} = {1}) is not unique in {2}.", new Object[]{this.name, valuesToTest[j], nameListMgr.getDescriptionForNameDomain(belongsTo[i])});
            }
        }
    }

    private void validateReferences(Object value, ValidationContext valCtx) {
        String[] referencesTo = (String[])this.getRuleValue("references-to");
        if (referencesTo == null || referencesTo.length == 0 || value == null) {
            return;
        }
        NameListMgr nameListMgr = valCtx.getNameListMgr();
        if (nameListMgr == null) {
            return;
        }
        if (valCtx.isDELETE()) {
            return;
        }
        String xpathForValue = this.getFutureXPathForValidatingAttribute(valCtx);
        String[] valuesToTest = ((String)value).split(",");
        for (int i = 0; i < referencesTo.length; ++i) {
            if (referencesTo[i] == null) continue;
            for (int j = 0; j < valuesToTest.length; ++j) {
                if (nameListMgr.isValueInNameDomain(referencesTo[i], valuesToTest[j], xpathForValue)) continue;
                this.reportAttributeError(valCtx, "notFoundInList", "Attribute value ({0} = {1}) is not found in {2}.", new Object[]{this.name, valuesToTest[j], nameListMgr.getDescriptionForNameDomain(referencesTo[i])});
            }
        }
    }

    private boolean isAttrValueUniqueAmongSiblings(ConfigBean parent, ConfigBean cb, String attrName, String newValue) {
        String value;
        if (parent == null || cb == null) {
            return true;
        }
        ConfigBean[] cbs = parent.getChildBeansByName(cb.name());
        String string = value = newValue != null ? newValue : cb.getAttributeValue(attrName);
        if (cbs == null) {
            return true;
        }
        for (int i = 0; i < cbs.length; ++i) {
            if (cbs[i] == cb || !value.equals(cbs[i].getAttributeValue(attrName))) continue;
            return false;
        }
        return true;
    }

    public ConfigBean[] getAllSiblingsForConfigBean(ConfigBean cb) {
        ConfigBean parent = (ConfigBean)cb.parent();
        if (parent == null) {
            return new ConfigBean[]{cb};
        }
        return parent.getChildBeansByName(cb.name());
    }

    private String[] getAttrValuesFromSiblings(ConfigBean cb, String attrName, boolean bIncludingThis) {
        ConfigBean[] cbs = this.getAllSiblingsForConfigBean(cb);
        if (cbs == null) {
            return new String[0];
        }
        int iStrsLen = cbs.length;
        if (!bIncludingThis) {
            --iStrsLen;
        }
        if (iStrsLen <= 0) {
            return new String[0];
        }
        String[] strs = new String[iStrsLen];
        int iStr = 0;
        for (int i = 0; i < cbs.length; ++i) {
            if (!bIncludingThis && cbs[i] == cb) continue;
            strs[iStr++] = cbs[i].getAttributeValue(attrName);
        }
        return strs;
    }

    protected String getFutureXPathForValidatingAttribute(ValidationContext valCtx) {
        if (valCtx.isSET() || valCtx.isADD() || valCtx.isVALIDATE()) {
            String[] tokens = XPathHelper.extractTokens(((ConfigBean)valCtx.value).getAbsoluteXPath(""));
            if (valCtx.classObject == null) {
                return "/" + tokens[tokens.length - 1] + "/@" + this.name;
            }
            return ((ConfigBean)valCtx.classObject).getXPath() + "/" + tokens[tokens.length - 1] + "/@" + this.name;
        }
        if (valCtx.isUPDATE()) {
            return ((ConfigBean)valCtx.classObject).getXPath() + "/@" + this.name;
        }
        if (valCtx.isDELETE() && valCtx.value instanceof ConfigBean) {
            return ((ConfigBean)valCtx.value).getXPath() + "/@" + this.name;
        }
        return null;
    }

    protected String getValueForAttribute(String attrName, ValidationContext valCtx) {
        if (attrName == null || valCtx.getTargetBean() == null) {
            return null;
        }
        if (attrName.startsWith("@")) {
            attrName = attrName.substring(1);
        }
        return valCtx.getTargetBean().getAttributeValue(attrName);
    }

    protected void reportAttributeError(ValidationContext valCtx, String msgNameSuffix, String defaultMsg, Object[] values) {
        ReportHelper.reportAttributeError(valCtx, msgNameSuffix, defaultMsg, values);
    }
}

