/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.server.core.jmx.auth.ASJMXAuthenticator;
import com.sun.enterprise.admin.server.core.jmx.auth.ASLoginDriverImpl;
import com.sun.enterprise.admin.server.core.jmx.auth.LoginDriver;
import com.sun.enterprise.admin.servermgmt.FileValidator;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.MasterPasswordFileManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryNameValidator;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEInstancesManager;
import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.security.RealmConfig;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;

public class RepositoryManager
extends MasterPasswordFileManager {
    protected static final String CERTUTIL_CMD = System.getProperty("com.sun.aas.nssBin") + "/certutil";
    protected static final String NEW_LINE = System.getProperty("line.separator");
    private static final StringManager _strMgr = StringManager.getManager(RepositoryManager.class);
    private ConfigContext _configContext = null;
    protected RepositoryManagerMessages _messages = null;
    public static final String DEBUG = "Debug";

    public RepositoryManager() {
        this.setMessages(new RepositoryManagerMessages(StringManager.getManager(PEDomainsManager.class), "illegalDomainName", "domainName", "domainsRoot", "domainExists", "domainDoesntExist", "domainDirNotValid", "cannotDeleteDomainDir", "invalidDomainDir", "listDomainElement", "cannotDeleteInstance_invalidState", "instanceStartupException", "cannotStartInstance_invalidState", "startInstanceTimeOut", "portConflict", "startupFailed", "cannotStopInstance_invalidState", "cannotStopInstance", "timeoutStarting"));
    }

    protected void setMessages(RepositoryManagerMessages messages) {
        this._messages = messages;
    }

    protected RepositoryManagerMessages getMessages() {
        return this._messages;
    }

    protected void generateFromTemplate(TokenValueSet tokens, File template, File destinationFile) throws IOException {
        LineTokenReplacer replacer = new LineTokenReplacer(tokens, "UTF-8");
        replacer.replace(template, destinationFile);
    }

    protected boolean repositoryExists(RepositoryConfig config) {
        return FileUtils.safeGetCanonicalFile(this.getRepositoryDir(config)).exists();
    }

    protected boolean isValidRepository(File f) {
        return new File(new File(f, "bin"), PEFileLayout.START_SERV_OS).exists();
    }

    protected boolean isValidRepository(RepositoryConfig config) {
        return this.getFileLayout(config).getStartServ().exists();
    }

    protected File getRepositoryDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryDir();
    }

    protected File getRepositoryRootDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryRootDir();
    }

    protected void checkRepository(RepositoryConfig config) throws RepositoryException {
        this.checkRepository(config, true, true);
    }

    public void checkRepository(RepositoryConfig config, boolean existingRepository) throws RepositoryException {
        this.checkRepository(config, existingRepository, true);
    }

    public void checkRepository(RepositoryConfig config, boolean existingRepository, boolean checkRootDir) throws RepositoryException {
        String repositoryName = config.getDisplayName();
        new RepositoryNameValidator(this.getMessages().getRepositoryNameMessage()).validate(repositoryName);
        if (checkRootDir || existingRepository) {
            new FileValidator(this.getMessages().getRepositoryRootMessage(), "drw").validate(config.getRepositoryRoot());
        }
        new FileValidator(_strMgr.getString("installRoot"), "dr").validate(config.getInstallRoot());
        if (existingRepository) {
            if (!this.repositoryExists(config)) {
                if (Boolean.getBoolean(DEBUG)) {
                    throw new RepositoryException(this.getMessages().getNoExistsMessage(repositoryName, this.getBigNoExistsMessage(config)));
                }
                throw new RepositoryException(this.getMessages().getNoExistsMessage(repositoryName, this.getRepositoryDir(config).getAbsolutePath()));
            }
            if (!this.isValidRepository(config)) {
                throw new RepositoryException(this.getMessages().getRepositoryNotValidMessage(this.getRepositoryDir(config).getAbsolutePath()));
            }
        } else if (this.repositoryExists(config)) {
            throw new RepositoryException(this.getMessages().getExistsMessage(repositoryName, this.getRepositoryRootDir(config).getAbsolutePath()));
        }
    }

    private String getBigNoExistsMessage(RepositoryConfig config) {
        File repdir = this.getRepositoryDir(config);
        File canrepdir = FileUtils.safeGetCanonicalFile(repdir);
        File canrepdirparent = canrepdir.getParentFile();
        String s = "";
        s = s + "\nRep. Dir:" + repdir;
        s = s + "\nDump of RepositoryConfig: " + config.toString();
        s = s + "\nCanonical File: " + canrepdir;
        s = s + "\nParent File: " + canrepdirparent;
        boolean regex = repdir.exists();
        boolean canex = canrepdir.exists();
        boolean parentex = canrepdirparent.exists();
        boolean regdir = repdir.isDirectory();
        boolean candir = canrepdir.isDirectory();
        boolean parentdir = canrepdirparent.isDirectory();
        s = s + "\nrepdir exists: " + regex + ", canon exists: " + canex + ", parent exists: " + parentex + ", reg is dir: " + regdir + ", canon isdir: " + candir + ", parent is dir: " + parentdir;
        s = s + "\nInstance root sys property (";
        s = s + "com.sun.aas.instanceRoot";
        s = s + "): ";
        s = s + System.getProperty("com.sun.aas.instanceRoot");
        return s;
    }

    protected void setPermissions(RepositoryConfig repositoryConfig) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(repositoryConfig);
        File domainDir = layout.getRepositoryDir();
        try {
            this.chmod("-R 755", domainDir);
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("setPermissionError"), e);
        }
    }

    protected void deleteRepository(RepositoryConfig config) throws RepositoryException {
        this.deleteRepository(config, true);
    }

    protected void deleteRepository(RepositoryConfig config, boolean deleteJMSProvider) throws RepositoryException {
        this.checkRepository(config, true);
        int status2 = this.getInstancesManager(config).getInstanceStatus();
        if (status2 != 3) {
            throw new RepositoryException(this.getMessages().getCannotDeleteInstanceInvalidState(config.getDisplayName(), Status.getStatusString(status2)));
        }
        if (deleteJMSProvider) {
            this.deleteJMSProviderInstance(config);
        }
        File repository = this.getRepositoryDir(config);
        try {
            FileUtils.liquidate(repository);
        }
        catch (Exception e) {
            throw new RepositoryException(this.getMessages().getCannotDeleteMessage(repository.getAbsolutePath()), e);
        }
        if (this.repositoryExists(config)) {
            throw new RepositoryException(this.getMessages().getCannotDeleteMessage(repository.getAbsolutePath()));
        }
    }

    protected String[] listRepository(RepositoryConfig config) throws RepositoryException {
        File repository = this.getRepositoryRootDir(config);
        String[] dirs = new String[]{};
        try {
            File f = repository.getCanonicalFile();
            if (!f.isDirectory()) {
                throw new RepositoryException(this.getMessages().getInvalidPathMessage(f.getAbsolutePath()));
            }
            dirs = f.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    if (!f.isDirectory()) {
                        return false;
                    }
                    return RepositoryManager.this.isValidRepository(f);
                }
            });
            if (dirs == null) {
                dirs = new String[]{};
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return dirs;
    }

    public InstancesManager getInstancesManager(RepositoryConfig config) {
        return new PEInstancesManager(config);
    }

    protected String[] listDomainsAndStatusAsString(RepositoryConfig config) throws RepositoryException {
        try {
            RuntimeStatusList statusList = this.getRuntimeStatus(config);
            RuntimeStatus status2 = null;
            String[] result = new String[statusList.size()];
            for (int i = 0; i < statusList.size(); ++i) {
                status2 = statusList.getStatus(i);
                result[i] = this.getMessages().getListRepositoryElementMessage(status2.getName(), status2.toShortString());
            }
            return result;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    protected RepositoryConfig getConfigForRepositoryStatus(RepositoryConfig config, String repository) {
        return new RepositoryConfig(repository, config.getRepositoryRoot());
    }

    public RuntimeStatusList getRuntimeStatus(RepositoryConfig config) throws RepositoryException {
        String[] repositories = this.listRepository(config);
        RuntimeStatusList result = new RuntimeStatusList(repositories.length);
        for (int i = 0; i < repositories.length; ++i) {
            InstancesManager mgr = this.getInstancesManager(this.getConfigForRepositoryStatus(config, repositories[i]));
            result.add(RuntimeStatus.getRuntimeStatus(repositories[i], mgr));
        }
        return result;
    }

    protected void createAdminKeyFile(RepositoryConfig config, String user, String clearPwd) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getKeyFileTemplate();
        File dest = layout.getAdminKeyFile();
        try {
            FileUtils.copy(src, dest);
            this.modifyKeyFile(dest, user, clearPwd);
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("keyFileNotCreated"), e);
        }
    }

    protected void createKeyFile(RepositoryConfig config, String user, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getKeyFileTemplate();
        File dest = layout.getKeyFile();
        try {
            FileUtils.copy(src, dest);
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("keyFileNotCreated"), e);
        }
    }

    private void modifyKeyFile(File keyFile, String user, String password) throws IOException, BadRealmException, IASSecurityException, NoSuchRealmException {
        String keyFilePath = keyFile.getAbsolutePath();
        FileRealm fileRealm = new FileRealm(keyFilePath);
        String[] group = new String[]{"asadmin"};
        fileRealm.addUser(user, password, group);
        fileRealm.writeKeyFile(keyFilePath);
        this.appendKeyFileComment(keyFilePath);
    }

    private void appendKeyFileComment(String fileName) {
        String commentLine = NEW_LINE + _strMgr.getString("adminUserComment");
        FileUtils.appendText(fileName, commentLine);
    }

    protected void createServerPolicyFile(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getPolicyFileTemplate();
        File dest = layout.getPolicyFile();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("serverPolicyNotCreated"), ioe);
        }
    }

    public void validateMasterPassword(RepositoryConfig config, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
        }
        catch (IOException ex) {
            throw new RepositoryException(_strMgr.getString("masterPasswordInvalid"));
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("couldNotValidateMasterPassword", (Object)passwordAliases), ex);
        }
    }

    public String getClearPasswordForAlias(RepositoryConfig config, String password, String alias) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
            String clearPwd = p.getPasswordForAlias(alias);
            return clearPwd;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void validateAdminUserAndPassword(RepositoryConfig config, String user, String password) throws RepositoryException {
        try {
            PEFileLayout layout = this.getFileLayout(config);
            ConfigContext configContext = this.getConfigContext(config);
            String dasName = ServerHelper.getDAS((ConfigContext)configContext).getName();
            JmxConnector conn = ServerHelper.getServerSystemConnector((ConfigContext)configContext, (String)dasName);
            String realmName = conn.getAuthRealmName();
            SecurityService security = ServerHelper.getConfigForServer((ConfigContext)configContext, (String)dasName).getSecurityService();
            String oldRoot = System.getProperty("com.sun.aas.instanceRoot");
            String oldConf = System.getProperty("java.security.auth.login.config");
            System.setProperty("com.sun.aas.instanceRoot", layout.getRepositoryDir().getAbsolutePath());
            System.setProperty("java.security.auth.login.config", layout.getLoginConf().getAbsolutePath());
            RealmConfig.createRealms((String)realmName, (AuthRealm[])new AuthRealm[]{security.getAuthRealmByName(realmName)});
            if (oldRoot != null) {
                System.setProperty("com.sun.aas.instanceRoot", oldRoot);
            }
            if (oldConf != null) {
                System.setProperty("java.security.auth.login.config", oldConf);
            }
            ASJMXAuthenticator authenticator = new ASJMXAuthenticator();
            authenticator.setRealmName(realmName);
            authenticator.setLoginDriver((LoginDriver)new ASLoginDriverImpl());
            authenticator.authenticate((Object)new String[]{user, password});
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("couldNotValidateMasterPassword", (Object)user), ex);
        }
    }

    protected void createPasswordAliasKeystore(RepositoryConfig config, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
            p.writeStore();
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("passwordAliasKeystoreNotCreated", (Object)passwordAliases), ex);
        }
    }

    protected void changePasswordAliasKeystorePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        if (passwordAliases.exists()) {
            try {
                PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), oldPassword.toCharArray());
                p.changePassword(newPassword.toCharArray());
            }
            catch (Exception ex) {
                throw new RepositoryException(_strMgr.getString("passwordAliasPasswordNotChanged", (Object)passwordAliases), ex);
            }
        }
    }

    protected void createJBIInstance(String instanceName, RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        layout.createJBIDirectories();
        TokenValueSet tvSet = new TokenValueSet();
        String tvDelimiter = "@";
        String tJbiInstanceName = "JBI_INSTANCE_NAME";
        String tJbiInstanceRoot = "JBI_INSTANCE_ROOT";
        try {
            TokenValue tvJbiInstanceName = new TokenValue("JBI_INSTANCE_NAME", instanceName, "@");
            TokenValue tvJbiInstanceRoot = new TokenValue("JBI_INSTANCE_ROOT", layout.getRepositoryDir().getCanonicalPath(), "@");
            tvSet.add(tvJbiInstanceName);
            tvSet.add(tvJbiInstanceRoot);
            File src = layout.getJbiTemplateFile();
            File dest = layout.getJbiRegistryFile();
            this.generateFromTemplate(tvSet, src, dest);
            File httpConfigSrc = layout.getHttpBcConfigTemplate();
            File httpConfigDest = layout.getHttpBcConfigFile();
            TokenValueSet httpTvSet = new TokenValueSet();
            this.generateFromTemplate(httpTvSet, httpConfigSrc, httpConfigDest);
            this.createHttpBCInstallRoot(layout);
            this.createJavaEESEInstallRoot(layout);
            this.createWSDLSLInstallRoot(layout);
        }
        catch (Exception ioe) {
            throw new RepositoryException(_strMgr.getString("jbiRegistryFileNotCreated"), ioe);
        }
    }

    public void createHttpBCInstallRoot(PEFileLayout layout) throws Exception {
        FileUtils.copy(layout.getHttpBcArchiveSource(), layout.getHttpBcArchiveDestination());
        ZipFile zf = new ZipFile(layout.getHttpBcArchiveSource(), layout.getHttpBcInstallRoot());
        ArrayList list = zf.explode();
    }

    public void createJavaEESEInstallRoot(PEFileLayout layout) throws Exception {
        FileUtils.copy(layout.getJavaEESEArchiveSource(), layout.getJavaEESEArchiveDestination());
        ZipFile zf = new ZipFile(layout.getJavaEESEArchiveSource(), layout.getJavaEESEInstallRoot());
        ArrayList list = zf.explode();
    }

    public void createWSDLSLInstallRoot(PEFileLayout layout) throws Exception {
        FileUtils.copy(layout.getWSDLSLArchiveSource(), layout.getWSDLSLArchiveDestination());
        ZipFile zf = new ZipFile(layout.getWSDLSLArchiveSource(), layout.getWSDLSLInstallRoot());
        ArrayList list = zf.explode();
    }

    protected void createMQInstance(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File broker = layout.getImqBrokerExecutable();
        File mqVarHome = layout.getImqVarHome();
        try {
            mqVarHome.mkdirs();
            ArrayList<String> cmdInput = new ArrayList<String>();
            cmdInput.add(broker.getAbsolutePath());
            cmdInput.add("-init");
            cmdInput.add("-varhome");
            cmdInput.add(mqVarHome.getAbsolutePath());
            ProcessExecutor pe = new ProcessExecutor(cmdInput.toArray(new String[cmdInput.size()]));
            pe.execute(false, false);
        }
        catch (Exception ioe) {
            // empty catch block
        }
    }

    protected void createTimerWal(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTimerWalTemplate();
        File dest = layout.getTimerWal();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("timerWalNotCreated"), ioe);
        }
    }

    protected void createTimerDbn(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTimerDbnTemplate();
        File dest = layout.getTimerDbn();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("timerDbnNotCreated"), ioe);
        }
    }

    protected void handleDerby(RepositoryConfig config) throws RepositoryException {
        String DL = "derby.log";
        File derbyLog = new File("derby.log");
        try {
            PEFileLayout layout = this.getFileLayout(config);
            File derbySqlFile = layout.getDerbyEjbTimerSqlFile();
            String tableStatement = this.formatSqlStatement(derbySqlFile);
            String dbDir = layout.getDerbyEjbTimerDatabaseDirectory().getAbsolutePath();
            this.createEjbTimerDatabaseTable(tableStatement, dbDir);
        }
        catch (Exception ae) {
            String c = this.readDerbyLogFile(derbyLog);
            throw new RepositoryException(_strMgr.getString("derbyEjbTimerDBNotCreated", (Object)c), ae);
        }
        finally {
            if (!derbyLog.delete()) {
                derbyLog.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatSqlStatement(File sqlf) throws Exception {
        String fs;
        int indexOfSemiColon;
        StringBuilder sb = new StringBuilder();
        int SQL_DELIMITER = 59;
        BufferedReader br = new BufferedReader(new FileReader(sqlf));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("\\t", " ");
                sb.append(line);
                if (line.indexOf(59) == -1) continue;
                break;
            }
        }
        finally {
            br.close();
        }
        if ((indexOfSemiColon = (fs = sb.toString()).indexOf(59)) != -1) {
            fs = fs.substring(0, indexOfSemiColon);
        }
        if (Boolean.getBoolean(DEBUG)) {
            System.out.println(fs);
        }
        return fs;
    }

    private void createEjbTimerDatabaseTable(String createStatement, String dbDir) throws Exception {
        this.checkDerbyDriver();
        String url = this.getDatabaseUrl(dbDir);
        Connection conn = DriverManager.getConnection(url);
        this.deleteTable(conn);
        Statement cs = conn.createStatement();
        cs.executeUpdate(createStatement);
    }

    private void deleteTable(Connection conn) {
        try {
            Statement ds = conn.createStatement();
            String deleteTable = "delete table EJB__TIMER__TBL";
            ds.executeUpdate("delete table EJB__TIMER__TBL");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDatabaseUrl(String dbDir) {
        StringBuilder sb = new StringBuilder("jdbc:derby:");
        sb.append(FileUtils.makeForwardSlashes(dbDir));
        sb.append(";create=true");
        return sb.toString();
    }

    private void checkDerbyDriver() throws Exception {
        String DERBY_DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
    }

    private String readDerbyLogFile(File log) {
        StringBuilder sb = new StringBuilder();
        try {
            String s = FileUtils.readSmallFile(log);
            sb.append(s);
        }
        catch (Exception e) {
            String msg = _strMgr.getString("noDerbyLog");
            sb.append(msg);
        }
        return sb.toString();
    }

    protected synchronized void resetConfigContext() {
        this._configContext = null;
    }

    protected synchronized ConfigContext getConfigContext(RepositoryConfig config) throws ConfigException {
        if (this._configContext == null) {
            PEFileLayout layout = this.getFileLayout(config);
            this._configContext = ConfigFactory.createConfigContext((String)layout.getDomainConfigFile().getAbsolutePath());
        }
        return this._configContext;
    }

    protected boolean domainUsesNSS(RepositoryConfig rc) {
        try {
            ConfigContext cc = this.getConfigContext(rc);
            String sn = "server";
            boolean useNSS = ServerHelper.serverUsesNss((ConfigContext)cc, (String)"server");
            return useNSS;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void deleteJMSProviderInstance(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        String repositoryName = config.getRepositoryName();
        try {
            JMSAdmin jmsAdmin = IASJmsUtil.getJMSAdminFactory().getJMSAdmin();
            ConfigContext ctx = this.getConfigContext(config);
            Server[] servers = RepositoryManager.getServers(ctx);
            for (int i = 0; i < servers.length; ++i) {
                String mqInstanceName = IASJmsUtil.getBrokerInstanceName((String)repositoryName, (String)servers[i].getName(), (JmsService)RepositoryManager.getJmsService(servers[i], ctx));
                String javaHome = RepositoryManager.getJavaHome(servers[i], ctx);
                try {
                    String iMQBin = System.getProperty("com.sun.aas.imqBin", layout.getImqBinDir().getAbsolutePath());
                    String iMQInstances = layout.getRepositoryDir() + File.separator + "imq";
                    String[] optArgs = new String[]{"-javahome", javaHome, "-varhome", iMQInstances};
                    jmsAdmin.deleteProviderInstance(iMQBin, optArgs, mqInstanceName);
                    continue;
                }
                catch (JMSException jmse) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("cannotDeleteJmsProviderInstance"), e);
        }
    }

    protected String[] getInteractiveOptions(String user, String password, String masterPassword, HashMap extraPasswords) {
        int numKeys = extraPasswords == null ? 0 : extraPasswords.size();
        String[] options = new String[3 + numKeys];
        options[0] = user;
        options[1] = password;
        options[2] = masterPassword;
        if (extraPasswords != null) {
            Iterator it = extraPasswords.keySet().iterator();
            String key = null;
            for (int i = 0; i < numKeys; ++i) {
                key = (String)it.next();
                options[3 + i] = key + "=" + (String)extraPasswords.get(key);
            }
        }
        return options;
    }

    private static Server[] getServers(ConfigContext ctx) throws ConfigException {
        return ServerHelper.getServersInDomain((ConfigContext)ctx);
    }

    private static String getJavaHome(Server server, ConfigContext ctx) throws ConfigException {
        JavaConfig javaConfig = RepositoryManager.getConfig(server, ctx).getJavaConfig();
        return javaConfig.getJavaHome();
    }

    private static JmsService getJmsService(Server server, ConfigContext ctx) throws ConfigException {
        return RepositoryManager.getConfig(server, ctx).getJmsService();
    }

    private static Config getConfig(Server server, ConfigContext ctx) throws ConfigException {
        return ServerHelper.getConfigForServer((ConfigContext)ctx, (String)server.getName());
    }

    public static boolean isNSSSupportAvailable() {
        File certUtilFile = null;
        certUtilFile = OS.isWindows() ? new File(CERTUTIL_CMD + ".exe") : new File(CERTUTIL_CMD);
        return certUtilFile.exists();
    }

    protected class RepositoryManagerMessages {
        private StringManager _strMgr;
        private String _badNameMessage;
        private String _repositoryNameMessage;
        private String _repositoryRootMessage;
        private String _existsMessage;
        private String _noExistsMessage;
        private String _repositoryNotValidMessage;
        private String _cannotDeleteMessage;
        private String _invalidPathMessage;
        private String _listRepositoryElementMessage;
        private String _cannotDeleteInstance_invalidState;
        private String _instanceStartupExceptionMessage;
        private String _cannotStartInstance_invalidStateMessage;
        private String _startInstanceTimeOutMessage;
        private String _portConflictMessage;
        private String _startupFailedMessage;
        private String _cannotStopInstance_invalidStateMessage;
        private String _cannotStopInstanceMessage;
        private String _timeoutStartingMessage;
        private String _cannotDeleteJmsProviderInstance;

        public RepositoryManagerMessages(StringManager strMgr, String badNameMessage, String repositoryNameMessage, String repositoryRootMessage, String existsMessage, String noExistsMessage, String repositoryNotValidMessage, String cannotDeleteMessage, String invalidPathMessage, String listRepositoryElementMessage, String cannotDeleteInstance_invalidState, String instanceStartupExceptionMessage, String cannotStartInstance_invalidStateMessage, String startInstanceTimeOutMessage, String portConflictMessage, String startupFailedMessage, String cannotStopInstance_invalidStateMessage, String cannotStopInstanceMessage, String timeoutStartingMessage) {
            this._strMgr = strMgr;
            this._badNameMessage = badNameMessage;
            this._repositoryNameMessage = repositoryNameMessage;
            this._repositoryRootMessage = repositoryRootMessage;
            this._existsMessage = existsMessage;
            this._noExistsMessage = noExistsMessage;
            this._repositoryNotValidMessage = repositoryNotValidMessage;
            this._cannotDeleteMessage = cannotDeleteMessage;
            this._invalidPathMessage = invalidPathMessage;
            this._listRepositoryElementMessage = listRepositoryElementMessage;
            this._cannotDeleteInstance_invalidState = cannotDeleteInstance_invalidState;
            this._instanceStartupExceptionMessage = instanceStartupExceptionMessage;
            this._cannotStartInstance_invalidStateMessage = cannotStartInstance_invalidStateMessage;
            this._startInstanceTimeOutMessage = startInstanceTimeOutMessage;
            this._portConflictMessage = portConflictMessage;
            this._startupFailedMessage = startupFailedMessage;
            this._cannotStopInstance_invalidStateMessage = cannotStopInstance_invalidStateMessage;
            this._cannotStopInstanceMessage = cannotStopInstanceMessage;
            this._timeoutStartingMessage = timeoutStartingMessage;
        }

        public String getRepositoryNameMessage() {
            return this._strMgr.getString(this._repositoryNameMessage);
        }

        public String getBadNameMessage(String repositoryName) {
            return this._strMgr.getString(this._badNameMessage, (Object)repositoryName);
        }

        public String getRepositoryRootMessage() {
            return this._strMgr.getString(this._repositoryRootMessage);
        }

        public String getNoExistsMessage(String repositoryName, String repositoryLocation) {
            return this._strMgr.getString(this._noExistsMessage, (Object)repositoryName, (Object)repositoryLocation);
        }

        public String getExistsMessage(String repositoryName, String repositoryLocation) {
            return this._strMgr.getString(this._existsMessage, (Object)repositoryName, (Object)repositoryLocation);
        }

        public String getRepositoryNotValidMessage(String path) {
            return this._strMgr.getString(this._repositoryNotValidMessage, (Object)path);
        }

        public String getCannotDeleteMessage(String repositoryName) {
            return this._strMgr.getString(this._cannotDeleteMessage, (Object)repositoryName);
        }

        public String getInvalidPathMessage(String path) {
            return this._strMgr.getString(this._invalidPathMessage, (Object)path);
        }

        public String getListRepositoryElementMessage(String repositoryName, String repositoryStatus) {
            return this._strMgr.getString(this._listRepositoryElementMessage, (Object)repositoryName, (Object)repositoryStatus);
        }

        public String getCannotDeleteInstanceInvalidState(String name, String state) {
            return this._strMgr.getString(this._cannotDeleteInstance_invalidState, (Object)name, (Object)state);
        }

        public String getInstanceStartupExceptionMessage(String name) {
            return this._strMgr.getString(this._instanceStartupExceptionMessage, (Object)name);
        }

        public String getCannotStartInstanceInvalidStateMessage(String name, String state) {
            return this._strMgr.getString(this._cannotStartInstance_invalidStateMessage, (Object)name, (Object)state);
        }

        public String getStartInstanceTimeOutMessage(String name) {
            return this._strMgr.getString(this._startInstanceTimeOutMessage, (Object)name);
        }

        public String getStartupFailedMessage(String name) {
            return this._strMgr.getString(this._startupFailedMessage, (Object)name);
        }

        public String getStartupFailedMessage(String name, int port) {
            if (port != 0) {
                return this._strMgr.getString(this._portConflictMessage, new Object[]{name, String.valueOf(port)});
            }
            return this._strMgr.getString(this._startupFailedMessage, (Object)name);
        }

        public String getCannotStopInstanceInvalidStateMessage(String name, String state) {
            return this._strMgr.getString(this._cannotStopInstance_invalidStateMessage, (Object)name, (Object)state);
        }

        public String getCannotStopInstanceMessage(String name) {
            return this._strMgr.getString(this._cannotStopInstanceMessage, (Object)name);
        }

        public String getTimeoutStartingMessage(String name) {
            return this._strMgr.getString(this._timeoutStartingMessage, (Object)name);
        }
    }
}

