/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMRuntimeStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMRuntimeStatsImpl
implements JVMRuntimeStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMRuntimeStats";
    private MBeanServer server;
    private MutableCountStatistic upTime;
    private StringStatistic name;
    private RuntimeMXBean bean;
    final long initTime = System.currentTimeMillis();
    private static final StringManager localStrMgr = StringManager.getManager(JVMRuntimeStatsImpl.class);

    public JVMRuntimeStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = ManagementFactory.getRuntimeMXBean();
        this.initializeStatistics();
    }

    public StringStatistic getName() {
        String name = this.bean.getName();
        return new StringStatisticImpl(name, localStrMgr.getString("monitor.stats.name_string"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_vm"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getBootClasspath() {
        String bclasspath = this.bean.getBootClassPath();
        return new StringStatisticImpl(bclasspath, localStrMgr.getString("monitor.stats.boot_class_path_string"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_boot_class_path"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getClassPath() {
        String cpath = this.bean.getClassPath();
        return new StringStatisticImpl(cpath, localStrMgr.getString("monitor.stats.class_path_string"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_class_path"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getInputArguments() {
        ArrayList<String> inputArgs = new ArrayList<String>();
        inputArgs.addAll(this.bean.getInputArguments());
        return new StringStatisticImpl(inputArgs.toString(), localStrMgr.getString("monitor.stats.input_args_string"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_input_args"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getLibraryPath() {
        String libpath = this.bean.getLibraryPath();
        return new StringStatisticImpl(libpath, localStrMgr.getString("monitor.stats.lib_path_string"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_lib_path"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getManagementSpecVersion() {
        String ver = this.bean.getManagementSpecVersion();
        return new StringStatisticImpl(ver, localStrMgr.getString("monitor.stats.lib_mgmt_spec_ver"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_mgmt_spec_ver"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getSpecName() {
        String specname = this.bean.getSpecName();
        return new StringStatisticImpl(specname, localStrMgr.getString("monitor.stats.spec_name"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_spec"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getSpecVendor() {
        String specvendor = this.bean.getSpecVendor();
        return new StringStatisticImpl(specvendor, localStrMgr.getString("monitor.stats.spec_vendor"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_spec_vendor"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getSpecVersion() {
        String specver = this.bean.getSpecVersion();
        return new StringStatisticImpl(specver, localStrMgr.getString("monitor.stats.jvm_spec_vers"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_jvm_spec_vers"), this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getUptime() {
        long u = this.bean.getUptime();
        this.upTime.setCount(u);
        return (CountStatistic)this.upTime.unmodifiableView();
    }

    public StringStatistic getVmName() {
        String vmname = this.bean.getVmName();
        return new StringStatisticImpl(vmname, localStrMgr.getString("monitor.stats.jvm_impl_name"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_jvm_impl"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getVmVendor() {
        String vmvendor = this.bean.getVmVendor();
        return new StringStatisticImpl(vmvendor, localStrMgr.getString("monitor.stats.jvm_vendor"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_jvm_vendor"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getVmVersion() {
        String vmver = this.bean.getVmVersion();
        return new StringStatisticImpl(vmver, localStrMgr.getString("monitor.stats.jvm_vers"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.name_of_jvm_vers"), this.initTime, System.currentTimeMillis());
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.total_compilation_time"), localStrMgr.getString("monitor.stats.milli_sec_units"), localStrMgr.getString("monitor.stats.milli_sec_units_desc"));
        this.upTime = new MutableCountStatisticImpl(c);
    }
}

