/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.StartTimeTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartTimeAccessObjectImpl
extends AbstractTableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static StartTimeAccessObjectImpl _singletonST = new StartTimeAccessObjectImpl();

    private StartTimeAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        this.tableName = "START_TIME_TBL" + serverName.toUpperCase();
        super.setName("StartTime");
    }

    public static synchronized TableAccessObject getInstance() {
        return _singletonST;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] transferObject) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < transferObject.length; ++i) {
                StartTimeTO startTimeTO = (StartTimeTO)transferObject[i];
                pstmt.setString(1, startTimeTO.getRequestId());
                pstmt.setLong(2, startTimeTO.getTimeStamp());
                pstmt.setString(3, startTimeTO.getContainerTypeOrApplicationType());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result = updated.length == transferObject.length;
            this.addTotalEntriesProcessed(updated.length);
            if (super.isTraceOn()) {
                logger.log(Level.INFO, "Callflow: StartTimeAccessObjectImpl  Attempting to Insert : " + transferObject.length + " Inserted " + updated.length + " rows." + " Total Entries written so far: " + this.getTotalEntriesProcessed());
            }
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public boolean dropTable(Connection connection) {
        this.con = connection;
        return super.createStatmentAndExecuteUpdate("drop table START_TIME_TBL", "START_TIME_TBL");
    }

    public boolean createTable(Connection connection) {
        this.con = connection;
        return super.createTable(" create table START_TIME_TBL ( REQUEST_ID VARCHAR(255)  NOT NULL  , TIME_STAMP BIGINT  NOT NULL  , CONT_TYPE_OR_APP_TYPE VARCHAR(20)  NOT NULL  ,  primary key (REQUEST_ID , TIME_STAMP , CONT_TYPE_OR_APP_TYPE))", "START_TIME_TBL");
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(" INSERT INTO START_TIME_TBL VALUES  (  ?, ?, ?   ) ", "START_TIME_TBL");
        return newsql;
    }

    public String getDeleteSQL() {
        String newsql = super.updateSqlWithTableName(" DELETE  FROM START_TIME_TBL WHERE REQUEST_ID =  ? ", "START_TIME_TBL");
        return newsql;
    }
}

