/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.MethodEndTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodEndAccessObjectImpl
extends AbstractTableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static MethodEndAccessObjectImpl _singletonME = new MethodEndAccessObjectImpl();

    private MethodEndAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        this.tableName = "METHOD_END_TBL" + serverName.toUpperCase();
        super.setName("MethodEnd");
    }

    public boolean dropTable(Connection connection) {
        this.con = connection;
        return super.createStatmentAndExecuteUpdate("drop table METHOD_END_TBL", "METHOD_END_TBL");
    }

    public boolean createTable(Connection connection) {
        this.con = connection;
        return super.createTable(" create table METHOD_END_TBL ( REQUEST_ID VARCHAR(255)  NOT NULL  , TIME_STAMP BIGINT  NOT NULL  , EXCEPTION_NAME VARCHAR(4096)  ,  primary key (REQUEST_ID , TIME_STAMP))", "METHOD_END_TBL");
    }

    public static synchronized TableAccessObject getInstance() {
        return _singletonME;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] transferObject) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < transferObject.length; ++i) {
                MethodEndTO methodEndTO = (MethodEndTO)transferObject[i];
                pstmt.setString(1, methodEndTO.getRequestId());
                pstmt.setLong(2, methodEndTO.getTimeStamp());
                pstmt.setString(3, methodEndTO.getException());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result = updated.length == transferObject.length;
            this.addTotalEntriesProcessed(updated.length);
            if (this.isTraceOn()) {
                logger.log(Level.INFO, "Callflow: MethodEndAccessObjectImpl  Attempting to Insert : " + transferObject.length + " Inserted " + updated.length + " rows." + " Total Entries written so far: " + this.getTotalEntriesProcessed());
            }
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(" INSERT INTO METHOD_END_TBL VALUES  (  ?, ?, ?   ) ", "METHOD_END_TBL");
        return newsql;
    }

    public String getDeleteSQL() {
        String newsql = super.updateSqlWithTableName(" DELETE  FROM METHOD_END_TBL WHERE REQUEST_ID =  ? ", "METHOD_END_TBL");
        return newsql;
    }
}

