/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AsyncHandler;
import com.sun.enterprise.admin.monitor.callflow.AsyncHandlerIntf;
import com.sun.enterprise.admin.monitor.callflow.AsyncHandlerProducer;
import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncHandlerFactory {
    private static AsyncHandlerIntf singletonAsyncHandler = null;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static boolean traceOn = false;

    private AsyncHandlerFactory() {
        traceOn = TraceOnHelper.isTraceOn();
    }

    public static synchronized AsyncHandlerIntf getInstance() {
        if (singletonAsyncHandler == null) {
            boolean perfImpl = System.getProperty("com.sun.enterprise.callflow.perf", "true").equals("true");
            if (perfImpl) {
                if (traceOn) {
                    logger.log(Level.INFO, "Callflow: Starting Performant Implementation!. To switch to old implementation Add system property com.sun.enterprise.admin.callflow.perf=false");
                }
                singletonAsyncHandler = AsyncHandlerProducer.getInstance();
            } else {
                if (traceOn) {
                    logger.log(Level.INFO, "Callflow: Starting Old - Non Performant Implementation!");
                }
                singletonAsyncHandler = new AsyncHandler();
            }
        }
        return singletonAsyncHandler;
    }
}

