/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import net.jxta.socket.JxtaSocket;

class JxtaSocketOutputStream
extends OutputStream {
    protected boolean closed = false;
    protected byte[] buf;
    protected int count;
    protected JxtaSocket socket;

    public JxtaSocketOutputStream(JxtaSocket socket, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.socket = socket;
    }

    public synchronized void close() throws IOException {
        this.flushBuffer();
        this.closed = true;
    }

    synchronized void hardClose() {
        this.count = 0;
        this.closed = true;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.socket.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new SocketException("Socket Closed.");
        }
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int left = this.buf.length - this.count;
        if (this.closed) {
            throw new SocketException("Socket Closed.");
        }
        if (len > left) {
            System.arraycopy(b, off, this.buf, this.count, left);
            len -= left;
            off += left;
            this.count += left;
            this.flushBuffer();
        }
        while (len >= this.buf.length) {
            this.socket.write(b, off, this.buf.length);
            len -= this.buf.length;
            off += this.buf.length;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
    }
}

