/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class UnbiasedQueue {
    private static final Logger LOG = Logger.getLogger(UnbiasedQueue.class.getName());
    protected static final int DEFAULT_MAX_OBJECTS = 100;
    protected static final boolean DROP_OLDEST_OBJECT = true;
    protected static final long DROPPED_OBJECT_WARNING_INTERVAL = 10000L;
    protected List<Object> queue = null;
    protected int maxObjects;
    protected volatile boolean closeFlag = false;
    protected boolean dropOldestObject = true;
    protected long numEnqueued = 0L;
    protected long sumOfQueueSizesEnqueue = 0L;
    protected long numDequeued = 0L;
    protected long sumOfQueueSizesDequeue = 0L;
    protected long numDropped = 0L;
    protected long nextDroppedWarn = 0L;

    public static UnbiasedQueue synchronizedQueue(UnbiasedQueue queue) {
        return new SynchronizedQueue(queue);
    }

    public UnbiasedQueue() {
        this(100, true);
    }

    public UnbiasedQueue(int maxsize, boolean dropOldest) {
        this(maxsize, dropOldest, new ArrayList<Object>());
    }

    public UnbiasedQueue(int maxsize, boolean dropOldest, List<Object> queue) {
        if (maxsize <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        if (null == queue) {
            throw new IllegalArgumentException("queue must be non-null");
        }
        this.maxObjects = maxsize;
        this.queue = queue;
        this.closeFlag = false;
        this.dropOldestObject = dropOldest;
    }

    public synchronized String toString() {
        return this.getClass().getName() + " :" + " size=" + this.getCurrentInQueue() + " capacity=" + this.getMaxQueueSize() + " enqueued=" + this.getNumEnqueued() + " avgAtEnqueue=" + this.getAvgInQueueAtEnqueue() + " dequeued=" + this.getNumDequeued() + " avgAtDequeue=" + this.getAvgInQueueAtDequeue();
    }

    public boolean isClosed() {
        return this.closeFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closeFlag = true;
        List<Object> list = this.queue;
        synchronized (list) {
            this.queue.notifyAll();
        }
    }

    public void clear() {
        this.numDropped += (long)this.queue.size();
        this.queue.clear();
    }

    public boolean push(Object obj) {
        if (this.queue.size() >= this.maxObjects) {
            return false;
        }
        ++this.numEnqueued;
        this.sumOfQueueSizesEnqueue += (long)this.queue.size();
        this.queue.add(obj);
        return true;
    }

    public boolean pushBack(Object obj) {
        if (this.queue.size() >= this.maxObjects) {
            return false;
        }
        ++this.numEnqueued;
        this.sumOfQueueSizesEnqueue += (long)this.queue.size();
        this.queue.add(0, obj);
        return true;
    }

    public boolean push(Object obj, long timeout) throws InterruptedException {
        return this.push3(obj, timeout, false);
    }

    public boolean pushBack(Object obj, long timeout) throws InterruptedException {
        return this.push3(obj, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean push3(Object obj, long timeout, boolean atHead) throws InterruptedException {
        if (null == obj) {
            throw new AssertionError((Object)"obj is null");
        }
        if (null == this.queue) {
            throw new AssertionError((Object)"queue is null");
        }
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        List<Object> list = this.queue;
        synchronized (list) {
            do {
                if (this.isClosed()) {
                    this.queue.notify();
                    return false;
                }
                if (this.queue.size() < this.maxObjects) break;
                long waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut);
                if (waitfor > 0L) {
                    this.queue.wait(waitfor);
                    continue;
                }
                if (this.dropOldestObject) {
                    long now = TimeUtils.timeNow();
                    if (now > this.nextDroppedWarn && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("Queue full, dropped one or more elements. Now dropped " + this.numDropped + " elements.");
                        this.nextDroppedWarn = now + 10000L;
                    }
                    if (atHead) {
                        ++this.numEnqueued;
                        ++this.numDropped;
                        this.queue.notify();
                        return true;
                    }
                    while (this.queue.size() >= this.maxObjects) {
                        ++this.numDropped;
                        this.queue.remove(0);
                    }
                } else {
                    this.queue.notify();
                    return false;
                }
            } while (!this.isClosed());
            boolean pushed = atHead ? this.pushBack(obj) : this.push(obj);
            this.queue.notify();
            return pushed;
        }
    }

    public Object peek() {
        Object result = null;
        if (this.queue.isEmpty()) {
            return null;
        }
        result = this.queue.get(0);
        return result;
    }

    public Object pop() {
        Object result = null;
        if (this.queue.isEmpty()) {
            return null;
        }
        this.sumOfQueueSizesDequeue += (long)this.queue.size();
        ++this.numDequeued;
        result = this.queue.remove(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop(long timeout) throws InterruptedException {
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        Object result = null;
        List<Object> list = this.queue;
        synchronized (list) {
            long waitfor;
            while (null == (result = this.pop()) && !this.isClosed() && (waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
                this.queue.wait(waitfor);
                if (!this.isClosed()) continue;
            }
            this.queue.notify();
        }
        return result;
    }

    public Object[] popMulti(int maxObjs) {
        if (maxObjs <= 0) {
            throw new IllegalArgumentException("maxObjs must be > 0");
        }
        maxObjs = Math.min(maxObjs, this.queue.size());
        Object[] result = new Object[maxObjs];
        for (int eachElement = 0; eachElement < maxObjs; ++eachElement) {
            this.sumOfQueueSizesDequeue += (long)this.queue.size();
            ++this.numDequeued;
            result[eachElement] = this.queue.remove(0);
        }
        return result;
    }

    public int getMaxQueueSize() {
        return this.maxObjects;
    }

    public void setMaxQueueSize(int maxObjs) {
        this.maxObjects = maxObjs;
    }

    public int getCurrentInQueue() {
        return this.queue.size();
    }

    public long getNumEnqueued() {
        return this.numEnqueued;
    }

    public double getAvgInQueueAtEnqueue() {
        if (this.numEnqueued > 0L) {
            return (double)this.sumOfQueueSizesEnqueue / (double)this.numEnqueued;
        }
        return Double.NaN;
    }

    public long getNumDequeued() {
        return this.numDequeued;
    }

    public double getAvgInQueueAtDequeue() {
        if (this.numDequeued > 0L) {
            return (double)this.sumOfQueueSizesDequeue / (double)this.numDequeued;
        }
        return Double.NaN;
    }

    public long getNumDropped() {
        return this.numDropped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        List<Object> list = this.queue;
        synchronized (list) {
            this.queue.notify();
        }
    }

    protected static class SynchronizedQueue
    extends UnbiasedQueue {
        UnbiasedQueue innerqueue;

        public SynchronizedQueue(UnbiasedQueue queue) {
            this.innerqueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.isClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                this.innerqueue.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                this.innerqueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean push(Object obj) {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pushBack(Object obj) {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pushBack(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean push(Object obj, long timeout) throws InterruptedException {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.push(obj, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean pushBack(Object obj, long timeout) throws InterruptedException {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pushBack(obj, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object pop() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object pop(long timeout) throws InterruptedException {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.pop(timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] popMulti(int maxObjs) {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.popMulti(maxObjs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getMaxQueueSize() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getMaxQueueSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaxQueueSize(int maxObjs) {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                this.innerqueue.setMaxQueueSize(maxObjs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCurrentInQueue() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getCurrentInQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumEnqueued() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getNumEnqueued();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getAvgInQueueAtEnqueue() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getAvgInQueueAtEnqueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumDequeued() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getNumDequeued();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double getAvgInQueueAtDequeue() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getAvgInQueueAtDequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumDropped() {
            List<Object> list = this.innerqueue.queue;
            synchronized (list) {
                return this.innerqueue.getNumDropped();
            }
        }
    }
}

