/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLElement;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.RouteAdvertisement;

public class ResolverResponse
extends ResolverResponseMsg {
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "jxta:Cred";
    private static final String queryIdTag = "QueryID";
    private static final String responseTag = "Response";
    private RouteAdvertisement srcRoute = null;

    public ResolverResponse() {
    }

    @Deprecated
    public ResolverResponse(String HandlerName, StructuredDocument Credential2, int QueryId, String Response) {
        this.setHandlerName(HandlerName);
        this.setCredential(Credential2);
        this.setQueryId(QueryId);
        this.setResponse(Response);
    }

    public ResolverResponse(Element root) {
        this();
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        if (!ResolverResponse.getAdvertisementType().equals(doctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        this.readIt(doc);
        if (null == this.getHandlerName()) {
            throw new IllegalArgumentException("Response message does not contain a handler name");
        }
        if (null == this.getResponse()) {
            throw new IllegalArgumentException("Response message does not contain a response");
        }
    }

    public void readIt(TextElement doc) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                this.setCredential(StructuredDocumentUtils.copyAsDocument(elem));
                continue;
            }
            if (elem.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(elem.getTextValue());
                continue;
            }
            if (!elem.getName().equals(responseTag)) continue;
            this.setResponse(elem.getTextValue());
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, ResolverResponse.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = adv.createElement(handlernameTag, this.getHandlerName());
        adv.appendChild(e);
        if (this.getCredential() != null) {
            StructuredDocumentUtils.copyElements(adv, adv, this.getCredential());
        }
        e = adv.createElement(queryIdTag, Integer.toString(this.queryid));
        adv.appendChild(e);
        e = adv.createElement(responseTag, this.getResponse());
        adv.appendChild(e);
        return adv;
    }

    public String toString() {
        return this.getDocument(MimeMediaType.XMLUTF8).toString();
    }

    public void setSrcPeerRoute(RouteAdvertisement route) {
        this.srcRoute = route;
    }

    public RouteAdvertisement getSrcPeerRoute() {
        if (this.srcRoute != null) {
            return this.srcRoute.clone();
        }
        return null;
    }
}

