/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.PlainTextDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextElement
implements TextElement<PlainTextElement>,
Attributable {
    protected PlainTextDocument doc;
    protected PlainTextElement parent;
    protected final String name;
    protected final String val;
    private List children = new Vector();
    private Map attributes = new HashMap();

    protected PlainTextElement(PlainTextDocument doc, String name) {
        this(doc, name, null);
    }

    protected PlainTextElement(PlainTextDocument doc, String name, String val) {
        this.doc = doc;
        this.name = name;
        this.val = val;
    }

    public boolean equals(Object element2) {
        if (this == element2) {
            return true;
        }
        if (!(element2 instanceof PlainTextElement)) {
            return false;
        }
        PlainTextElement textElement = (PlainTextElement)element2;
        if (this.doc != textElement.doc) {
            return false;
        }
        if (!this.getName().equals(textElement.getName())) {
            return false;
        }
        String val1 = this.getTextValue();
        String val2 = textElement.getTextValue();
        if (null == val1 && null == val2) {
            return true;
        }
        if (null == val1 || null == val2) {
            return false;
        }
        return val1.equals(val2);
    }

    @Override
    public StructuredTextDocument getRoot() {
        return this.doc;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public String getValue() {
        return this.getTextValue();
    }

    @Override
    public PlainTextElement getParent() {
        return this.parent;
    }

    @Override
    public Enumeration getChildren() {
        return Collections.enumeration(this.children);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTextValue() {
        return this.val;
    }

    @Override
    public void appendChild(PlainTextElement element2) {
        if (element2.doc != this.doc) {
            throw new IllegalArgumentException("Wrong Document");
        }
        element2.parent = this;
        this.children.add(element2);
    }

    @Override
    public Enumeration<PlainTextElement> getChildren(Object key) {
        if (key instanceof String) {
            return this.getChildren((String)key);
        }
        throw new ClassCastException(key.getClass().getName() + " not supported by getChildren.");
    }

    @Override
    public Enumeration<PlainTextElement> getChildren(String name) {
        ArrayList<TextElement> result = new ArrayList<TextElement>();
        for (TextElement aChild : this.children) {
            if (!name.equals(aChild.getName())) continue;
            result.add(aChild);
        }
        return Collections.enumeration(result);
    }

    protected void printNice(Writer into, int indent, boolean recurse) throws IOException {
        for (int eachTab = 0; eachTab < indent; ++eachTab) {
            into.write("\t");
        }
        into.write(this.name);
        Enumeration attributes = this.getAttributes();
        if (attributes.hasMoreElements()) {
            into.write(" ( ");
            while (attributes.hasMoreElements()) {
                Attribute anAttr = (Attribute)attributes.nextElement();
                into.write(anAttr.getName() + "=\"" + anAttr.getValue() + "\" ");
            }
            into.write(")");
        }
        into.write(" : ");
        if (null != this.val) {
            into.write(this.val + "\n");
        } else {
            into.write("\n");
        }
        if (recurse) {
            Enumeration childrens = this.getChildren();
            while (childrens.hasMoreElements()) {
                ((PlainTextElement)childrens.nextElement()).printNice(into, indent + 1, recurse);
            }
        }
    }

    @Override
    public String addAttribute(String name, String value) {
        String oldAttrValue = (String)this.attributes.remove(name);
        this.attributes.put(name, value);
        return oldAttrValue;
    }

    @Override
    public String addAttribute(Attribute newAttrib) {
        return this.addAttribute(newAttrib.getName(), newAttrib.getValue());
    }

    public Enumeration getAttributes() {
        Vector<Attribute> attrs = new Vector<Attribute>();
        for (Map.Entry anAttr : this.attributes.entrySet()) {
            Attribute attr = new Attribute(this, (String)anAttr.getKey(), (String)anAttr.getValue());
            attrs.addElement(attr);
        }
        return attrs.elements();
    }

    @Override
    public Attribute getAttribute(String name) {
        String value = (String)this.attributes.get(name);
        if (null == value) {
            return null;
        }
        return new Attribute(this, name, value);
    }
}

