/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.security;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.tomcat.util.net.jsse.JSSE14SocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;

public class NssSocketFactory
extends JSSE14SocketFactory {
    NssSocketFactory() {
    }

    protected KeyStore getKeystore(String pass) throws IOException {
        String keyAlias = (String)this.attributes.get("keyAlias");
        String token = NssSocketFactory.getTokenFromKeyAlias(keyAlias);
        SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
        KeyStore ks = secSupp.getKeyStore(token);
        if (ks == null) {
            throw new IOException("keystore not found for token " + token);
        }
        return ks;
    }

    protected KeyStore getTrustStore() throws IOException {
        try {
            return SSLUtils.getMergedTrustStore();
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
        String token = NssSocketFactory.getTokenFromKeyAlias(keyAlias);
        String certAlias = NssSocketFactory.getCertAliasFromKeyAlias(keyAlias);
        String keystorePass = secSupp.getKeyStorePassword(token);
        KeyStore ks = secSupp.getKeyStore(token);
        if (ks == null) {
            throw new IOException("keystore not found for token " + token);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        for (int i = 0; certAlias != null && i < kms.length; ++i) {
            kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], certAlias);
        }
        return kms;
    }

    private static String getTokenFromKeyAlias(String keyAlias) {
        int idx;
        String token = null;
        if (keyAlias != null && (idx = keyAlias.indexOf(58)) != -1) {
            token = keyAlias.substring(0, idx);
        }
        token = token == null ? "NSS Certificate DB" : token.trim();
        return token;
    }

    private static String getCertAliasFromKeyAlias(String keyAlias) {
        String certAlias = null;
        if (keyAlias != null) {
            int idx = keyAlias.indexOf(58);
            if (idx == -1) {
                certAlias = keyAlias;
            } else if (++idx < keyAlias.length() - 1) {
                certAlias = keyAlias.substring(idx);
            }
        }
        if (certAlias != null) {
            certAlias = certAlias.trim();
        }
        return certAlias;
    }
}

