/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.security;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.ee.security.NssStore;
import com.sun.enterprise.ee.security.NssTokenInfo;
import com.sun.enterprise.ee.synchronization.api.SecurityServiceMgr;
import com.sun.enterprise.ee.synchronization.api.SynchronizationContext;
import com.sun.enterprise.ee.synchronization.api.SynchronizationFactory;
import com.sun.enterprise.security.SecuritySupportImpl;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.OS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import sun.security.pkcs11.SunPKCS11;

public class EESecuritySupportImpl
extends SecuritySupportImpl {
    static final String INTERNAL_TOKEN = "NSS Certificate DB";
    private static final String NAME_PREFIX = "__SUN_SJSAS_";
    public static final String SPARCV9 = "sparcv9";
    public static final String AMD64 = "amd64";

    public EESecuritySupportImpl() {
        super(false);
        if (this.useNSS()) {
            EESecuritySupportImpl.initNSS();
        } else {
            this.initJKS();
        }
    }

    public void synchronizeKeyFile(ConfigContext configContext, String fileRealmName) throws Exception {
        if (AdminService.getAdminService().isDas()) {
            return;
        }
        SynchronizationContext synchCtx = SynchronizationFactory.createSynchronizationContext(configContext);
        SecurityServiceMgr securitySynchMgr = synchCtx.getSecurityServiceMgr();
        securitySynchMgr.synchronizeKeyFile(fileRealmName);
    }

    private static synchronized void initNSS() {
        if (initialized) {
            return;
        }
        EESecuritySupportImpl.loadNSSNativeLibrary();
        initialized = true;
        String dbDir = System.getProperty("com.sun.appserv.nss.db");
        boolean isWin = OS.isWindows();
        boolean is64BitVM = false;
        String osArch = System.getProperty("os.arch");
        if (osArch.equals(SPARCV9) || osArch.equals(AMD64)) {
            is64BitVM = true;
        }
        String libsoftokenLib = System.getProperty("com.sun.aas.nssRoot") + File.separator + (is64BitVM ? osArch + File.separator : "") + (isWin ? "softokn3.dll" : "libsoftokn3.so");
        Map name2PwdMap = IdentityManager.getMap();
        try {
            NssStore nssStore = NssStore.getInstance(null, false);
            List tokenInfoList = nssStore.getTokenInfoList();
            EESecuritySupportImpl.loadSunPKCS11Stores(dbDir, libsoftokenLib, tokenInfoList, name2PwdMap);
            nssStore.initCAStore(NssStore.getNssDbPassword());
            trustStores.add((KeyStore)nssStore.getTrustStores().get(0));
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "nss.init_SunPKCS11_failed", ex);
            throw new IllegalStateException(ex.getMessage());
        }
    }

    private boolean useNSS() {
        String dbDir = System.getProperty("com.sun.appserv.nss.db");
        return new File(dbDir, "key3.db").exists();
    }

    private static void loadNSSNativeLibrary() {
        boolean isWin = OS.isWindows();
        if (!isWin) {
            System.loadLibrary("nspr4");
            System.loadLibrary("plc4");
            System.loadLibrary("plds4");
        } else {
            System.loadLibrary("libnspr4");
            System.loadLibrary("libplc4");
            System.loadLibrary("libplds4");
        }
    }

    private static void loadSunPKCS11Stores(String dbDir, String libsoftokenLib, List tokenInfoList, Map name2PwdMap) throws Exception {
        Provider[] providers = Security.getProviders();
        int ind = -1;
        int i = 0;
        while (i < providers.length && providers[i] instanceof SunPKCS11) {
            ind = i++;
        }
        Map token2ConfigMap = EESecuritySupportImpl.getOtherConfigMap();
        tokenInfoList.add(new NssTokenInfo(INTERNAL_TOKEN, libsoftokenLib, 1));
        int size = tokenInfoList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            NssTokenInfo tokenInfo = (NssTokenInfo)tokenInfoList.get(i2);
            String tokenName = tokenInfo.getTokenName();
            String configFile = (String)token2ConfigMap.get(tokenName);
            SunPKCS11 pkcs11Provider = null;
            if (configFile != null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Load PKCS11 stores with " + configFile);
                }
                pkcs11Provider = new SunPKCS11(configFile);
            } else {
                InputStream configStream = null;
                if (INTERNAL_TOKEN.equals(tokenName)) {
                    configStream = EESecuritySupportImpl.getNSSPKCS11ConfigStream(dbDir, libsoftokenLib);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Load NSS PKCS11 stores with dbDir = " + dbDir + ", softoken lib = " + libsoftokenLib);
                    }
                } else {
                    String libname = tokenInfo.getLibname();
                    int slotListIndex = tokenInfo.getSlotListIndex();
                    configStream = EESecuritySupportImpl.getPKCS11ConfigStream(NAME_PREFIX + i2, libname, slotListIndex);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Load PKCS11 stores with tokenName = " + tokenName + ", libname = " + libname + ", slotListIndex = " + slotListIndex);
                    }
                }
                pkcs11Provider = new SunPKCS11(tokenName, configStream);
            }
            int index = i2 == size ? ind + i2 + 2 : i2 + 1;
            Security.insertProviderAt(pkcs11Provider, index);
            String password = (String)name2PwdMap.get(tokenName);
            if (INTERNAL_TOKEN.equals(tokenName) || password == null) {
                password = NssStore.getNssDbPassword();
            }
            EESecuritySupportImpl.loadStores((String)tokenName, (String)"PKCS11", (Provider)pkcs11Provider, null, (String)password, null, (String)password);
        }
    }

    private static Map getOtherConfigMap() throws ConfigException {
        LinkedHashMap<String, String> token2ConfigMap = new LinkedHashMap<String, String>();
        ServerContext serverContext = ApplicationServer.getServerContext();
        ElementProperty[] elementProps = null;
        if (serverContext != null) {
            SecurityService securityService;
            ConfigContext configContext = serverContext.getConfigContext();
            if (configContext != null && (securityService = ServerBeansFactory.getSecurityServiceBean((ConfigContext)configContext)) != null) {
                elementProps = securityService.getElementProperty();
            }
        } else {
            NodeAgent nodeAgent;
            NodeAgents nodeAgents;
            Domain domain;
            String domainXMLLocation = System.getProperty("com.sun.aas.instanceRoot") + "/config/domain.xml";
            ConfigContext configContext = ConfigFactory.createConfigContext((String)domainXMLLocation);
            if (configContext != null && (domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext)) != null && (nodeAgents = domain.getNodeAgents()) != null && (nodeAgent = nodeAgents.getNodeAgentByName(System.getProperty("com.sun.aas.instanceName"))) != null) {
                elementProps = nodeAgent.getElementProperty();
            }
        }
        if (elementProps != null && elementProps.length > 0) {
            for (int i = 0; i < elementProps.length; ++i) {
                token2ConfigMap.put(elementProps[i].getName(), elementProps[i].getValue());
            }
        }
        return token2ConfigMap;
    }

    private static InputStream getNSSPKCS11ConfigStream(String dbDir, String library) {
        StringBuffer buf = new StringBuffer("name=__SUN_SJSAS_internal\n");
        buf.append("library=").append(library).append("\n");
        buf.append("nssArgs=\"configdir='").append(dbDir).append("' certPrefix='' keyPrefix='' secmod='secmod.db'\"\n");
        buf.append("slot=2\n");
        buf.append("attributes=compatibility\n");
        buf.append("omitInitialize=true\n");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    private static InputStream getPKCS11ConfigStream(String name, String library, int slotListIndex) {
        StringBuffer buf = new StringBuffer("name=").append(name).append("\n");
        buf.append("library=").append(library).append("\n");
        buf.append("slotListIndex=").append(slotListIndex).append("\n");
        buf.append("attributes=compatibility\n");
        buf.append("omitInitialize=true\n");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }
}

