/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.mbeanapi.NodeAgentMBean;
import com.sun.enterprise.ee.admin.proxy.NodeAgentProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

public class NodeAgentNotifier
implements Runnable {
    private static final Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManager _strMgr = StringManager.getManager(NodeAgentNotifier.class);
    private final ServerContext dasCtx;

    public NodeAgentNotifier(ServerContext sc) {
        _logger.fine(_strMgr.getString("notifier.thread_initialized"));
        this.dasCtx = sc;
    }

    public void run() {
        _logger.fine(_strMgr.getString("notifier.thread_running"));
        ConfigContext configContext = this.dasCtx.getConfigContext();
        this.notifyAllNodeAgentsOfNewLocation(configContext);
    }

    private void notifyAllNodeAgentsOfNewLocation(ConfigContext cc) {
        try {
            AdminService as = ServerHelper.getAdminServiceForServer((ConfigContext)cc, (String)"server");
            JmxConnector config = as.getJmxConnectorByName(as.getSystemJmxConnectorName());
            ElementProperty clientHostname = config.getElementPropertyByName("client-hostname");
            if (clientHostname != null) {
                NodeAgent[] nas;
                String newHost = clientHostname.getValue();
                for (NodeAgent na : nas = NodeAgentHelper.getNodeAgentsInDomain((ConfigContext)cc)) {
                    this.dasHasMoved(newHost, config.getPort(), na);
                }
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, _strMgr.getString("notifier.fetch_error", (Object)ce.getMessage()));
        }
    }

    private void dasHasMoved(String newHost, String newPort, NodeAgent na) {
        try {
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(na.getName());
            agentMBean.dasHasMoved(newHost, newPort);
        }
        catch (AgentException ex) {
            _logger.log(Level.WARNING, _strMgr.getString("notifier.nodeagent_notify_error", (Object)na.getName()));
        }
        catch (MBeanException me) {
            _logger.log(Level.WARNING, _strMgr.getString("notifier.nodeagent_contact_error", (Object)na.getName()));
        }
    }
}

