/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import java.util.ArrayList;
import javax.management.ObjectName;

public abstract class SourceAndRefMatcher {
    private final String[] srcKeys;
    private final String[] refKeys;

    protected SourceAndRefMatcher(String[] srcKeys, String[] refKeys) {
        this.srcKeys = srcKeys;
        this.refKeys = refKeys;
    }

    public ObjectName[] matchingRefs(ObjectName[] srcs, ObjectName[] refs) {
        SourceAndRefMatcher.checkArg(srcs);
        SourceAndRefMatcher.checkArg(refs);
        ArrayList<ObjectName> al = new ArrayList<ObjectName>();
        for (int i = 0; i < refs.length; ++i) {
            String ref = SourceAndRefMatcher.getKeyProperty(refs[i], this.refKeys);
            assert (ref != null);
            for (int j = 0; j < srcs.length; ++j) {
                String name = SourceAndRefMatcher.getKeyProperty(srcs[j], this.srcKeys);
                assert (name != null);
                if (!name.equals(ref)) continue;
                al.add(refs[i]);
            }
        }
        return al.toArray(new ObjectName[0]);
    }

    public ObjectName[] matchingSrcs(ObjectName[] srcs, ObjectName[] refs) {
        SourceAndRefMatcher.checkArg(srcs);
        SourceAndRefMatcher.checkArg(refs);
        ArrayList<ObjectName> al = new ArrayList<ObjectName>();
        for (int i = 0; i < refs.length; ++i) {
            String ref = SourceAndRefMatcher.getKeyProperty(refs[i], this.refKeys);
            assert (ref != null);
            for (int j = 0; j < srcs.length; ++j) {
                String name = SourceAndRefMatcher.getKeyProperty(srcs[j], this.srcKeys);
                assert (name != null);
                if (!name.equals(ref)) continue;
                al.add(srcs[j]);
            }
        }
        return al.toArray(new ObjectName[0]);
    }

    private static String getKeyProperty(ObjectName on, String[] aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            String name = on.getKeyProperty(aliases[i]);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    private static void checkArg(Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
    }
}

