/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.writer;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.ee.admin.lbadmin.beans.Loadbalancer;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LoadbalancerReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.LoadbalancerReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.transform.LoadbalancerVisitor;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigWriter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.netbeans.modules.schema2beans.Schema2BeansException;

public class LbConfigExporter {
    private static final StringManager _strMgr = StringManager.getManager(LbConfigWriter.class);
    private static final String PUBLICID = "-//Sun Microsystems Inc.//DTD Sun Java System Application Server 9.1//EN";
    private static final String SYSTEMID = "sun-loadbalancer_1_2.dtd";

    public static LoadbalancerReader getLbReader(ConfigContext ctx, String lbConfigName) throws ConfigException, Schema2BeansException {
        LbConfig lbConfig = ((Domain)ctx.getRootConfigBean()).getLbConfigs().getLbConfigByName(lbConfigName);
        return new LoadbalancerReaderImpl(ctx, lbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportXml(LoadbalancerReader lbRdr, OutputStream out) throws IOException {
        Loadbalancer _lb = new Loadbalancer();
        LoadbalancerVisitor lbVstr = new LoadbalancerVisitor(_lb);
        lbRdr.accept(lbVstr);
        try {
            String footer = _strMgr.getString("GeneratedFileFooter", (Object)new Date().toString());
            _lb.graphManager().setDoctype(PUBLICID, SYSTEMID);
            _lb.write(out);
            out.write(footer.getBytes());
        }
        finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
    }

    public static String getXML(ConfigContext ctx, String lbConfigName) throws IOException, ConfigException, Schema2BeansException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LoadbalancerReader lbr = LbConfigExporter.getLbReader(ctx, lbConfigName);
        LbConfigExporter.exportXml(lbr, out);
        return out.toString();
    }
}

