/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBUtils;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class HADBCreateDBInfo
extends HADBInfo {
    private boolean doCleanup = true;
    private ArrayList extraArgs = new ArrayList();
    private Hashtable<String, String> hadbmSetProps = new Hashtable();
    private String historyPath;
    private String devicePath;
    private String agentURLOverride;
    private int deviceSize = 512;
    private int dataDevices = 1;
    private int portBase = 15200;
    private int spares = 0;
    private int logBufferSize = 0;
    private Hashtable<String, String> props;
    private static final int MAX_DEVICE_SIZE = 262144;
    private static final int MIN_DEVICE_SIZE = 32;
    private static final int DEFAULT_DEVICE_SIZE = 512;
    private static final int DEFAULT_DATA_DEVICES = 1;
    private static final int DEFAULT_PORT_BASE = 15200;
    private static final int DEFAULT_SPARES = 0;
    private static final String DEFAULT_DEVICE_SUBDIR = "device";
    private static final String DEFAULT_HISTORY_SUBDIR = "history";
    private static final int DEFAULT_LOG_BUFFER_SIZE = 48;

    public HADBCreateDBInfo(String hosts, String agentPort, String theAdminPassword, String userPasswordFile, Boolean autohadb, String portbase, String clusterOrDbName, Logger logger, ConfigContext configCtx, MBeanServer mbeanServer) throws HADBSetupException {
        super(hosts, agentPort, theAdminPassword, userPasswordFile, clusterOrDbName, logger, configCtx, mbeanServer);
        this.setAutoHadb(autohadb);
        this.setPortBase(portbase);
    }

    public final void setDeviceSize(String size) throws HADBSetupException {
        int newDeviceSize = 0;
        if (size == null || size.length() <= 0) {
            return;
        }
        try {
            newDeviceSize = Integer.parseInt(size);
            if (newDeviceSize < 32 || newDeviceSize > 262144) {
                throw new NumberFormatException();
            }
            this.deviceSize = newDeviceSize;
        }
        catch (NumberFormatException nfe) {
            throw new HADBSetupException("hadbmgmt-res.BadDeviceSize", new String[]{"32", "262144", size});
        }
    }

    public final void setProperties(Properties p) throws HADBSetupException {
        this.props = HADBUtils.props2hash(p);
        this.parseProps();
    }

    final String[] getCreateCommands() throws HADBSetupException {
        boolean old;
        ArrayList<String> list = new ArrayList<String>(32);
        list.add("create");
        list.add("--quiet");
        double ver = this.getVersion().getMajor();
        boolean bl = old = ver < 4.5;
        if (this.doCleanup) {
            if (old) {
                list.add("--no-cleanup=false");
            } else {
                list.add("--cleanup=true");
            }
        } else if (old) {
            list.add("--no-cleanup=true");
        } else {
            list.add("--cleanup=false");
        }
        if (this.getHistoryPath() != null) {
            list.add("--historypath=" + this.getHistoryPath());
        }
        if (this.getDevicePath() != null) {
            list.add("--devicepath=" + this.getDevicePath());
        }
        list.add("--datadevices=" + this.getDataDevices());
        list.add("--portbase=" + this.getPortBase());
        list.add("--spares=" + this.getSpares());
        list.add("--devicesize=" + this.deviceSize);
        list.add(this.getJavaRootArg());
        list.add(this.getAdminPasswordManager().getArg());
        list.add(this.getDBPasswordManager().getArg());
        list.add("--hosts=" + this.getHosts());
        list.add(this.getAgentURLArg());
        list.addAll(this.extraArgs);
        list.add(this.hadbmSetProps2String());
        list.add(this.getClusterName());
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    void validate() throws HADBSetupException {
        boolean noModifyLogBufferSize = false;
        if (this.logBufferSize > 0) {
            noModifyLogBufferSize = true;
        } else {
            this.logBufferSize = 48;
        }
        if (this.deviceSize < 32 || this.deviceSize > 262144) {
            throw new HADBSetupException("hadbmgmt-res.BadDeviceSize", new String[]{"32", "262144", "" + this.deviceSize});
        }
        if (this.deviceSize < 4 * this.logBufferSize + 16) {
            if (noModifyLogBufferSize) {
                throw new HADBSetupException("hadbmgmt-res.BadDeviceSizeFixedLogBufferSize", new String[]{"32", "262144", "" + this.logBufferSize, "" + this.deviceSize});
            }
            this.logBufferSize = (this.deviceSize - 16) / 4;
            LoggerHelper.warning("hadbmgmt-res.AdjustedLogBufferSize", 48, this.logBufferSize);
        }
    }

    final int getLogBufferSize() {
        return this.logBufferSize;
    }

    final int getPortBase() {
        return this.portBase;
    }

    private final void parseProps() throws HADBSetupException {
        if (this.props == null || this.props.size() <= 0) {
            return;
        }
        this.parseAndRemoveOfficalArgs();
        this.parseOtherArgs();
        this.checkLeftoverArgs();
    }

    private final void parseAndRemoveOfficalArgs() throws HADBSetupException {
        if (this.props == null) {
            return;
        }
        String pathErr = "hadbmgmt-res.BadPathInProperty";
        String key = "historypath";
        String s = this.props.get(key);
        if (this.ok(s)) {
            this.historyPath = this.checkPath(s, pathErr, key + "=" + s);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "devicepath"))) {
            this.devicePath = this.checkPath(s, pathErr, key + "=" + s);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "datadevicesize"))) {
            this.setDeviceSize(s);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "datadevices"))) {
            this.dataDevices = this.parseInt(s, 1, 1000, 1);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "numberofdatadevices"))) {
            this.dataDevices = this.parseInt(s, 1, 1000, 1);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "portbase"))) {
            this.setPortBase(s);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "spares"))) {
            this.spares = this.parseInt(s, 0, 1000, 0);
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "agent"))) {
            this.agentURLOverride = s;
            this.props.remove(key);
        }
        if (this.ok(s = this.props.get(key = "dbpassword"))) {
            this.setDatabasePassword(s, true);
            this.props.remove(key);
        }
        if (this.props.containsKey(key = "--no-cleanup")) {
            s = this.props.get(key);
            if (!this.ok(s) || s.equals("true")) {
                this.doCleanup = false;
            }
            this.props.remove(key);
        }
        if (this.props.containsKey(key = "nocleanup")) {
            s = this.props.get(key);
            if (!this.ok(s) || s.equals("true")) {
                this.doCleanup = false;
            }
            this.props.remove(key);
        }
        if (this.props.containsKey(key = "cleanup")) {
            s = this.props.get(key);
            if (this.ok(s) && s.equals("false")) {
                this.doCleanup = false;
            }
            this.props.remove(key);
        }
        if (this.props.containsKey(key = "--no-clear")) {
            s = this.props.get(key);
            if (!this.ok(s) || s.equals("true")) {
                this.extraArgs.add("--no-clear");
            }
            this.props.remove(key);
        }
        if (this.props.containsKey(key = "noclear")) {
            s = this.props.get(key);
            if (!this.ok(s) || s.equals("true")) {
                this.extraArgs.add("--no-clear");
            }
            this.props.remove(key);
        }
    }

    private final void parseOtherArgs() {
        if (this.props == null || this.props.size() <= 0) {
            return;
        }
        for (String arg : HADBUtils.validCreateAttributes) {
            String key = arg.toLowerCase();
            String value = this.props.get(key);
            if (!this.ok(value)) continue;
            if (key.equals("logbuffersize")) {
                this.logBufferSize = this.parseInt(value, 4, 2047, 0);
                if (this.logBufferSize == 0) {
                    LoggerHelper.warning("hadbmgmt-res.BadLogBufferSize", value);
                }
            } else {
                this.hadbmSetProps.put(arg, value);
            }
            this.props.remove(key);
        }
    }

    private final String hadbmSetProps2String() {
        StringBuilder setstr = new StringBuilder("--set=LogBufferSize=" + this.logBufferSize);
        Set<Map.Entry<String, String>> set = this.hadbmSetProps.entrySet();
        for (Map.Entry<String, String> entry : set) {
            setstr.append(",").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return setstr.toString();
    }

    private final void checkLeftoverArgs() throws HADBSetupException {
        if (this.props.size() > 0) {
            throw new HADBSetupException("hadbmgmt-res.UnknownProperties", this.props);
        }
    }

    private final String getHistoryPath() {
        return this.historyPath;
    }

    private final String getDevicePath() {
        return this.devicePath;
    }

    String getAgentURLArg() throws HADBSetupException {
        if (this.agentURLOverride != null) {
            return "--agent=" + this.agentURLOverride;
        }
        return super.getAgentURLArg();
    }

    private final int getDataDevices() {
        return this.dataDevices;
    }

    private final int getSpares() {
        return this.spares;
    }

    private final boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private final int parseInt(String s, int min, int max, int defaultValue) {
        try {
            int num = Integer.parseInt(s);
            if (num >= min && num <= max) {
                return num;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return defaultValue;
    }

    private final String checkPath(String path, String errorMessage, String errorArg) throws HADBSetupException {
        if (path == null) {
            throw new HADBSetupException("hadbmgmt-res.InternalError", "null path argument sent to checkPath()");
        }
        File f = new File(path);
        f.mkdirs();
        if (!f.isDirectory()) {
            throw new HADBSetupException(errorMessage, errorArg);
        }
        return f.getAbsolutePath();
    }

    private final void setPortBase(String s) {
        this.portBase = 15200;
        if (this.ok(s)) {
            this.portBase = this.parseInt(s, 1, 65535, 15200);
        }
    }
}

