/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.HADBSessionStoreUtil;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EESchemaUpdater
implements SchemaUpdater {
    public static final String driver = "com.sun.hadb.jdbc.Driver";
    private static final String BLOBSESSIONS = "blobsessions";
    private static final String SESSIONHEADER = "sessionheader";
    private static final String SESSIONATTRIBUTE = "sessionattribute";
    private static final String SINGLESIGNON = "singlesignon";
    private static final String STATEFULSESSIONBEAN = "statefulsessionbean";
    private Connection con;
    private static boolean _verbose = true;
    private static String HADB_URL_PREFIX = "jdbc:sun:hadb:";
    private String user = null;
    private String password = null;
    private String url = null;

    public EESchemaUpdater() {
    }

    public EESchemaUpdater(String url, String user, String password) throws SQLException, ClassNotFoundException {
        this.url = url;
        this.user = user;
        this.password = password;
        Class.forName(driver);
        String connUrl = HADB_URL_PREFIX + user + "+" + password + "@" + url;
        EESchemaUpdater.message("EESchemaUpdater:connUrl = " + connUrl);
        this.con = DriverManager.getConnection(connUrl);
    }

    public void init() throws SQLException, ClassNotFoundException {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String connUrl = lookup.getConnectionURLFromConfig();
        String password = lookup.getConnectionPasswordFromConfig();
        String user = lookup.getConnectionUserFromConfig();
        this.init(connUrl, user, password);
    }

    public void init(String url, String user, String password) throws SQLException, ClassNotFoundException {
        this.url = url;
        this.user = user;
        this.password = password;
        if (!this.checkInputParameters()) {
            return;
        }
        String strippedURL = this.stripURL(url);
        Class.forName(driver);
        String connUrl = HADB_URL_PREFIX + user + "+" + password + "@" + strippedURL;
        this.con = DriverManager.getConnection(connUrl);
    }

    private void closeConnection() {
        try {
            this.con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkInputParameters() {
        String strippedURL = this.stripURL(this.url);
        return this.user != null && !this.user.equals("") && this.password != null && !this.password.equals("") && !strippedURL.equals("");
    }

    private String stripURL(String inputUrl) {
        String token;
        if (inputUrl == null || inputUrl.equals("")) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(inputUrl, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String result = token = (String)list.get(0);
        if (token.startsWith(HADB_URL_PREFIX)) {
            result = token.substring(HADB_URL_PREFIX.length());
        }
        return result;
    }

    private void describeTable() throws SQLException {
        EESchemaUpdater.message("describeTable");
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getPrimaryKeys(null, null, BLOBSESSIONS);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            String keySeq = rs.getString("KEY_SEQ");
            String pkName = rs.getString("PK_NAME");
            EESchemaUpdater.message("table name: " + tableName);
            EESchemaUpdater.message("column name: " + columnName);
            EESchemaUpdater.message("sequence in key: " + keySeq);
            EESchemaUpdater.message("primary key name: " + pkName);
        }
        this.con.commit();
        EESchemaUpdater.message("Table blobsessions described");
    }

    public boolean doTablesExist() throws SQLException, ClassNotFoundException {
        this.init();
        boolean result = true;
        result = this.doesTableExist(BLOBSESSIONS);
        if (!result) {
            return result;
        }
        result = this.doesTableExist(SESSIONHEADER);
        if (!result) {
            return result;
        }
        result = this.doesTableExist(SESSIONATTRIBUTE);
        if (!result) {
            return result;
        }
        result = this.doesTableExist(SINGLESIGNON);
        if (!result) {
            return result;
        }
        result = this.doesTableExist(STATEFULSESSIONBEAN);
        this.closeConnection();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesTableExist(String tableName) throws SQLException {
        EESchemaUpdater.message("checking if " + tableName + " table exists");
        boolean tableExists = true;
        try {
            DatabaseMetaData dbmd = this.con.getMetaData();
            ResultSet rs = dbmd.getPrimaryKeys(null, null, tableName);
            if (!rs.next()) {
                tableExists = false;
            }
        }
        catch (SQLException ex) {
            tableExists = false;
            try {
                this.con.rollback();
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        finally {
            try {
                this.con.commit();
            }
            catch (Exception exception) {}
        }
        if (tableExists) {
            EESchemaUpdater.message("Table " + tableName + " exists");
        } else {
            EESchemaUpdater.message("Table " + tableName + " does not exist");
        }
        return tableExists;
    }

    private boolean isSchemaVersion2() throws SQLException {
        int ct = 0;
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getPrimaryKeys(null, null, BLOBSESSIONS);
        while (rs.next()) {
            ++ct;
        }
        return ct == 2;
    }

    public void doSchemaCheck() throws IOException {
        boolean ableToProceed = true;
        try {
            this.init();
        }
        catch (Exception ex) {
            ableToProceed = false;
            System.out.println("EESchemaUpdater: - skipping schema update");
        }
        if (ableToProceed) {
            this.checkAndUpdateHADBSchema();
        }
    }

    public void checkAndUpdateHADBSchema() throws IOException {
        if (!this.checkInputParameters()) {
            return;
        }
        boolean isVersion2 = true;
        boolean proceed = false;
        try {
            isVersion2 = this.isSchemaVersion2();
            proceed = true;
        }
        catch (Exception ex) {
            proceed = false;
        }
        if (!proceed) {
            return;
        }
        if (!isVersion2) {
            EESchemaUpdater.message("recreating HADB tables");
            String connUrl = this.url;
            if (!this.url.startsWith(HADB_URL_PREFIX)) {
                connUrl = HADB_URL_PREFIX + this.url;
            }
            HADBSessionStoreUtil storeUtil = null;
            try {
                storeUtil = new HADBSessionStoreUtil(this.user, this.password, connUrl);
                storeUtil.runtimeClearSessionStore();
            }
            catch (HADBSetupException ex) {
                throw new IOException(ex.getMessage());
            }
        } else {
            EESchemaUpdater.message("not recreating HADB tables");
        }
    }

    private static void message(String message) {
        if (_verbose) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 3) {
            System.out.println("EESchemaUpdater usage: java EESchemaUpdater url [user] [password]");
            System.exit(1);
        }
        EESchemaUpdater upd = null;
        try {
            upd = args.length == 3 ? new EESchemaUpdater(args[0], args[1], args[2]) : new EESchemaUpdater(args[0], "system", "super123");
            EESchemaUpdater.message("NEW SCHEMA: " + upd.isSchemaVersion2());
            upd.describeTable();
            upd.checkAndUpdateHADBSchema();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

