/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfoImpl;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.util.ArrayConversion;
import com.sun.enterprise.ee.admin.dottedname.DottedNameServerInfoEE;
import java.io.IOException;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DottedNameServerInfoImplEE
extends DottedNameServerInfoImpl
implements DottedNameServerInfoEE {
    MBeanServerConnection mConn;

    public DottedNameServerInfoImplEE(MBeanServerConnection conn) {
        super(conn);
        this.mConn = conn;
    }

    protected Set _getServerNames() throws ReflectionException, InstanceNotFoundException, MBeanException, IOException {
        MyController controller = this.getServersController();
        Object[] names = controller.listServerInstancesAsString("domain", false);
        return ArrayConversion.toSet((Object[])names);
    }

    private MyController getServersController() {
        String[] domains = new String[]{MBeanRegistryFactory.getAdminContext().getDomainName()};
        MBeanRegistry reg = MBeanRegistryFactory.getAdminMBeanRegistry();
        return MBeanServerInvocationHandler.newProxyInstance(this.mConn, reg.getMbeanObjectName("servers", domains), MyController.class, false);
    }

    public Set getUnclusteredServerNames() {
        MyController c = this.getServersController();
        ObjectName[] names = c.listUnclusteredServerInstances(false);
        Object[] sNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            sNames[i] = names[i].getKeyProperty("name");
        }
        return ArrayConversion.toSet((Object[])sNames);
    }

    public Set getResourceNamesForServer(String serverName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, DottedNameServerInfo.UnavailableException, MalformedObjectNameException {
        MyController server = this.getServerController(serverName);
        Object[] resourceNames = server.listResourceReferencesAsString();
        return ArrayConversion.toSet((Object[])resourceNames);
    }

    public Set getApplicationNamesForServer(String serverName) throws ReflectionException, InstanceNotFoundException, MBeanException, IOException, DottedNameServerInfo.UnavailableException, MalformedObjectNameException {
        MyController server = this.getServerController(serverName);
        Object[] appNames = server.listApplicationReferencesAsString();
        return ArrayConversion.toSet((Object[])appNames);
    }

    private MyController getServerController(String serverName) throws MalformedObjectNameException {
        ObjectName server = new ObjectName("com.sun.appserv:type=server,name=" + serverName + ",category=config");
        return MBeanServerInvocationHandler.newProxyInstance(this.mConn, server, MyController.class, false);
    }

    private static interface MyController {
        public String[] listServerInstancesAsString(String var1, boolean var2);

        public String[] listResourceReferencesAsString();

        public String[] listApplicationReferencesAsString();

        public ObjectName[] listUnclusteredServerInstances(boolean var1);
    }
}

