/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.clientreg.NodeAgentRegistry;
import com.sun.enterprise.ee.admin.concurrent.Executor;
import com.sun.enterprise.ee.admin.concurrent.Task;
import com.sun.enterprise.ee.admin.mbeanapi.NodeAgentMBean;
import com.sun.enterprise.ee.admin.proxy.NodeAgentProxy;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.logging.ee.EELogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NodeAgentsConfigBean
extends BaseConfigBean
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager(NodeAgentsConfigBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    public NodeAgentsConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = EELogDomains.getLogger((String)"javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(NodeAgentsConfigBean.getLogger());
        }
        return _handler;
    }

    public void clearRuntimeStatus(String agentName) throws AgentException {
        block2: {
            try {
                NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(agentName);
                agentMBean.clearRuntimeStatus();
            }
            catch (Exception ex) {
                if (NodeAgentProxy.isUnreachable(ex)) break block2;
                throw new AgentException(ex);
            }
        }
    }

    public RuntimeStatus getRuntimeStatus(String agentName) throws AgentException {
        try {
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(agentName);
            return agentMBean.getRuntimeStatus();
        }
        catch (Exception ex) {
            if (NodeAgentProxy.isUnreachable(ex)) {
                return new RuntimeStatus(agentName);
            }
            throw new AgentException(ex);
        }
    }

    public boolean isRunning(String agentName) throws AgentException {
        return this.getRuntimeStatus(agentName).isRunning();
    }

    public RuntimeStatusList getRuntimeStatus(NodeAgent[] agents) {
        Task[] tasks = new GetRuntimeStatusTask[agents.length];
        for (int i = 0; i < agents.length; ++i) {
            tasks[i] = new GetRuntimeStatusTask(agents[i].getName());
        }
        Executor exec = new Executor(tasks);
        exec.run();
        RuntimeStatusList result = new RuntimeStatusList(agents.length);
        for (int i = 0; i < agents.length; ++i) {
            result.add((Object)((GetRuntimeStatusTask)tasks[i]).getStatus());
        }
        return result;
    }

    public RuntimeStatusList getNodeAgentRuntimeStatus(String targetName) throws AgentException {
        StringManager stringMgr = StringManager.getManager(AgentManager.class);
        try {
            TargetType[] validTargets = new TargetType[]{TargetType.NODE_AGENT, TargetType.CLUSTER, TargetType.DOMAIN, TargetType.SERVER};
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget("domain", validTargets, targetName, configContext);
            NodeAgent[] agents = target.getNodeAgents();
            return this.getRuntimeStatus(agents);
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.listNodeAgents.Exception", targetName);
        }
    }

    public String[] listNodeAgentsAsString(String targetName, boolean andStatus) throws AgentException {
        StringManager stringMgr = StringManager.getManager(AgentManager.class);
        try {
            TargetType[] validTargets = new TargetType[]{TargetType.NODE_AGENT, TargetType.CLUSTER, TargetType.DOMAIN, TargetType.SERVER};
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget("domain", validTargets, targetName, configContext);
            NodeAgent[] agents = target.getNodeAgents();
            int numAgents = agents.length;
            String[] result = new String[numAgents];
            String nodeAgentName = null;
            RuntimeStatusList statusList = null;
            if (andStatus) {
                statusList = this.getRuntimeStatus(agents);
            }
            for (int i = 0; i < numAgents; ++i) {
                nodeAgentName = agents[i].getName();
                result[i] = andStatus ? stringMgr.getString("listAgentElement", (Object)nodeAgentName, (Object)statusList.getStatus(i).toShortString()) : nodeAgentName;
            }
            return result;
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.listNodeAgents.Exception", targetName);
        }
    }

    public void deleteNodeAgentConfig(String nodeAgentName) throws AgentException {
        try {
            NodeAgent controller;
            ConfigContext configContext;
            block5: {
                configContext = this.getConfigContext();
                controller = NodeAgentHelper.getNodeAgentByName((ConfigContext)configContext, (String)nodeAgentName);
                Server[] servers = ServerHelper.getServersOfANodeAgent((ConfigContext)configContext, (String)nodeAgentName);
                if (servers.length > 0) {
                    throw new AgentException(_strMgr.getString("agentHasServerReferrences", (Object)nodeAgentName, (Object)ServerHelper.getServersAsString((Server[])servers)));
                }
                try {
                    NodeAgentRegistry.getNodeAgentConnection(nodeAgentName);
                }
                catch (Exception ex) {
                    if (NodeAgentRegistry.isMBeanServerUnreachable(ex)) break block5;
                    throw new AgentException(ex);
                }
            }
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            NodeAgents controllers = domain.getNodeAgents();
            controllers.removeNodeAgent(controller, true);
            this.flushAll();
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(nodeAgentName);
            agentMBean.synchronizeWithDAS();
            NodeAgentRegistry.removeNodeAgentConnection(nodeAgentName);
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.unbindNodeAgent.Exception", nodeAgentName);
        }
    }

    public void createNodeAgentConfig(String nodeAgentName) throws AgentException {
        String host = "localhost";
        String port = "9999";
        try {
            ConfigContext configContext = this.getConfigContext();
            if (!ConfigAPIHelper.isNameUnique((ConfigContext)configContext, (String)nodeAgentName)) {
                throw new AgentException(_strMgr.getString("agentNameNotUnique", (Object)nodeAgentName));
            }
            Domain domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
            NodeAgents controllers = domain.getNodeAgents();
            NodeAgent controller = controllers.getNodeAgentByName(nodeAgentName);
            if (controller != null) {
                throw new AgentException(_strMgr.getString("agentAlreadyExists", (Object)nodeAgentName));
            }
            this.addNodeAgent("0.0.0.0", port, nodeAgentName, "rmi_jrmp", host, Boolean.FALSE);
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.bindNodeAgent.Exception", nodeAgentName);
        }
    }

    public String rendezvousWithDAS(String host, String port, String nodeAgentName, String protocol, String clientHostName) throws AgentException {
        String sxRet = "";
        try {
            ConfigContext configContext = this.getConfigContext();
            Domain domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
            NodeAgents controllers = domain.getNodeAgents();
            NodeAgent controller = controllers.getNodeAgentByName(nodeAgentName);
            if (controller != null) {
                ElementProperty rendezvousProperty = controller.getElementPropertyByName("rendezvousOccurred");
                String rendezvous = rendezvousProperty.getValue();
                if (rendezvous != null && rendezvousProperty.getValue().equals(Boolean.TRUE.toString())) {
                    throw new AgentException(_strMgr.getString("agentAlreadyExists", (Object)nodeAgentName));
                }
                this.alterNodeAgent(host, port, nodeAgentName, protocol, clientHostName, Boolean.TRUE);
            } else {
                if (!ConfigAPIHelper.isNameUnique((ConfigContext)configContext, (String)nodeAgentName)) {
                    throw new AgentException(_strMgr.getString("agentNameNotUnique", (Object)nodeAgentName));
                }
                this.addNodeAgent(host, port, nodeAgentName, protocol, clientHostName, Boolean.TRUE);
            }
            String dasName = System.getProperty("com.sun.aas.instanceName");
            if (dasName == null) {
                throw new AgentException(_strMgr.getString("noDASServerNameProperty"));
            }
            JmxConnector dasConnector = ServerHelper.getServerSystemConnector((ConfigContext)configContext, (String)dasName);
            NodeAgentsConfigBean.getLogger().log(Level.FINE, " Nodeagent: " + nodeAgentName + " has Renezvoused -  returning DAS JMXport|Security Enabled - " + dasConnector.getPort() + "|" + dasConnector.isSecurityEnabled());
            sxRet = dasConnector.getPort() + "|" + String.valueOf(dasConnector.isSecurityEnabled());
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.rendezvousWithDAS.Exception", nodeAgentName);
        }
        return sxRet;
    }

    protected void addNodeAgent(String host, String port, String nodeAgentName, String protocol, String clientHostName, Boolean rendezvousOccurred) throws AgentException {
        try {
            ConfigContext configContext = this.getConfigContext();
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                throw new AgentException(_strMgr.getString("portMustBeNumeric", (Object)port));
            }
            NodeAgents controllers = ServerBeansFactory.getDomainBean((ConfigContext)configContext).getNodeAgents();
            NodeAgent controller = new NodeAgent();
            controller.setName(nodeAgentName);
            ElementProperty rendezvousProperty = new ElementProperty();
            rendezvousProperty.setName("rendezvousOccurred");
            rendezvousProperty.setValue(rendezvousOccurred.toString());
            controller.addElementProperty(rendezvousProperty);
            JmxConnector connector = new JmxConnector();
            connector.setName("system");
            connector.setAddress(host);
            connector.setPort(port);
            connector.setProtocol(protocol);
            Ssl ssl = new Ssl();
            ssl.setCertNickname("s1as");
            connector.setSsl(ssl);
            ElementProperty hostnameProperty = new ElementProperty();
            hostnameProperty.setName("client-hostname");
            hostnameProperty.setValue(clientHostName);
            connector.addElementProperty(hostnameProperty);
            connector.setAuthRealmName("admin-realm");
            controller.setJmxConnector(connector);
            AuthRealm[] authRealms = new AuthRealm[]{new AuthRealm()};
            authRealms[0].setName("admin-realm");
            authRealms[0].setClassname("com.sun.enterprise.security.auth.realm.file.FileRealm");
            ElementProperty fileProperty = new ElementProperty();
            fileProperty.setName("file");
            fileProperty.setValue("${com.sun.aas.instanceRoot}/config/admin-keyfile");
            authRealms[0].addElementProperty(fileProperty);
            ElementProperty jaasContextProperty = new ElementProperty();
            jaasContextProperty.setName("jaas-context");
            jaasContextProperty.setValue("fileRealm");
            authRealms[0].addElementProperty(jaasContextProperty);
            controller.setAuthRealm(authRealms[0]);
            controller.setSystemJmxConnectorName("system");
            LogService log = new LogService();
            ModuleLogLevels logLevels = new ModuleLogLevels();
            log.setModuleLogLevels(logLevels);
            log.setFile("${com.sun.aas.instanceRoot}/logs/server.log");
            controller.setLogService(log);
            controllers.addNodeAgent(controller, true);
            this.flushAll();
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.addNodeAgent.Exception", nodeAgentName);
        }
    }

    protected void alterNodeAgent(String host, String port, String nodeAgentName, String protocol, String clientHostName, Boolean rendezvousOccurred) throws AgentException {
        try {
            ConfigContext configContext = this.getConfigContext();
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                throw new AgentException(_strMgr.getString("portMustBeNumeric", (Object)port));
            }
            NodeAgents controllers = ServerBeansFactory.getDomainBean((ConfigContext)configContext).getNodeAgents();
            NodeAgent controller = controllers.getNodeAgentByName(nodeAgentName);
            ElementProperty rendezvousProperty = controller.getElementPropertyByName("rendezvousOccurred");
            if (rendezvousProperty != null) {
                controller.removeElementProperty(rendezvousProperty);
            }
            rendezvousProperty = new ElementProperty();
            rendezvousProperty.setName("rendezvousOccurred");
            rendezvousProperty.setValue(rendezvousOccurred.toString());
            controller.addElementProperty(rendezvousProperty);
            JmxConnector connector = controller.getJmxConnector();
            connector.setAddress(host);
            connector.setPort(port);
            connector.setProtocol(protocol);
            ElementProperty hostnameProperty = connector.getElementPropertyByName("client-hostname");
            if (hostnameProperty == null) {
                hostnameProperty = new ElementProperty();
                hostnameProperty.setName("client-hostname");
                connector.addElementProperty(hostnameProperty);
            }
            hostnameProperty.setValue(clientHostName);
            this.flushAll();
        }
        catch (Exception ex) {
            throw NodeAgentsConfigBean.getExceptionHandler().handleAgentException(ex, "nodeagent.addNodeAgent.Exception", nodeAgentName);
        }
    }

    class GetRuntimeStatusTask
    extends Task {
        private static final long TIMEOUT_IN_MILLIS = 30000L;
        private String _agentName;
        private RuntimeStatus _status;

        public GetRuntimeStatusTask(String agentName) {
            super(30000L);
            this._agentName = agentName;
            this._status = new RuntimeStatus();
        }

        public RuntimeStatus getStatus() {
            return this._status;
        }

        public void run() {
            try {
                this._status = NodeAgentsConfigBean.this.getRuntimeStatus(this._agentName);
            }
            catch (AgentException ex) {
                StringManagerBase sm = StringManagerBase.getStringManager((String)NodeAgentsConfigBean.getLogger().getResourceBundleName());
                NodeAgentsConfigBean.getLogger().log(Level.WARNING, sm.getString("nodeagent.listNodeAgents.Exception", (Object)this._agentName), (Throwable)((Object)ex));
                this._status = new RuntimeStatus();
            }
        }
    }
}

