/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.helper.LBConfigHelper;
import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;

public class ConfigureLBWeightCommand
extends GenericCommand {
    private static final String CLUSTER_OPTION = "cluster";
    private static final StringManager _strMgr = StringManager.getManager(ConfigureLBWeightCommand.class);

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String clusterName = this.getOption(CLUSTER_OPTION);
        Map instanceWeights = this.getInstanceWeightsMap();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            LBConfigHelper lbconfigHelper = new LBConfigHelper(domainRoot);
            lbconfigHelper.configureLBWeight(clusterName, instanceWeights);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
    }

    private Map getInstanceWeightsMap() throws CommandValidationException, CommandException {
        Properties instanceWeightsProps = this.createPropertiesParam((String)this.getOperands().get(0));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Enumeration<?> e = instanceWeightsProps.propertyNames();
        while (e.hasMoreElements()) {
            Integer weightInt;
            String name = (String)e.nextElement();
            String weight = instanceWeightsProps.getProperty(name);
            try {
                weightInt = Integer.valueOf(weight);
            }
            catch (NumberFormatException nfe) {
                throw new CommandException(_strMgr.getString("InvalidWeightValue"));
            }
            map.put(name, weightInt);
            CLILogger.getInstance().printDebugMessage("Instance=" + name + ", weight=" + weightInt);
        }
        return map;
    }
}

