/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.transform.AttributeExtracter;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseElement {
    protected StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.transform");
    protected Logger logger = CommonInfoModel.getDefaultLogger();
    protected static CommonInfoModel commonInfoModel;

    public void transform(Element element, Element parentSource, Element parentResult) {
        NodeList childNodes = element.getChildNodes();
        this.logger.log(Level.FINE, this.stringManager.getString("upgrade.transform.baseelemnt.transformingMSG", (Object)element.getTagName()));
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node aNode = childNodes.item(index);
            try {
                if (aNode.getNodeType() != 1) continue;
                BaseElement baseElement = ElementToObjectMapper.getMapper().getElementObject(aNode.getNodeName());
                baseElement.transform((Element)aNode, element, parentResult);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.transform.baseelement.transformexception", (Object[])new String[]{element.getTagName(), ex.getMessage()}));
            }
        }
    }

    protected void transferAttributes(Element source, Element result, List nonTransferList) {
        boolean debug = false;
        NamedNodeMap sourceAttrNodeMap = source.getAttributes();
        if (sourceAttrNodeMap == null) {
            return;
        }
        NamedNodeMap resultAttrNodeMap = result.getAttributes();
        for (int index = 0; index < sourceAttrNodeMap.getLength(); ++index) {
            Node sourceAttrNode = sourceAttrNodeMap.item(index);
            if (!this.canTransferAttribute(sourceAttrNode.getNodeName(), nonTransferList) || !this.isValidAttributeToTransfer(sourceAttrNode.getNodeName(), this.getAttributeListForElement(result.getTagName()))) continue;
            if (resultAttrNodeMap == null) {
                Attr addAttr = result.getOwnerDocument().createAttribute(sourceAttrNode.getNodeName());
                addAttr.setValue(sourceAttrNode.getNodeValue());
                result.setAttributeNode(addAttr);
                continue;
            }
            Node resultAttrNode = resultAttrNodeMap.getNamedItem(sourceAttrNode.getNodeName());
            if (resultAttrNode != null) {
                resultAttrNode.setNodeValue(sourceAttrNode.getNodeValue());
                continue;
            }
            Attr addAttr = result.getOwnerDocument().createAttribute(sourceAttrNode.getNodeName());
            addAttr.setValue(sourceAttrNode.getNodeValue());
            result.setAttributeNode(addAttr);
        }
    }

    private boolean canTransferAttribute(String attr, List attrList) {
        if (attrList == null || attrList.isEmpty()) {
            return true;
        }
        Iterator it = attrList.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(attr)) continue;
            return false;
        }
        return true;
    }

    public static void setCommonInfoModel(CommonInfoModel cim) {
        commonInfoModel = cim;
    }

    protected String getKeyToCompare(String elementTagName) {
        return ElementToObjectMapper.getMapper().getKeyForElement(elementTagName);
    }

    protected List getInsertElementStructure(Element element, Element parentEle) {
        return ElementToObjectMapper.getMapper().getInsertElementStructure(element.getTagName());
    }

    public void appendElementToParent(Element parentEle, Element element) {
        List eleStructureList = this.getInsertElementStructure(element, parentEle);
        if (eleStructureList == null) {
            parentEle.appendChild(element);
            return;
        }
        if (eleStructureList.isEmpty()) {
            parentEle.insertBefore(element, parentEle.getFirstChild());
            return;
        }
        String insertBeforeElementName = null;
        Node insertBeforeNode = null;
        for (int eleIndex = 0; eleIndex < eleStructureList.size(); ++eleIndex) {
            insertBeforeElementName = (String)eleStructureList.get(eleIndex);
            for (Node lNode = parentEle.getFirstChild(); lNode != null; lNode = lNode.getNextSibling()) {
                Element lElement;
                if (!(lNode instanceof Element) || !(lElement = (Element)lNode).getNodeName().equals(insertBeforeElementName)) continue;
                insertBeforeNode = lNode;
                break;
            }
            if (insertBeforeNode != null) break;
        }
        parentEle.insertBefore(element, insertBeforeNode);
    }

    protected boolean isValidAttributeToTransfer(String attrName, List attrList) {
        Iterator it = attrList.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(attrName)) continue;
            return true;
        }
        return false;
    }

    protected List getAttributeListForElement(String elementName) {
        String dtdName = null;
        dtdName = "9.1".equals(commonInfoModel.getTargetVersion()) ? "sun-domain_1_3.dtd" : "sun-domain_1_2.dtd";
        String dtdFileName = commonInfoModel.getTargetInstallDir() + File.separator + "lib" + File.separator + "dtds" + File.separator + dtdName;
        return AttributeExtracter.getExtracter(dtdFileName).getAttributeList(elementName);
    }
}

