/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.cluster.IIOPCluster;
import com.sun.enterprise.tools.upgrade.cluster.IIOPEndPoint;
import com.sun.enterprise.tools.upgrade.cluster.IIOPServerInstance;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.common.VersionExtracter;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class UpgradeUtils {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");
    private static Logger logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private static UpgradeUtils upgradeUtils;
    private static CommonInfoModel common;

    private UpgradeUtils(CommonInfoModel common) {
        UpgradeUtils.common = common;
    }

    public static UpgradeUtils getUpgradeUtils(CommonInfoModel cim) {
        if (upgradeUtils == null) {
            upgradeUtils = new UpgradeUtils(cim);
        } else {
            common = cim;
        }
        return upgradeUtils;
    }

    public Hashtable enlistDomains(String domainName, String domainRoot) {
        Hashtable<String, DomainInfo> domainMapping = new Hashtable<String, DomainInfo>();
        String domainPath = domainRoot + File.separator + domainName;
        String sourceDomainRoot = common.getSourceDomainRoot();
        String targetDomainRoot = common.getTargetDomainRoot();
        boolean domainRootSame = new File(sourceDomainRoot).equals(new File(targetDomainRoot));
        String profile = this.getProfileInfoFromSourceInput();
        if (domainRootSame) {
            String latestdomain = this.findLatestDomainDir(sourceDomainRoot, domainName);
            String backupDomainVersion = "";
            String actualDomainVersion = "garbage";
            if (latestdomain != null) {
                backupDomainVersion = new VersionExtracter(latestdomain, common).getVersion();
                String[] directories = new File(common.getSourceDomainRoot()).list();
                String tempDomainName = null;
                for (int j = 0; j < directories.length; ++j) {
                    if (directories[j].equals("backup") || new File(common.getSourceDomainRoot() + File.separator + directories[j]).isFile()) continue;
                    tempDomainName = directories[j];
                    break;
                }
                actualDomainVersion = new VersionExtracter(common.getSourceDomainRoot() + File.separator + domainName, common).getVersion();
            }
            if (!actualDomainVersion.equals(common.getTargetVersion()) && !actualDomainVersion.equals(backupDomainVersion)) {
                String sourceDomainPath;
                block13: {
                    common.setIsInPlace(true);
                    String timestamp = "" + System.currentTimeMillis();
                    String newDomainName = domainName + "_" + timestamp;
                    String backup = common.getTargetDomainRoot() + File.separator + "backup";
                    File backupFile = new File(backup);
                    try {
                        UpgradeUtils.deleteDirectory(backupFile);
                        if (!backupFile.mkdir()) {
                            throw new SecurityException();
                        }
                    }
                    catch (SecurityException se) {
                        logger.log(Level.SEVERE, this.stringManager.getString("upgrade.common.make_directory_failed", (Object)backupFile.getAbsolutePath()));
                        System.exit(1);
                    }
                    File domainDir = new File(domainPath);
                    sourceDomainPath = backup + File.separator + newDomainName;
                    try {
                        UpgradeUtils.copyDirectory(domainDir, new File(sourceDomainPath));
                        if (!UpgradeUtils.deleteDirectory(domainDir)) {
                            throw new SecurityException();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            logger.log(Level.SEVERE, this.stringManager.getString("upgrade.common.copy_directory_failed", (Object)domainDir.getAbsolutePath(), (Object)sourceDomainPath));
                            UpgradeUtils.deleteDirectory(backupFile);
                            System.exit(1);
                        }
                        if (!(e instanceof SecurityException)) break block13;
                        logger.log(Level.WARNING, this.stringManager.getString("upgrade.common.delete_backedup_domain_directory_failed", (Object)domainDir.getAbsolutePath()));
                        System.exit(1);
                    }
                }
                domainMapping.put(domainName, new DomainInfo(domainName, sourceDomainPath, profile));
                common.addDomainName(domainName);
                common.setSourceInstallDir(sourceDomainPath);
                common.getTargetDomainNameMapping().put(domainName, domainName);
            } else {
                String latestDomain = this.findLatestDomainDir(common.getTargetDomainRoot(), domainName);
                domainMapping.put(domainName, new DomainInfo(domainName, latestDomain, profile));
                common.addDomainName(domainName);
                common.setSourceInstallDir(latestDomain);
                common.getTargetDomainNameMapping().put(domainName, domainName);
            }
        } else {
            domainMapping.put(domainName, new DomainInfo(domainName, domainPath, profile));
            common.addDomainName(domainName);
            common.getTargetDomainNameMapping().put(domainName, domainName);
        }
        return domainMapping;
    }

    public String findLatestDomainDir(String domainRoot, String domainName) {
        String backupDirPath = domainRoot + File.separator + "backup";
        File backupDir = new File(backupDirPath);
        String latestDomainPath = null;
        long latestTimestamp = 0L;
        if (backupDir.isDirectory()) {
            String[] dirs = backupDir.list();
            for (int i = 0; i < dirs.length; ++i) {
                long timestamp;
                String time = dirs[i].substring(dirs[i].lastIndexOf("_") + 1);
                if (domainName != null && !dirs[i].startsWith(domainName) || (timestamp = Long.parseLong(time)) <= latestTimestamp) continue;
                latestTimestamp = timestamp;
                latestDomainPath = backupDirPath + File.separator + dirs[i];
            }
        }
        return latestDomainPath;
    }

    public boolean checkSourceInputAsDomain() {
        File domainXML = new File(common.getSourceInstallDir() + File.separator + "config" + File.separator + "domain.xml");
        return domainXML.isFile();
    }

    public boolean checkSourceInputAsDomainRoot(String source) {
        if (source == null) {
            return false;
        }
        File sourceDomain = new File(source);
        File biDir = new File(source + File.separator + "bin");
        if (!biDir.isDirectory() && sourceDomain.isDirectory()) {
            String[] dirs = sourceDomain.list();
            if (dirs.length == 0) {
                common.setSourceDomainRootFlag(false);
                return false;
            }
            if (new File(source + File.separator + "backup").exists()) {
                common.setSourceDomainRootFlag(true);
                return true;
            }
            for (int i = 0; i < dirs.length; ++i) {
                File domainXML = new File(source + File.separator + dirs[i] + File.separator + "config" + File.separator + "domain.xml");
                if (!domainXML.isFile()) continue;
                common.setSourceDomainRootFlag(true);
                return true;
            }
            String domain = "";
            boolean domain70 = false;
            for (int i = 0; i < dirs.length; ++i) {
                if (dirs[i].endsWith("8x") || !new File(source + File.separator + dirs[i]).isDirectory() || !this.isValid70Domain(source + File.separator + dirs[i])) continue;
                domain = dirs[i];
                domain70 = true;
                break;
            }
            if (!domain70) {
                return false;
            }
            File domainDir = new File(source + File.separator + domain);
            String[] serverDirs = domainDir.list();
            String serverInstanceName = "";
            serverInstanceName = serverDirs[0].equals("admin-server") ? serverDirs[1] : serverDirs[0];
            File serverXML = new File(source + File.separator + domain + File.separator + serverInstanceName + File.separator + "config" + File.separator + "server.xml");
            if (serverXML.isFile()) {
                common.setSourceDomainRootFlag(true);
            } else {
                common.setSourceDomainRootFlag(false);
            }
        } else {
            common.setSourceDomainRootFlag(false);
        }
        return common.getSourceDomainRootFlag();
    }

    public boolean isValid70Domain(String domainPath) {
        File domainDir = new File(domainPath);
        boolean domain70 = false;
        String[] serverDirs = domainDir.list();
        String serverInstanceName = "";
        serverInstanceName = serverDirs[0].equals("admin-server") ? serverDirs[1] : serverDirs[0];
        File serverXML = new File(domainPath + File.separator + serverInstanceName + File.separator + "config" + File.separator + "server.xml");
        domain70 = serverXML.isFile();
        return domain70;
    }

    public String versionString(String versionEditionString) {
        if ("as80pe".equals(versionEditionString) || "as80se".equals(versionEditionString) || "as80ee".equals(versionEditionString)) {
            return "80";
        }
        if ("as81pe".equals(versionEditionString) || "as81ee".equals(versionEditionString)) {
            return "81";
        }
        if ("as90pe".equals(versionEditionString) || "as90se".equals(versionEditionString) || "as90ee".equals(versionEditionString)) {
            return "90";
        }
        if (versionEditionString.startsWith("9.1")) {
            return "9.1";
        }
        if ("as82pe".equals(versionEditionString) || "as82se".equals(versionEditionString) || "as82ee".equals(versionEditionString)) {
            return "82";
        }
        return null;
    }

    public String editionString(String versionEditionString) {
        if ("as7xpe".equals(versionEditionString) || "as80pe".equals(versionEditionString) || "as81pe".equals(versionEditionString) || "as82pe".equals(versionEditionString) || "as90pe".equals(versionEditionString)) {
            return "pe";
        }
        if ("as7xse".equals(versionEditionString) || "as80se".equals(versionEditionString) || "as81se".equals(versionEditionString) || "as82se".equals(versionEditionString) || "as90se".equals(versionEditionString)) {
            return "se";
        }
        if ("as7xee".equals(versionEditionString) || "as81ee".equals(versionEditionString) || "as81ee".equals(versionEditionString) || "as90ee".equals(versionEditionString) || "as82ee".equals(versionEditionString)) {
            return "ee";
        }
        if (versionEditionString != null && !UpgradeConstants.isPreAS91Version(versionEditionString)) {
            if (versionEditionString.endsWith("enterprise")) {
                return "enterprise";
            }
            if (versionEditionString.endsWith("cluster")) {
                return "cluster";
            }
            if (versionEditionString.endsWith("developer")) {
                return "developer";
            }
        }
        return null;
    }

    public boolean isValidSourcePath(String sourcePath) {
        if (!new File(sourcePath).exists()) {
            return false;
        }
        File domainXML = null;
        String as7xInstallFileName = "admingui.ear";
        File runtime70Jar = new File(sourcePath + File.separator + "lib" + File.separator + as7xInstallFileName);
        if (runtime70Jar != null && runtime70Jar.exists()) {
            return true;
        }
        domainXML = new File(sourcePath + File.separator + "config" + File.separator + "domain.xml");
        return domainXML.exists() && domainXML.isFile();
    }

    public boolean isValidTargetPath(String targetPath) {
        File targetPathDir = new File(targetPath);
        if (!targetPathDir.exists()) {
            return false;
        }
        File domainXML = new File(targetPath + File.separator + "config" + File.separator + "domain.xml");
        return !domainXML.isFile() || !domainXML.exists();
    }

    public List getStandAloneInstancesFromDomainXml() {
        Hashtable domainsMapping = common.getDomainMapping();
        ArrayList stdAloneList = new ArrayList();
        for (DomainInfo dInfo : domainsMapping.values()) {
            String domainName = dInfo.getDomainName();
            String sourceDomainPath = ((DomainInfo)common.getDomainMapping().get(domainName)).getDomainPath();
            String domainXmlFile = sourceDomainPath + File.separator + "config" + File.separator + "domain.xml";
            Document adminServerDoc = this.getDomainDocumentElement(domainXmlFile);
            try {
                NodeList servers = adminServerDoc.getDocumentElement().getElementsByTagName("servers");
                NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
                for (int lh = 0; lh < serverList.getLength(); ++lh) {
                    Element server = (Element)serverList.item(lh);
                    String instanceName = server.getAttribute("name");
                    String configRef = server.getAttribute("config-ref");
                    if (!(instanceName + "-config").equals(configRef)) continue;
                    Vector<Object> instDInfo = new Vector<Object>();
                    instDInfo.add(instanceName);
                    instDInfo.add(dInfo);
                    stdAloneList.add(instDInfo);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, this.stringManager.getString("upgrade.common.server_instances_from_XML"), ex);
            }
        }
        return stdAloneList;
    }

    public List getStandAloneInstances(Hashtable domainsMapping) {
        ArrayList stdAloneList = new ArrayList();
        for (DomainInfo dInfo : domainsMapping.values()) {
            for (String instName : dInfo.getInstanceNames()) {
                if (this.isInstanceInCluster(instName) || instName.equals("admin-server")) continue;
                Vector<Object> instDInfo = new Vector<Object>();
                instDInfo.add(instName);
                instDInfo.add(dInfo);
                stdAloneList.add(instDInfo);
            }
        }
        return stdAloneList;
    }

    public boolean isInstanceInCluster(String instName) {
        List clList = ClustersInfoManager.getClusterInfoManager().getClusterInfoList();
        if (clList == null) {
            return false;
        }
        for (ClusterInfo clInfo : clList) {
            Iterator instIt = clInfo.getClusteredInstanceList().iterator();
            while (instIt.hasNext()) {
                if (!((ClusteredInstance)instIt.next()).getInstanceName().equals(instName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean switchedIIOPPorts(String serverID, String portValue, Element documentElement) {
        Element configEle = this.getConfigElementFromDocumentElement(documentElement, "server-config");
        NodeList iiopService = configEle.getElementsByTagName("iiop-service");
        NodeList iiopListeners = ((Element)iiopService.item(0)).getElementsByTagName("iiop-listener");
        Element iiopListener = null;
        for (int ii = 0; ii < iiopListeners.getLength(); ++ii) {
            if (!((Element)iiopListeners.item(ii)).getAttribute("id").equals("orb-listener-1")) continue;
            iiopListener = (Element)iiopListeners.item(ii);
            break;
        }
        if (iiopListener != null) {
            String serverIIOPPort = this.getIIOPListenerPortForServer(iiopListener.getAttribute("port"), "server", documentElement);
            if (serverIIOPPort.equals("3700")) {
                String portValueFromServer = this.getIIOPListenerPortForServer(portValue, serverID, documentElement);
                if (portValueFromServer != null) {
                    iiopListener.setAttribute("port", portValueFromServer);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void updateDomainXMLWithIIOPCluster(CommonInfoModel cmnInfo, String domainXMLFile, IIOPCluster iiopCluster) {
        String clusterName = iiopCluster.getClusterName();
        List servInstances = iiopCluster.getIIOPServerInstanceList();
        boolean domainFileChanged = false;
        Document domainDoc = this.getDomainDocumentElement(domainXMLFile);
        for (int servIt = 0; servIt < servInstances.size(); ++servIt) {
            List endPoints = ((IIOPServerInstance)servInstances.get(servIt)).getIIOPEndPoints();
            String serverName = ((IIOPServerInstance)servInstances.get(servIt)).getName();
            int endPt = 0;
            if (endPt >= endPoints.size()) continue;
            IIOPEndPoint iiopEndPoint = (IIOPEndPoint)endPoints.get(endPt);
            if (domainDoc == null) continue;
            String propertyName = "IIOP_LISTENER_PORT";
            String propValue = iiopEndPoint.getPort();
            NodeList servers = domainDoc.getDocumentElement().getElementsByTagName("servers");
            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
            if (propValue.equals("3700")) {
                this.switchedIIOPPorts(serverName, null, domainDoc.getDocumentElement());
            }
            BaseElement baseElement = null;
            try {
                baseElement = ElementToObjectMapper.getMapper().getElementObject(domainDoc.getDocumentElement().getTagName());
            }
            catch (Exception ef) {
                // empty catch block
            }
            this.addOrUpdateSystemPropertyToServer(serverName, serverList, propertyName, propValue, baseElement);
            domainFileChanged = true;
        }
        if (domainFileChanged && domainDoc != null) {
            this.saveDocumentToDomainFile(domainXMLFile, domainDoc);
        }
    }

    public void updateClusteredInstanceList(String domainXMLFile, String domainName, String clusterName, List clusteredInstanceList) {
        NodeList serverList;
        NodeList servers;
        DomainInfo dInfo = (DomainInfo)common.getDomainMapping().get(domainName);
        String domainPath = dInfo.getDomainPath();
        String userName = common.getAdminUserName();
        DomainsProcessor dProcessor = new DomainsProcessor(common);
        String adminPort = DomainsProcessor.getSourceAdminPort(domainPath);
        Document domainDoc = this.getDomainDocumentElement(domainXMLFile);
        if (domainDoc != null && (servers = domainDoc.getDocumentElement().getElementsByTagName("servers")) != null && (serverList = ((Element)servers.item(0)).getElementsByTagName("server")) != null && serverList.getLength() > 0) {
            for (int lh = 0; lh < serverList.getLength(); ++lh) {
                Element server = (Element)serverList.item(lh);
                String configRefName = server.getAttribute("config-ref");
                if (!(clusterName + "-config").equals(configRefName)) continue;
                String instanceName = server.getAttribute("name");
                String nodeAgentName = server.getAttribute("node-agent-ref");
                ClusteredInstance clInstance = new ClusteredInstance(instanceName);
                clInstance.setHost(nodeAgentName);
                clInstance.setDomain(domainName);
                clInstance.setUser(userName);
                clInstance.setPort(adminPort);
                clusteredInstanceList.add(clInstance);
            }
        }
    }

    public void updateClusterList(String domainXMLFile, String domainName, List clusterInfoList) {
        NodeList clusterList;
        NodeList clusters;
        Document domainDoc = this.getDomainDocumentElement(domainXMLFile);
        if (domainDoc != null && (clusters = domainDoc.getDocumentElement().getElementsByTagName("clusters")) != null && (clusterList = ((Element)clusters.item(0)).getElementsByTagName("cluster")) != null && clusterList.getLength() > 0) {
            for (int lh = 0; lh < clusterList.getLength(); ++lh) {
                String clName = ((Element)clusterList.item(lh)).getAttribute("name");
                ClusterInfo clInfo = new ClusterInfo();
                clInfo.setClusterName(clName);
                clInfo.setDomainName(domainName);
                clInfo.updateClusteredInstanceList(domainXMLFile, domainName, clName, this);
                clusterInfoList.add(clInfo);
            }
        }
    }

    public void recover() {
        List domainList = common.getDomainList();
        String sourceDir = common.getSourceDomainRoot();
        String targetDir = common.getTargetDomainRoot();
        if (domainList != null && sourceDir != null && targetDir != null) {
            for (String dname : domainList) {
                boolean domainRootSame = new File(sourceDir).equals(new File(targetDir));
                if (!domainRootSame || !new File(sourceDir + File.separator + "backup").isDirectory()) continue;
                common.setCurrentDomain(dname);
                String latestDomainPath = common.findLatestDomainDir(sourceDir);
                if (latestDomainPath == null) continue;
                try {
                    UpgradeUtils.copyDirectory(new File(latestDomainPath), new File(sourceDir + File.separator + dname));
                    File backupdir = new File(sourceDir + File.separator + "backup");
                    if (UpgradeUtils.deleteDirectory(backupdir)) continue;
                    logger.log(Level.WARNING, this.stringManager.getString("upgrade.common.delete_directory_failed", (Object)backupdir.getAbsolutePath()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, this.stringManager.getString("upgrade.common.copy_directory_failed", (Object)latestDomainPath, (Object)sourceDir));
                }
            }
        }
    }

    public boolean validateUserDetails(String adminUserName, String adminPassword, String masterPassword) {
        try {
            if ("as80pe".equals(common.getSourceVersionAndEdition())) {
                return true;
            }
            RepositoryManager rManager = new RepositoryManager();
            String domainName = "domain1";
            String newDomainName = null;
            String newDomainPath = null;
            List domainList = common.getDomainList();
            Iterator itr = domainList.iterator();
            Hashtable domainMapping = common.getDomainMapping();
            String domainPath = null;
            String sourceInstallDir = common.getSourceInstallDir();
            String targetInstallDir = common.getTargetInstallDir();
            while (itr.hasNext()) {
                domainName = (String)itr.next();
            }
            if (domainMapping != null) {
                domainPath = ((DomainInfo)domainMapping.get(domainName)).getDomainPath();
            }
            if (sourceInstallDir == null) {
                return true;
            }
            if (domainPath != null) {
                newDomainName = domainPath.substring(domainPath.lastIndexOf(File.separator) + 1);
                newDomainPath = domainPath.substring(0, domainPath.lastIndexOf(File.separator));
            }
            RepositoryConfig repConf = new RepositoryConfig(newDomainName, newDomainPath);
            rManager.validateAdminUserAndPassword(repConf, adminUserName, adminPassword);
            if (masterPassword != null) {
                rManager.validateMasterPassword(repConf, masterPassword);
            }
        }
        catch (RepositoryException re) {
            logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.generalException", (Object)re.getMessage()), re);
            return false;
        }
        return true;
    }

    public void updateDomainXMLWithPersistenceStoreProps(Properties props) {
    }

    public void updateListenerPortsForClusteredInstances(Element docElement, String propertyName, String portValue, BaseElement bElement) {
        NodeList servers = docElement.getElementsByTagName("servers");
        NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
        String clusterName = common.getCurrentCluster();
        for (ClusterInfo cInfo : ClustersInfoManager.getClusterInfoManager().getClusterInfoList()) {
            if (!cInfo.getClusterName().equals(clusterName)) continue;
            for (ClusteredInstance clInstance : cInfo.getClusteredInstanceList()) {
                if (portValue == null) {
                    this.addOrUpdateSystemPropertyToServer(clInstance.getInstanceName(), serverList, propertyName, clInstance.getInstancePort(), bElement);
                    continue;
                }
                this.addOrUpdateSystemPropertyToServer(clInstance.getInstanceName(), serverList, propertyName, portValue, bElement);
            }
        }
    }

    public void addOrUpdateSystemPropertyToServer(String serverName, NodeList serverList, String propertyName, String propertyValue, BaseElement bElement) {
        for (int lh = 0; lh < serverList.getLength(); ++lh) {
            if (!serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))) continue;
            Element serverElement = (Element)serverList.item(lh);
            Element sysProp = this.getSystemPropertyElement(propertyName, serverElement);
            if (sysProp != null) {
                sysProp.setAttribute("value", propertyValue);
                return;
            }
            if (sysProp == null && bElement != null) {
                sysProp = serverElement.getOwnerDocument().createElement("system-property");
                sysProp.setAttribute("name", propertyName);
                sysProp.setAttribute("value", propertyValue);
                bElement.appendElementToParent(serverElement, sysProp);
            }
            return;
        }
    }

    public static void copyFile(String source, String target) throws IOException {
        FileUtils.copy((String)source, (String)target);
    }

    public String getJvmOptionValueFromSourceConfig(String optionName) {
        String sourceConfig = common.getSourceConfigXMLFile();
        Document sourceDoc = this.getDomainDocumentElement(common.getSourceConfigXMLFile());
        NodeList serverList = sourceDoc.getElementsByTagName("server");
        String serverName = common.getCurrentSourceInstance();
        if (serverName == null || serverName == "") {
            serverName = "server";
        }
        String configName = null;
        String password = null;
        for (int i = 0; i < serverList.getLength(); ++i) {
            Node serverNode = serverList.item(i);
            NamedNodeMap attributes = serverNode.getAttributes();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (!serverName.equals(name)) continue;
            configName = attributes.getNamedItem("config-ref").getNodeValue();
        }
        if (configName != null) {
            NodeList jvmOptionList = sourceDoc.getElementsByTagName("jvm-options");
            for (int j = 0; j < jvmOptionList.getLength(); ++j) {
                Node jvmNode = jvmOptionList.item(j);
                String jvmOptions = this.getTextNodeData((Element)jvmNode);
                if (jvmOptions.indexOf(optionName) == -1) continue;
                password = jvmOptions.substring(jvmOptions.indexOf("=") + 1, jvmOptions.length());
            }
        } else {
            logger.warning(this.stringManager.getString("upgrade.common.config_not_found", configName));
        }
        return password;
    }

    public String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return "";
    }

    public static void copyDirectory(File sourceDir, File targetDir) throws IOException {
        File[] srcFiles = sourceDir.listFiles();
        if (srcFiles != null) {
            for (int i = 0; i < srcFiles.length; ++i) {
                File dest = new File(targetDir, srcFiles[i].getName());
                if (srcFiles[i].isDirectory() && FileUtils.safeIsRealDirectory((File)srcFiles[i])) {
                    if (!dest.exists()) {
                        dest.mkdirs();
                    }
                    UpgradeUtils.copyDirectory(srcFiles[i], dest);
                    continue;
                }
                if (!dest.exists()) {
                    dest.createNewFile();
                }
                UpgradeUtils.copyFile(srcFiles[i].getAbsolutePath(), new File(targetDir, srcFiles[i].getName()).getAbsolutePath());
            }
        }
    }

    public ArrayList buildAppDeploymentParameters(String moduleName) {
        ArrayList<String> appDeploymentParameters = null;
        String appEnabledStatus = null;
        String appVirtualServers = null;
        String sourceConfig = common.getSourceConfigXMLFile();
        Document sourceDoc = this.getDomainDocumentElement(common.getSourceConfigXMLFile());
        NodeList appRefList = sourceDoc.getDocumentElement().getElementsByTagName("application-ref");
        for (int i = 0; i < appRefList.getLength(); ++i) {
            Element element = (Element)appRefList.item(i);
            if (null == element || !element.getAttribute("ref").equals(moduleName)) continue;
            appEnabledStatus = element.getAttribute("enabled");
            appVirtualServers = element.getAttribute("virtual-servers");
        }
        if (appEnabledStatus != null || appVirtualServers != null) {
            appDeploymentParameters = new ArrayList<String>();
        }
        if (appEnabledStatus != null) {
            appDeploymentParameters.add("--enabled=" + appEnabledStatus);
        }
        if (appVirtualServers != null && !appVirtualServers.equals("")) {
            appDeploymentParameters.add("--virtualservers");
            appDeploymentParameters.add(appVirtualServers);
        }
        return appDeploymentParameters;
    }

    public String buildWebModuleContextRoot(String moduleName) {
        String webModuleContextRoot = null;
        String actualModName = moduleName;
        if (common.getSourceVersion().equals("7x")) {
            actualModName = moduleName.lastIndexOf("_1") != -1 ? moduleName.substring(0, moduleName.lastIndexOf("_1")) : moduleName;
        }
        String sourceConfig = common.getSourceConfigXMLFile();
        Document sourceDoc = this.getDomainDocumentElement(common.getSourceConfigXMLFile());
        NodeList webModuleList = sourceDoc.getDocumentElement().getElementsByTagName("web-module");
        for (int i = 0; i < webModuleList.getLength(); ++i) {
            Element element = (Element)webModuleList.item(i);
            if (null == element || !element.getAttribute("name").equals(actualModName)) continue;
            webModuleContextRoot = element.getAttribute("context-root");
        }
        return webModuleContextRoot;
    }

    public String getSourceApplicationRootDir() {
        String applicationRootDir = "applications";
        String applicationRoot = common.getSourceApplicationRoot();
        if (applicationRoot != null) {
            applicationRoot = applicationRoot.replaceAll("/", "\\" + File.separator);
            String[] aryApplRoot = applicationRoot.split("\\" + File.separator);
            int indexApplRoot = aryApplRoot.length - 1;
            applicationRootDir = aryApplRoot[indexApplRoot];
        }
        return applicationRootDir;
    }

    public String buildAppDeploymentTarget(String moduleName) {
        NodeList serverList;
        Element serversEle;
        NodeList clusterList;
        Element clustersEle;
        String appTarget = null;
        String actualModName = moduleName;
        String sourceConfig = common.getSourceConfigXMLFile();
        Document sourceDoc = this.getDomainDocumentElement(common.getSourceConfigXMLFile());
        Element sourceDocumentElement = sourceDoc.getDocumentElement();
        NodeList clusters = sourceDocumentElement.getElementsByTagName("clusters");
        if (clusters != null && (clustersEle = (Element)clusters.item(0)) != null && (clusterList = clustersEle.getElementsByTagName("cluster")) != null) {
            block0: for (int k = 0; k < clusterList.getLength(); ++k) {
                Element cluster = (Element)clusterList.item(k);
                String clusterName = cluster.getAttribute("name");
                NodeList clusterAppRefs = cluster.getElementsByTagName("application-ref");
                for (int j = 0; j < clusterAppRefs.getLength(); ++j) {
                    Element clusterAppRef = (Element)clusterAppRefs.item(j);
                    String appRef = clusterAppRef.getAttribute("ref");
                    if (!actualModName.equals(appRef)) continue;
                    appTarget = clusterName;
                    continue block0;
                }
            }
        }
        if (appTarget != null) {
            return appTarget;
        }
        NodeList servers = sourceDocumentElement.getElementsByTagName("servers");
        if (servers != null && (serversEle = (Element)servers.item(0)) != null && (serverList = serversEle.getElementsByTagName("server")) != null) {
            block2: for (int lh = 0; lh < serverList.getLength(); ++lh) {
                Element server = (Element)serverList.item(lh);
                String instanceName = server.getAttribute("name");
                String configRef = server.getAttribute("config-ref");
                if (!(instanceName + "-config").equals(configRef)) continue;
                NodeList applicationRefList = server.getElementsByTagName("application-ref");
                for (int i = 0; i < applicationRefList.getLength(); ++i) {
                    Element applicationRef = (Element)applicationRefList.item(i);
                    String ref = applicationRef.getAttribute("ref");
                    if (!actualModName.equals(ref) || "server".equals(instanceName)) continue;
                    appTarget = instanceName;
                    continue block2;
                }
            }
        }
        return appTarget;
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] subDirs = dir.list();
            for (int i = 0; i < subDirs.length; ++i) {
                boolean success = UpgradeUtils.deleteDirectory(new File(dir, subDirs[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public String getProfileInfoFromSourceInput() {
        String sourceEdition = common.getSourceEdition();
        sourceEdition = common.isPlatformEdition(sourceEdition) ? ("cluster".equals(sourceEdition) ? "cluster" : "developer") : (common.isEnterpriseEdition(sourceEdition) ? "enterprise" : "developer");
        return sourceEdition;
    }

    private Element getConfigElementFromDocumentElement(Element documentElement, String lookUpConfigName) {
        NodeList configEles = documentElement.getElementsByTagName("config");
        Element configEle = null;
        for (int lh = 0; lh < configEles.getLength(); ++lh) {
            String configName = ((Element)configEles.item(lh)).getAttribute("name");
            if (!configName.equals(lookUpConfigName)) continue;
            configEle = (Element)configEles.item(lh);
            break;
        }
        return configEle;
    }

    private String getIIOPListenerPortForServer(String portValue, String serverName, Element documentElement) {
        try {
            if (portValue != null) {
                int portIntValue = Integer.parseInt(portValue);
                return String.valueOf(portIntValue);
            }
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        NodeList servers = documentElement.getElementsByTagName("servers");
        NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
        Object portValueFromServer = null;
        for (int lh = 0; lh < serverList.getLength(); ++lh) {
            if (!serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))) continue;
            Element serverElement = (Element)serverList.item(lh);
            Element sysProp = this.getSystemPropertyElement("IIOP_LISTENER_PORT", serverElement);
            if (sysProp != null) {
                return sysProp.getAttribute("value");
            }
            Element configElement = this.getConfigElementFromDocumentElement(documentElement, serverElement.getAttribute("config-ref"));
            if (configElement == null || (sysProp = this.getSystemPropertyElement("IIOP_LISTENER_PORT", configElement)) == null) continue;
            return sysProp.getAttribute("value");
        }
        return null;
    }

    private Element getSystemPropertyElement(String propertyName, Element parentForSysProp) {
        NodeList sysProps = parentForSysProp.getElementsByTagName("system-property");
        for (int sh = 0; sh < sysProps.getLength(); ++sh) {
            if (!propertyName.equals(((Element)sysProps.item(sh)).getAttribute("name"))) continue;
            return (Element)sysProps.item(sh);
        }
        return null;
    }

    public Document getDomainDocumentElement(String domainFileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document resultDoc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            resultDoc = builder.parse(new File(domainFileName));
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, this.stringManager.getString("upgrade.common.iiop_port_domain_doc"), ex);
        }
        return resultDoc;
    }

    private void saveDocumentToDomainFile(String domainFileName, Document resultDoc) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(domainFileName));
            transformer.transform(source, result);
            result.getOutputStream().close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, this.stringManager.getString("upgrade.common.iiop_port_domain_save_fail"), ex);
        }
    }

    public static boolean deleteFile(String targetMasterPasswordFile) {
        File masterPasswordFile = new File(targetMasterPasswordFile);
        return masterPasswordFile.delete();
    }
}

