/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server;

import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleModule;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.server.ServerContext;
import com.sun.web.security.RealmAdapter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleModuleService
implements ServerLifecycle {
    private OneTimeIniter mOneTimeIniter;
    private OneTimeStartup mOneTimeStartup;
    private final AMXDebugHelper mDebug = new AMXDebugHelper("LifecycleModuleService");
    private static final String SUBMIT_TYPE_SPROP = "LifecycleModuleService.submitType";
    private static final String SUBMIT_TYPE = System.getProperty("LifecycleModuleService.submitType");
    private final List<ServerLifecycleModule> mLifecycleModules = new ArrayList<ServerLifecycleModule>();

    private void debug(Object ... args) {
        this.mDebug.println(args);
    }

    private static boolean isMultiCore() {
        return Runtime.getRuntime().availableProcessors() >= 2;
    }

    private RunnableBase.HowToRun getSubmitType() {
        RunnableBase.HowToRun submitType = RunnableBase.HowToRun.RUN_INVALID;
        submitType = "async".equals(SUBMIT_TYPE) ? RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD : ("sync".equals(SUBMIT_TYPE) ? RunnableBase.HowToRun.RUN_IN_CURRENT_THREAD : (LifecycleModuleService.isMultiCore() ? RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD : RunnableBase.HowToRun.RUN_IN_CURRENT_THREAD));
        this.debug(new Object[]{"SUBMIT_TYPE: ", SUBMIT_TYPE, " => ", submitType});
        return submitType;
    }

    private List<Set<ServerLifecycleModule>> groupByLoadOrder(List<ServerLifecycleModule> lifecycleModules) {
        ArrayList<Set<ServerLifecycleModule>> sets = new ArrayList<Set<ServerLifecycleModule>>();
        int curOrder = Integer.MIN_VALUE;
        HashSet<ServerLifecycleModule> curSet = null;
        for (ServerLifecycleModule next : lifecycleModules) {
            int order = next.getLoadOrder();
            if (order < curOrder) {
                throw new IllegalStateException();
            }
            if (curSet == null || curOrder != order) {
                curSet = new HashSet<ServerLifecycleModule>();
                sets.add(curSet);
            }
            curSet.add(next);
            curOrder = order;
        }
        return sets;
    }

    private void sortModules(Set<ServerLifecycleModule> listenerSet) {
        for (ServerLifecycleModule next : listenerSet) {
            int i;
            int order = next.getLoadOrder();
            for (i = 0; i < this.mLifecycleModules.size() && this.mLifecycleModules.get(i).getLoadOrder() <= order; ++i) {
            }
            this.mLifecycleModules.add(i, next);
        }
    }

    private LifecycleModuleCaller createCaller(ServerContext serverContext, ServerLifecycleModule lifecycleModule, String methodName) {
        LifecycleModuleCaller caller = null;
        if (methodName.equals("onInitialization")) {
            caller = new onInitializationCaller(serverContext, lifecycleModule);
        } else if (methodName.equals("onStartup")) {
            caller = new onStartupCaller(serverContext, lifecycleModule);
        } else if (methodName.equals("onReady")) {
            caller = new onReadyCaller(serverContext, lifecycleModule);
        } else {
            throw new IllegalArgumentException(methodName);
        }
        return caller;
    }

    private void callAllModules(ServerContext serverContext, String methodName) throws ServerLifecycleException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<Set<ServerLifecycleModule>> sets = this.groupByLoadOrder(this.mLifecycleModules);
        for (Set<ServerLifecycleModule> itemsOfSameLoadOrder : sets) {
            int idx;
            int numModules = itemsOfSameLoadOrder.size();
            ServerLifecycleModule[] modules = new ServerLifecycleModule[numModules];
            itemsOfSameLoadOrder.toArray(modules);
            LifecycleModuleCaller[] callers = new LifecycleModuleCaller[numModules];
            for (int i = 0; i < numModules; ++i) {
                callers[i] = this.createCaller(serverContext, modules[i], methodName);
                boolean isLast = i + 1 == numModules;
                RunnableBase.HowToRun submitType = isLast ? RunnableBase.HowToRun.RUN_IN_CURRENT_THREAD : this.getSubmitType();
                callers[i].submit(submitType);
            }
            for (idx = 0; idx < callers.length; ++idx) {
                callers[idx].waitDone();
                this.debug("Millis for " + callers[idx].getName() + ": " + callers[idx].getNanosFromSubmit() / 1000000L);
            }
            for (idx = 0; idx < callers.length; ++idx) {
                callers[idx].waitDoneThrow();
            }
        }
        this.resetClassLoader(cl);
    }

    private void initialize(ServerContext serverContext) throws ServerLifecycleException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.callAllModules(serverContext, "onInitialization");
        this.resetClassLoader(cl);
    }

    @Override
    public void onInitialization(ServerContext context) throws ServerLifecycleException {
        this.mOneTimeIniter = new OneTimeIniter(context);
        this.mOneTimeIniter.submit(this.getSubmitType());
    }

    private boolean isEnabled(LifecycleModule lcm, ConfigContext config) {
        try {
            if (lcm == null || config == null) {
                return false;
            }
            Server server = ServerBeansFactory.getServerBean((ConfigContext)config);
            ApplicationRef appRef = server.getApplicationRefByRef(lcm.getName());
            return lcm.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            return false;
        }
    }

    private void resetClassLoader(final ClassLoader c) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(c);
                return null;
            }
        });
    }

    @Override
    public void onStartup(ServerContext context) throws ServerLifecycleException {
        this.mOneTimeIniter.waitDoneThrow();
        this.mOneTimeIniter = null;
        this.mOneTimeStartup = new OneTimeStartup(context);
        this.mOneTimeStartup.submit(this.getSubmitType());
    }

    @Override
    public void onReady(ServerContext serverContext) throws ServerLifecycleException {
        this.mOneTimeStartup.waitDoneThrow();
        this.mOneTimeStartup = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.callAllModules(serverContext, "onReady");
        this.resetClassLoader(cl);
        assert (this.mOneTimeStartup == null);
    }

    @Override
    public void onShutdown() throws ServerLifecycleException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.mLifecycleModules) {
            next.onShutdown();
        }
        this.resetClassLoader(cl);
    }

    @Override
    public void onTermination() throws ServerLifecycleException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.mLifecycleModules) {
            next.onTermination();
        }
        this.resetClassLoader(cl);
    }

    private final class OneTimeStartup
    extends RunnableBase {
        private final ServerContext mServerContext;

        public OneTimeStartup(ServerContext serverContext) {
            this.mServerContext = serverContext;
        }

        protected void doRun() throws ServerLifecycleException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            LifecycleModuleService.this.callAllModules(this.mServerContext, "onStartup");
            LifecycleModuleService.this.resetClassLoader(cl);
        }
    }

    private final class onReadyCaller
    extends LifecycleModuleCaller {
        public onReadyCaller(ServerContext serverContext, ServerLifecycleModule lifecycleModule) {
            super("onReady", serverContext, lifecycleModule);
        }

        protected void doRun() throws ServerLifecycleException {
            this.mLifecycleModule.onReady(this.mServerContext);
        }
    }

    private final class onStartupCaller
    extends LifecycleModuleCaller {
        public onStartupCaller(ServerContext serverContext, ServerLifecycleModule lifecycleModule) {
            super("onStartup", serverContext, lifecycleModule);
        }

        protected void doRun() throws ServerLifecycleException {
            StandardContext invocationContext = new StandardContext();
            WebBundleDescriptor wbd = new WebBundleDescriptor();
            Application.createApplication((String)this.mLifecycleModule.getName(), (ModuleDescriptor)wbd.getModuleDescriptor());
            invocationContext.setRealm((Realm)new RealmAdapter(wbd, false));
            this.mLifecycleModule.onStartup(this.mServerContext, (Context)invocationContext);
        }
    }

    private final class onInitializationCaller
    extends LifecycleModuleCaller {
        public onInitializationCaller(ServerContext serverContext, ServerLifecycleModule lifecycleModule) {
            super("onInitialization", serverContext, lifecycleModule);
        }

        protected void doRun() throws ServerLifecycleException {
            this.mLifecycleModule.onInitialization(this.mServerContext);
        }
    }

    private abstract class LifecycleModuleCaller
    extends RunnableBase {
        protected final ServerLifecycleModule mLifecycleModule;
        protected final ServerContext mServerContext;

        public LifecycleModuleCaller(String methodName, ServerContext serverContext, ServerLifecycleModule lifecycleModule) {
            super(lifecycleModule.getName() + "." + methodName + "()");
            this.mServerContext = serverContext;
            this.mLifecycleModule = lifecycleModule;
        }

        protected abstract void doRun() throws ServerLifecycleException;
    }

    private final class OneTimeIniter
    extends RunnableBase {
        private final ServerContext mServerContext;

        public OneTimeIniter(ServerContext serverContext) {
            this.mServerContext = serverContext;
        }

        protected void doRun() throws ConfigException, ServerLifecycleException {
            Applications apps = ServerBeansFactory.getApplicationsBean((ConfigContext)this.mServerContext.getConfigContext());
            if (apps == null) {
                return;
            }
            LifecycleModule[] lcms = apps.getLifecycleModule();
            if (lcms == null) {
                return;
            }
            HashSet<ServerLifecycleModule> listenerSet = new HashSet<ServerLifecycleModule>();
            for (int i = 0; i < lcms.length; ++i) {
                LifecycleModule next = lcms[i];
                if (!LifecycleModuleService.this.isEnabled(next, this.mServerContext.getConfigContext())) continue;
                int order = Integer.MAX_VALUE;
                String strOrder = next.getLoadOrder();
                if (strOrder != null) {
                    try {
                        order = Integer.parseInt(strOrder);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                ServerLifecycleModule slcm = new ServerLifecycleModule(this.mServerContext, next.getName(), next.getClassName());
                slcm.setLoadOrder(order);
                slcm.setClasspath(next.getClasspath());
                slcm.setIsFatal(next.isIsFailureFatal());
                ElementProperty[] s = next.getElementProperty();
                if (s != null) {
                    for (int j = 0; j < s.length; ++j) {
                        ElementProperty next1 = s[j];
                        slcm.setProperty(next1.getName(), next1.getValue());
                    }
                }
                LifecycleListener listener = slcm.loadServerLifecycle();
                listenerSet.add(slcm);
            }
            LifecycleModuleService.this.sortModules(listenerSet);
            LifecycleModuleService.this.initialize(this.mServerContext);
        }
    }
}

