/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.ext.logging;

import com.sun.appserv.management.ext.logging.LogQueryEntry;
import com.sun.appserv.management.ext.logging.LogQueryEntryImpl;
import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogQueryResultImpl
implements LogQueryResult {
    private String[] mFieldNames;
    private LogQueryEntry[] mEntries;
    private static final String FIELD_DELIM = "\t";
    private static final String NEWLINE = System.getProperty("line.separator");

    public LogQueryResultImpl(String[] fieldNames, LogQueryEntry[] entries) {
        this.mFieldNames = fieldNames;
        this.mEntries = entries;
    }

    public LogQueryResultImpl(List<Serializable[]> records) {
        this.mFieldNames = (String[])records.get(0);
        this.mEntries = new LogQueryEntry[records.size() - 1];
        for (int i = 1; i < this.mEntries.length; ++i) {
            this.mEntries[i] = new LogQueryEntryImpl(records.get(i));
        }
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldNames;
    }

    @Override
    public LogQueryEntry[] getEntries() {
        return this.mEntries;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.getFieldNames()) {
            builder.append(s);
            builder.append(FIELD_DELIM);
        }
        builder.replace(builder.length() - 1, builder.length(), NEWLINE);
        for (LogQueryEntry entry : this.getEntries()) {
            Object[] fields;
            for (Object o : fields = entry.getFields()) {
                builder.append(o.toString());
                builder.append(FIELD_DELIM);
            }
            builder.replace(builder.length() - 1, builder.length(), NEWLINE);
        }
        return builder.toString();
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.getFieldNames(), this.getEntries());
    }

    public boolean equals(Object rhs) {
        boolean equal = rhs instanceof LogQueryResult;
        if (equal) {
            LogQueryResult r = (LogQueryResult)rhs;
            equal = ArrayUtil.arraysEqual(this.getFieldNames(), r.getFieldNames()) && ArrayUtil.arraysEqual(this.getEntries(), r.getEntries());
        }
        return equal;
    }
}

