/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.util;

import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.SecretKey;

public abstract class XWSSUtil {
    public static X509Certificate getCertificateFromTrustStore(byte[] ski, KeyStore trustStore) throws IOException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                String alias = aliases.nextElement();
                Certificate cert = trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(ski, keyId)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static X509Certificate getCertificateFromTrustStore(String issuerName, BigInteger serialNumber, KeyStore trustStore) throws IOException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = trustStore.getCertificate(alias);
                if (cert == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return x509Cert;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static PrivateKey getPrivateKey(byte[] ski, KeyStore keyStore, String keyStorePassword) throws IOException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                byte[] keyId;
                Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (cert = keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType()) || (keyId = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(x509Cert = (X509Certificate)cert)) == null || !Arrays.equals(ski, keyId)) continue;
                return (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String issuerName, BigInteger serialNumber, KeyStore keyStore, String keyStorePassword) throws IOException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (cert = keyStore.getCertificate(alias)) == null || !"X.509".equals(cert.getType())) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                String thisIssuerName = RFC2253Parser.normalize(x509Cert.getIssuerDN().getName());
                BigInteger thisSerialNumber = x509Cert.getSerialNumber();
                if (!thisIssuerName.equals(issuerName) || !thisSerialNumber.equals(serialNumber)) continue;
                return (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static PrivateKey getPrivateKey(X509Certificate certificate, KeyStore keyStore, String keyStorePassword) throws IOException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias) || (cert = keyStore.getCertificate(alias)) == null || !cert.equals(certificate)) continue;
                return (PrivateKey)keyStore.getKey(alias, keyStorePassword.toCharArray());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public static SecretKey generateSymmetricKey(String algorithm) throws XWSSecurityException {
        return SecurityUtil.generateSymmetricKey(algorithm);
    }
}

