/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.enc;

import com.sun.xml.ws.security.opt.api.EncryptedKey;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.api.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.DerivedKeyTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.IssuedTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SCTBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SamlTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.keyinfo.SymmetricTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.X509TokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.WSSElementFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.crypto.LogStringsMessages;
import java.security.Key;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TokenProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.crypto", "com.sun.xml.wss.logging.impl.opt.crypto.LogStrings");
    private Key dataEncKey = null;
    private Key dkEncKey = null;
    private WSSElementFactory elementFactory = null;
    private WSSPolicy keyBinding = null;
    private JAXBFilterProcessingContext context = null;
    private EncryptionPolicy ep = null;
    private TokenBuilder builder = null;
    private EncryptedKey ek = null;
    private KeyInfo keyInfo = null;

    public TokenProcessor(EncryptionPolicy ep, JAXBFilterProcessingContext context) {
        this.context = context;
        this.ep = ep;
        this.keyBinding = (WSSPolicy)ep.getKeyBinding();
        this.elementFactory = new WSSElementFactory(context.getSOAPVersion());
    }

    public Key getDataEncKey() {
        return this.dataEncKey;
    }

    public Key getKeyEncKey() {
        return this.dkEncKey;
    }

    public EncryptedKey getEncryptedKey() {
        return this.ek;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public BuilderResult process() throws XWSSecurityException {
        String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        String dataEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        EncryptionPolicy.FeatureBinding featureBinding = (EncryptionPolicy.FeatureBinding)this.ep.getFeatureBinding();
        String tmp = featureBinding.getDataEncryptionAlgorithm();
        if (tmp == null || "".equals(tmp)) {
            if (this.context.getAlgorithmSuite() != null) {
                tmp = this.context.getAlgorithmSuite().getEncryptionAlgorithm();
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, LogStringsMessages.WSS_1950_DATAENCRYPTION_ALGORITHM_NOTSET());
            }
        }
        if (tmp != null && !"".equals(tmp)) {
            dataEncAlgo = tmp;
        }
        if (this.context.getAlgorithmSuite() != null) {
            keyEncAlgo = this.context.getAlgorithmSuite().getAsymmetricKeyAlgorithm();
        }
        if (PolicyTypeUtil.usernameTokenPolicy(this.keyBinding)) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1902_UNSUPPORTED_USERNAMETOKEN_KEYBINDING());
            throw new XWSSecurityException("UsernameToken as KeyBinding for EncryptionPolicy is Not Yet Supported");
        }
        if (PolicyTypeUtil.x509CertificateBinding(this.keyBinding)) {
            AuthenticationTokenPolicy.X509CertificateBinding certificateBinding = null;
            if (this.context.getX509CertificateBinding() != null) {
                certificateBinding = this.context.getX509CertificateBinding();
                this.context.setX509CertificateBinding(null);
            } else {
                certificateBinding = (AuthenticationTokenPolicy.X509CertificateBinding)this.keyBinding;
            }
            String x509TokenId = certificateBinding.getUUID();
            if (x509TokenId == null || x509TokenId.equals("")) {
                x509TokenId = this.context.generateID();
            }
            this.builder = new X509TokenBuilder(this.context, certificateBinding);
            BuilderResult xtbResult = this.builder.process();
            KeyInfo ekKI = xtbResult.getKeyInfo();
            tmp = null;
            tmp = certificateBinding.getKeyAlgorithm();
            if (tmp != null && !tmp.equals("")) {
                keyEncAlgo = tmp;
            }
            this.dataEncKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
            this.dkEncKey = certificateBinding.getX509Certificate().getPublicKey();
            String ekId = this.context.generateID();
            this.ek = this.elementFactory.createEncryptedKey(ekId, keyEncAlgo, ekKI, this.dkEncKey, this.dataEncKey);
            this.context.getSecurityHeader().add((SecurityHeaderElement)((Object)this.ek));
            xtbResult.setKeyInfo(null);
            DirectReference dr = this.elementFactory.createDirectReference();
            dr.setURI("#" + ekId);
            boolean wss11Sender = "true".equals(this.context.getExtraneousProperty("EnableWSS11PolicySender"));
            if (wss11Sender) {
                dr.setValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            }
            SecurityTokenReference str = this.elementFactory.createSecurityTokenReference(dr);
            this.keyInfo = this.elementFactory.createKeyInfo(str);
            xtbResult.setKeyInfo(this.keyInfo);
            xtbResult.setEncryptedKey(this.ek);
            xtbResult.setDataProtectionKey(this.dataEncKey);
            xtbResult.setKeyProtectionKey(this.dkEncKey);
            return xtbResult;
        }
        if (PolicyTypeUtil.symmetricKeyBinding(this.keyBinding)) {
            SymmetricKeyBinding skb = null;
            if (this.context.getSymmetricKeyBinding() != null) {
                skb = this.context.getSymmetricKeyBinding();
                this.context.setSymmetricKeyBinding(null);
            } else {
                skb = (SymmetricKeyBinding)this.keyBinding;
            }
            this.builder = new SymmetricTokenBuilder(skb, this.context, dataEncAlgo, keyEncAlgo);
            BuilderResult skbResult = this.builder.process();
            this.dataEncKey = skbResult.getDataProtectionKey();
            this.keyInfo = skbResult.getKeyInfo();
            return skbResult;
        }
        if (PolicyTypeUtil.derivedTokenKeyBinding(this.keyBinding)) {
            DerivedTokenKeyBinding dtk = (DerivedTokenKeyBinding)this.keyBinding;
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSCNS();
            this.builder = new DerivedKeyTokenBuilder(this.context, dtk);
            BuilderResult dtkResult = this.builder.process();
            return dtkResult;
        }
        if (PolicyTypeUtil.secureConversationTokenKeyBinding(this.keyBinding)) {
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSCNS();
            SCTBuilder builder = new SCTBuilder(this.context, (SecureConversationTokenKeyBinding)this.keyBinding);
            BuilderResult sctResult = builder.process();
            return sctResult;
        }
        if (PolicyTypeUtil.issuedTokenKeyBinding(this.keyBinding)) {
            IssuedTokenBuilder itb = new IssuedTokenBuilder(this.context, (IssuedTokenKeyBinding)this.keyBinding);
            BuilderResult itbResult = itb.process();
            return itbResult;
        }
        if (PolicyTypeUtil.samlTokenPolicy(this.keyBinding)) {
            ((NamespaceContextEx)this.context.getNamespaceContext()).addSAMLNS();
            SamlTokenBuilder stb = new SamlTokenBuilder(this.context, (AuthenticationTokenPolicy.SAMLAssertionBinding)this.keyBinding, false);
            return stb.process();
        }
        logger.log(Level.SEVERE, LogStringsMessages.WSS_1903_UNSUPPORTED_KEYBINDING_ENCRYPTIONPOLICY(this.keyBinding));
        throw new UnsupportedOperationException("Unsupported Key Binding" + this.keyBinding);
    }
}

