/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.PolicyConstants;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.FilteringStateMachine;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.InvocationProcessingState;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.XmlFilteringUtils;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.stream.XMLStreamWriter;

public class PrivateAttributeFilteringStateMachine
implements FilteringStateMachine {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PrivateAttributeFilteringStateMachine.class);
    private int depth;
    private boolean filteringOn;
    private boolean cmdBufferingOn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationProcessingState getState(Invocation invocation, XMLStreamWriter writer) {
        LOGGER.entering(invocation);
        InvocationProcessingState resultingState = InvocationProcessingState.NO_STATE_CHANGE;
        try {
            switch (invocation.getMethodType()) {
                case WRITE_START_ELEMENT: {
                    if (this.filteringOn) {
                        ++this.depth;
                        break;
                    }
                    if (this.cmdBufferingOn) {
                        resultingState = InvocationProcessingState.RESTART_BUFFERING;
                        break;
                    }
                    this.cmdBufferingOn = true;
                    resultingState = InvocationProcessingState.START_BUFFERING;
                    break;
                }
                case WRITE_END_ELEMENT: {
                    if (this.filteringOn) {
                        if (this.depth == 0) {
                            this.filteringOn = false;
                            resultingState = InvocationProcessingState.STOP_FILTERING;
                            break;
                        }
                        --this.depth;
                        break;
                    }
                    if (!this.cmdBufferingOn) break;
                    this.cmdBufferingOn = false;
                    resultingState = InvocationProcessingState.STOP_BUFFERING;
                    break;
                }
                case WRITE_ATTRIBUTE: {
                    if (this.filteringOn || !this.cmdBufferingOn || !this.startFiltering(invocation, writer)) break;
                    this.filteringOn = true;
                    this.cmdBufferingOn = false;
                    resultingState = InvocationProcessingState.START_FILTERING;
                    break;
                }
                case CLOSE: {
                    if (this.filteringOn) {
                        this.filteringOn = false;
                        resultingState = InvocationProcessingState.STOP_FILTERING;
                        break;
                    }
                    if (!this.cmdBufferingOn) break;
                    this.cmdBufferingOn = false;
                    resultingState = InvocationProcessingState.STOP_BUFFERING;
                    break;
                }
            }
            InvocationProcessingState invocationProcessingState = resultingState;
            return invocationProcessingState;
        }
        finally {
            LOGGER.exiting((Object)resultingState);
        }
    }

    private boolean startFiltering(Invocation invocation, XMLStreamWriter writer) {
        XmlFilteringUtils.AttributeInfo attributeInfo = XmlFilteringUtils.getAttributeNameToWrite(invocation, XmlFilteringUtils.getDefaultNamespaceURI(writer));
        return PolicyConstants.VISIBILITY_ATTRIBUTE.equals(attributeInfo.getName()) && "private".equals(attributeInfo.getValue());
    }
}

